package com.adilhanney.replaceblocksmod.commands;

import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

import static com.adilhanney.replaceblocksmod.ReplaceBlocksUtils.*;
import static net.minecraft.class_2170.*;

public class RemoveGrassCommand {
  public static void initialize() {
    CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register(
        method_9247("removegrass")
            .requires(source -> source.method_9259(1))
            .executes(RemoveGrassCommand::removeGrass)));
  }

  private static final int X_RADIUS = 50;
  private static final int Z_RADIUS = X_RADIUS;
  private static final int Y_RADIUS = 10;

  public static final class_2248 air = class_7923.field_41175.method_10223(class_2960.method_60654("minecraft:air"));
  public static final class_2248 shortGrass = class_7923.field_41175.method_10223(class_2960.method_60654("minecraft:short_grass"));
  public static final class_2248 tallGrass = class_7923.field_41175.method_10223(class_2960.method_60654("minecraft:tall_grass"));

  /**
   * Removes short and tall grass near the player.
   * Does not remove normal grass blocks.
   *
   * @param context The command context
   * @return The number of blocks removed
   */
  public static int removeGrass(CommandContext<class_2168> context) {
    final var source = context.getSource();
    final var player = source.method_44023();
    final var world = source.method_9225();
    final var playerPos = player != null ? player.method_24515() : world.method_43126();

    var removed = 0;
    for (var dx = -X_RADIUS; dx <= X_RADIUS; dx++) {
      for (var dz = -Z_RADIUS; dz <= Z_RADIUS; dz++) {
        for (var dy = -Y_RADIUS; dy <= Y_RADIUS; dy++) {
          final var blockPos = playerPos.method_10069(dx, dy, dz);
          final var oldBlockState = world.method_8320(blockPos);
          if (oldBlockState.method_27852(shortGrass) || oldBlockState.method_27852(tallGrass)) {
            final var newBlockState = air.method_9564();
            class_2248.method_30094(oldBlockState, newBlockState, world, blockPos, class_2248.field_31022);
            ++removed;
          } else if (dy > 0 && oldBlockState.method_26215()) {
            // There probably is no grass above here, so move on to next y
            break;
          }
        }
      }
    }

    final var finalRemoved = removed;
    source.method_9226(() -> {
      final var playerName = getPlayerName(player);
      return class_2561.method_43469(
          "feedback.replaceblocksmod.removedGrass",
          playerName,
          finalRemoved
      );
    }, finalRemoved > 0);
    return finalRemoved;
  }

}
