package com.adilhanney.replaceblocksmod.commands;

import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2257;
import net.minecraft.class_2561;
import net.minecraft.class_2680;

import static com.adilhanney.replaceblocksmod.ReplaceBlocksUtils.*;
import static net.minecraft.class_2170.*;

public abstract class ReplaceBlocksCommand {
  public static void initialize() {
    CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register(
        method_9247("replace")
            .requires(source -> source.method_9259(2))
            .then(method_9244("sourceBlock", class_2257.method_9653(registryAccess))
                .then(method_9247("with")
                    .then(method_9244("targetBlock", class_2257.method_9653(registryAccess))
                        .executes(context -> {
                          final var sourceBlockState = class_2257.method_9655(context, "sourceBlock").method_9494();
                          final var targetBlockState = class_2257.method_9655(context, "targetBlock").method_9494();
                          return replaceBlocks(context, sourceBlockState, targetBlockState);
                        })
                    )))));
  }

  private static final int X_RADIUS = 50;
  private static final int Z_RADIUS = X_RADIUS;
  private static final int Y_RADIUS = 10;

  /**
   * Executes the replace blocks command, replacing all the nearby source blocks
   * with the target block in the game world.
   *
   * @param context          The command context
   * @param sourceBlockState The source block to be replaced
   * @param targetBlockState The desired target block
   * @return The number of blocks replaced
   */
  private static int replaceBlocks(
      CommandContext<class_2168> context,
      class_2680 sourceBlockState,
      class_2680 targetBlockState
  ) {
    final var source = context.getSource();
    final var player = source.method_44023();
    final var sourceBlock = sourceBlockState.method_26204();
    final var targetBlock = targetBlockState.method_26204();

    if (sourceBlockState.method_26215()) {
      // Name and shame the player for griefing
      source.method_9226(() -> {
        final var playerName = getPlayerName(player);
        return class_2561.method_43469(
            "feedback.replaceblocksmod.notReplacingAir",
            targetBlock.method_9518(),
            playerName
        );
      }, true);
      return 0;
    }

    final var world = source.method_9225();
    final var playerPos = player != null ? player.method_24515() : world.method_43126();

    var replaced = 0;
    for (var dx = -X_RADIUS; dx <= X_RADIUS; dx++) {
      for (var dz = -Z_RADIUS; dz <= Z_RADIUS; dz++) {
        for (var dy = -Y_RADIUS; dy <= Y_RADIUS; dy++) {
          final var blockPos = playerPos.method_10069(dx, dy, dz);
          final var oldBlockState = world.method_8320(blockPos);
          if (oldBlockState.method_27852(sourceBlock)) {
            final var newBlockState = createBlockState(targetBlock, blockPos, player);
            class_2248.method_30094(oldBlockState, newBlockState, world, blockPos, class_2248.field_31022);
            ++replaced;
          }
        }
      }
    }

    final var finalReplaced = replaced;
    source.method_9226(() -> {
      final var playerName = getPlayerName(player);
      return class_2561.method_43469(
          "feedback.replaceblocksmod.replacedBlocks",
          playerName,
          finalReplaced,
          sourceBlock.method_9518(),
          targetBlock.method_9518()
      );
    }, finalReplaced > 0);
    return finalReplaced;
  }

}
