/*
 * Decompiled with CFR 0.152.
 */
package com.adilhanney.replaceblocksmod.commands;

import com.adilhanney.replaceblocksmod.ReplaceBlocksUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1936;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2257;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public abstract class ReplaceBlocksCommand {
    private static final int X_RADIUS = 50;
    private static final int Z_RADIUS = 50;
    private static final int Y_RADIUS = 10;

    public static void initialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"replace").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"sourceBlock", (ArgumentType)class_2257.method_9653((class_7157)registryAccess)).then(class_2170.method_9247((String)"with").then(class_2170.method_9244((String)"targetBlock", (ArgumentType)class_2257.method_9653((class_7157)registryAccess)).executes(context -> {
            class_2680 sourceBlockState = class_2257.method_9655((CommandContext)context, (String)"sourceBlock").method_9494();
            class_2680 targetBlockState = class_2257.method_9655((CommandContext)context, (String)"targetBlock").method_9494();
            return ReplaceBlocksCommand.replaceBlocks((CommandContext<class_2168>)context, sourceBlockState, targetBlockState);
        }))))));
    }

    private static int replaceBlocks(CommandContext<class_2168> context, class_2680 sourceBlockState, class_2680 targetBlockState) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        class_2248 sourceBlock = sourceBlockState.method_26204();
        class_2248 targetBlock = targetBlockState.method_26204();
        if (sourceBlockState.method_26215()) {
            source.method_9226(() -> {
                class_5250 playerName = ReplaceBlocksUtils.getPlayerName(player);
                return class_2561.method_43469((String)"feedback.replaceblocksmod.notReplacingAir", (Object[])new Object[]{targetBlock.method_9518(), playerName});
            }, true);
            return 0;
        }
        class_3218 world = source.method_9225();
        class_2338 playerPos = player != null ? player.method_24515() : world.method_43126();
        int replaced = 0;
        for (int dx = -50; dx <= 50; ++dx) {
            for (int dz = -50; dz <= 50; ++dz) {
                for (int dy = -10; dy <= 10; ++dy) {
                    class_2338 blockPos = playerPos.method_10069(dx, dy, dz);
                    class_2680 oldBlockState = world.method_8320(blockPos);
                    if (!oldBlockState.method_27852(sourceBlock)) continue;
                    class_2680 newBlockState = ReplaceBlocksUtils.createBlockState(targetBlock, blockPos, player);
                    class_2248.method_30094((class_2680)oldBlockState, (class_2680)newBlockState, (class_1936)world, (class_2338)blockPos, (int)11);
                    ++replaced;
                }
            }
        }
        int finalReplaced = replaced;
        source.method_9226(() -> {
            class_5250 playerName = ReplaceBlocksUtils.getPlayerName(player);
            return class_2561.method_43469((String)"feedback.replaceblocksmod.replacedBlocks", (Object[])new Object[]{playerName, finalReplaced, sourceBlock.method_9518(), targetBlock.method_9518()});
        }, finalReplaced > 0);
        return finalReplaced;
    }
}

