/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.clazz;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.annoyingvillagers.AnnoyingVillagers;
import com.pla.annoyingvillagers.block.ObsidianBlock;
import com.pla.annoyingvillagers.config.AnnoyingVillagersConfig;
import com.pla.annoyingvillagers.entity.AegisHerobrineEntity;
import com.pla.annoyingvillagers.entity.ArmoredHerobrineEntity;
import com.pla.annoyingvillagers.entity.EliteHerobrineKnockedEntity;
import com.pla.annoyingvillagers.entity.GlaiveHerobrineEntity;
import com.pla.annoyingvillagers.entity.Herobrine7Entity;
import com.pla.annoyingvillagers.entity.HerobrineChrisEntity;
import com.pla.annoyingvillagers.entity.HerobrineCloneEntity;
import com.pla.annoyingvillagers.entity.HerobrineGregEntity;
import com.pla.annoyingvillagers.entity.LowHerobrineCloneEntity;
import com.pla.annoyingvillagers.entity.LowShadowHerobrineCloneEntity;
import com.pla.annoyingvillagers.entity.NullEntity;
import com.pla.annoyingvillagers.entity.ReaperHerobrineEntity;
import com.pla.annoyingvillagers.entity.ShadowHerobrineCloneEntity;
import com.pla.annoyingvillagers.entity.ShadowHerobrineEntity;
import com.pla.annoyingvillagers.entity.SledgehammerHerobrineEntity;
import com.pla.annoyingvillagers.entity.SwordsmanHerobrineEntity;
import com.pla.annoyingvillagers.gameasset.AVAnimations;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModBlocks;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModEntities;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModItems;
import com.pla.annoyingvillagers.network.ClientboundHerobrinePortalFx;
import com.pla.annoyingvillagers.procedures.HerobrineOnInitialSpawnProcedure;
import com.pla.annoyingvillagers.procedures.HerobrinePortalProcedure;
import com.pla.annoyingvillagers.procedures.HerobrineTransfromProcedure;
import com.pla.annoyingvillagers.spawnhandler.HerobrineMobData;
import com.pla.annoyingvillagers.util.CommonGoals;
import java.lang.invoke.LambdaMetafactory;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;

public class HerobrineMob
extends Monster {
    private boolean renderPortal = false;
    private int recallTicks = 0;
    private String chatName;
    private boolean neverRecall = false;
    private UUID gregUUID = null;
    private boolean initialSpawn = true;
    private BlockPos lastFeetPos = null;
    private EliteHerobrineKnockedEntity protectEntity;
    private UUID protectUUID;
    private int healingCooldown = 0;
    private int healingAnimationCooldown = 0;
    private boolean healing = false;
    private final LivingEntityPatch<?> livingentitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this, LivingEntityPatch.class);
    private Entity firstPossessedHerobrine;
    private UUID firstPossessedHerobrineUuid;
    private Entity secondPossessedHerobrine;
    private UUID secondPossessedHerobrineUuid;
    private Entity thirdPossessedHerobrine;
    private UUID thirdPossessedHerobrineUuid;
    private Entity fourthPossessedHerobrine;
    private UUID fourthPossessedHerobrineUuid;

    public Entity getFirstPossessedHerobrine() {
        return this.firstPossessedHerobrine;
    }

    public Entity getSecondPossessedHerobrine() {
        return this.secondPossessedHerobrine;
    }

    public Entity getThirdPossessedHerobrine() {
        return this.thirdPossessedHerobrine;
    }

    public Entity getFourthPossessedHerobrine() {
        return this.fourthPossessedHerobrine;
    }

    public boolean isAvailableSlot() {
        return this.firstPossessedHerobrineUuid == null || this.secondPossessedHerobrineUuid == null || this.thirdPossessedHerobrineUuid == null || this.fourthPossessedHerobrineUuid == null;
    }

    private int getEmptyBoundClone() {
        int returnValue = 0;
        if (this.firstPossessedHerobrineUuid == null) {
            ++returnValue;
        }
        if (this.secondPossessedHerobrineUuid == null) {
            ++returnValue;
        }
        if (this.thirdPossessedHerobrineUuid == null) {
            ++returnValue;
        }
        if (this.fourthPossessedHerobrineUuid == null) {
            ++returnValue;
        }
        return returnValue;
    }

    public boolean boundPossessed(Entity entity) {
        if (this.firstPossessedHerobrineUuid == null) {
            this.firstPossessedHerobrineUuid = entity.m_20148_();
            this.firstPossessedHerobrine = entity;
            return true;
        }
        if (this.secondPossessedHerobrineUuid == null) {
            this.secondPossessedHerobrineUuid = entity.m_20148_();
            this.secondPossessedHerobrine = entity;
            return true;
        }
        if (this.thirdPossessedHerobrineUuid == null) {
            this.thirdPossessedHerobrineUuid = entity.m_20148_();
            this.thirdPossessedHerobrine = entity;
            return true;
        }
        if (this.fourthPossessedHerobrineUuid == null) {
            this.fourthPossessedHerobrineUuid = entity.m_20148_();
            this.fourthPossessedHerobrine = entity;
            return true;
        }
        return false;
    }

    public void setProtectUUID(UUID protectUUID) {
        this.protectUUID = protectUUID;
    }

    public void setProtectEntity(EliteHerobrineKnockedEntity protectEntity) {
        this.protectEntity = protectEntity;
    }

    public void setGregUUID(UUID gregUUID) {
        this.gregUUID = gregUUID;
    }

    public UUID getGregUUID() {
        return this.gregUUID;
    }

    public void setRecallTicks(int recallTicks) {
        this.recallTicks = recallTicks;
    }

    public int getRecallTicks() {
        return this.recallTicks;
    }

    public void setRenderPortal(boolean renderPortal) {
        this.renderPortal = renderPortal;
    }

    public String getChatName() {
        return this.chatName;
    }

    public void setChatName(String chatName) {
        this.chatName = chatName;
    }

    public void setNeverRecall(boolean neverRecall) {
        this.neverRecall = neverRecall;
    }

    public void setInitialSpawn(boolean initialSpawn) {
        this.initialSpawn = initialSpawn;
    }

    public boolean isHealing() {
        return this.healing;
    }

    protected HerobrineMob(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
        this.m_21409_(EquipmentSlot.HEAD, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new Goal(){

            public boolean m_8036_() {
                return HerobrineMob.this.protectEntity != null && HerobrineMob.this.protectEntity.m_6084_() && HerobrineMob.this.m_20270_((Entity)HerobrineMob.this.protectEntity) > 9.0f;
            }

            public void m_8037_() {
                if (HerobrineMob.this.protectEntity != null && HerobrineMob.this.protectEntity.m_6084_()) {
                    HerobrineMob.this.m_21573_().m_5624_((Entity)HerobrineMob.this.protectEntity, 2.0);
                    HerobrineMob.this.m_21563_().m_24960_((Entity)HerobrineMob.this.protectEntity, 30.0f, 30.0f);
                    if (HerobrineMob.this.m_20280_((Entity)HerobrineMob.this.protectEntity) > 10.0) {
                        if (HerobrineMob.this.m_21573_().m_26571_()) {
                            HerobrineMob.this.m_21573_().m_5624_((Entity)HerobrineMob.this.protectEntity, 2.0);
                        }
                    } else {
                        HerobrineMob.this.m_21573_().m_26573_();
                    }
                }
            }

            public boolean m_8045_() {
                return HerobrineMob.this.protectEntity != null && HerobrineMob.this.protectEntity.m_6084_() && (double)HerobrineMob.this.m_20270_((Entity)HerobrineMob.this.protectEntity) > 50.0;
            }
        });
        CommonGoals.registerGoalForHostileNpc(this);
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6785_(double d0) {
        return false;
    }

    public double m_6049_() {
        return -0.35;
    }

    protected void m_7472_(@NotNull DamageSource damagesource, int i, boolean flag) {
        super.m_7472_(damagesource, i, flag);
        this.m_19983_(new ItemStack((ItemLike)Blocks.f_50080_));
    }

    @NotNull
    public SoundEvent m_7975_(DamageSource damagesource) {
        return Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft", "entity.generic.hurt")));
    }

    @NotNull
    public SoundEvent m_5592_() {
        return Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft", "entity.generic.death")));
    }

    public boolean m_142535_(float f, float f1, @NotNull DamageSource damagesource) {
        return super.m_142535_(f, f1, damagesource);
    }

    public boolean m_6469_(@NotNull DamageSource damagesource, float f) {
        if (this.getPersistentData().m_128471_("rising") || this.getPersistentData().m_128471_("sinking") || this.healing) {
            if (!this.m_9236_().m_5776_()) {
                try {
                    this.m_20194_().m_129892_().m_82094_().execute("playsound epicfight:entity.hit.clash neutral @p", (Object)this.m_20203_().m_81324_().m_81325_(4));
                    this.m_20194_().m_129892_().m_82094_().execute("execute at @s run particle epicfight:hit_blade ^ ^1.5 ^0.8 0.1 0.1 0.1 1 1", (Object)this.m_20203_().m_81324_().m_81325_(4));
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
            return false;
        }
        return super.m_6469_(damagesource, f);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.recallTicks = pCompound.m_128451_("RecallTicks");
        this.renderPortal = pCompound.m_128471_("RenderPortal");
        this.neverRecall = pCompound.m_128471_("NeverRecall");
        if (pCompound.m_128441_("GregUUID")) {
            this.gregUUID = pCompound.m_128342_("GregUUID");
        }
        this.initialSpawn = pCompound.m_128471_("InitialSpawn");
        if (pCompound.m_128403_("ProtectUUID")) {
            this.protectUUID = pCompound.m_128342_("ProtectUUID");
        }
        if (pCompound.m_128403_("FirstPossessedHerobrineUuid")) {
            this.firstPossessedHerobrineUuid = pCompound.m_128342_("FirstPossessedHerobrineUuid");
        }
        if (pCompound.m_128403_("SecondPossessedHerobrineUuid")) {
            this.secondPossessedHerobrineUuid = pCompound.m_128342_("SecondPossessedHerobrineUuid");
        }
        if (pCompound.m_128403_("ThirdPossessedHerobrineUuid")) {
            this.thirdPossessedHerobrineUuid = pCompound.m_128342_("ThirdPossessedHerobrineUuid");
        }
        if (pCompound.m_128403_("FourthPossessedHerobrineUuid")) {
            this.fourthPossessedHerobrineUuid = pCompound.m_128342_("FourthPossessedHerobrineUuid");
        }
        this.healingCooldown = pCompound.m_128451_("HealingCooldown");
        this.healing = pCompound.m_128471_("Healing");
        this.healingAnimationCooldown = pCompound.m_128451_("HealingAnimationCooldown");
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("RecallTicks", this.recallTicks);
        pCompound.m_128379_("RenderPortal", this.renderPortal);
        pCompound.m_128379_("NeverRecall", this.neverRecall);
        if (this.gregUUID != null) {
            pCompound.m_128362_("GregUUID", this.gregUUID);
        }
        pCompound.m_128379_("InitialSpawn", this.initialSpawn);
        if (this.protectUUID != null) {
            pCompound.m_128362_("ProtectUUID", this.protectUUID);
        }
        if (this.firstPossessedHerobrineUuid != null) {
            pCompound.m_128362_("FirstPossessedHerobrineUuid", this.firstPossessedHerobrineUuid);
        }
        if (this.secondPossessedHerobrineUuid != null) {
            pCompound.m_128362_("SecondPossessedHerobrineUuid", this.secondPossessedHerobrineUuid);
        }
        if (this.thirdPossessedHerobrineUuid != null) {
            pCompound.m_128362_("ThirdPossessedHerobrineUuid", this.thirdPossessedHerobrineUuid);
        }
        if (this.fourthPossessedHerobrineUuid != null) {
            pCompound.m_128362_("FourthPossessedHerobrineUuid", this.fourthPossessedHerobrineUuid);
        }
        pCompound.m_128405_("HealingCooldown", this.healingCooldown);
        pCompound.m_128379_("Healing", this.healing);
        pCompound.m_128405_("HealingAnimationCooldown", this.healingAnimationCooldown);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new AnyFluidPathNavigation((Mob)this, level);
    }

    private void floatOnAnyFluid() {
        BlockPos pos = this.m_20183_();
        FluidState fluidState = this.m_9236_().m_6425_(pos);
        if (fluidState.m_76178_()) {
            return;
        }
        CollisionContext collisionContext = CollisionContext.m_82750_((Entity)this);
        Fluid typeHere = fluidState.m_76152_();
        FluidState above = this.m_9236_().m_6425_(pos.m_7494_());
        if (collisionContext.m_6513_(LiquidBlock.f_54690_, pos, true) && above.m_76152_() != typeHere) {
            this.m_6853_(true);
            double surfaceY = (float)pos.m_123342_() + fluidState.m_76155_((BlockGetter)this.m_9236_(), pos);
            double bottomY = this.m_20191_().f_82289_;
            double diff = surfaceY - bottomY - 0.001;
            if (diff > 0.0) {
                Vec3 vel = this.m_20184_();
                this.m_20334_(vel.f_82479_, Math.max(vel.f_82480_, Math.min(0.2, diff * 0.2)), vel.f_82481_);
            }
        } else {
            this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
        }
        this.f_19789_ = 0.0f;
    }

    public boolean m_20069_() {
        FluidState fs = this.m_9236_().m_6425_(this.m_20183_());
        if (!fs.m_76178_() && this.m_203441_(fs)) {
            return false;
        }
        return super.m_20069_();
    }

    public boolean m_203441_(FluidState state) {
        return !state.m_76178_();
    }

    public boolean m_6063_() {
        return false;
    }

    private void placeObsidianBlockWhenInWater(Block block) {
        BlockPos feet = this.m_20097_();
        if (this.lastFeetPos == null) {
            this.lastFeetPos = feet;
        }
        if (!feet.equals((Object)this.lastFeetPos)) {
            FluidState fluidState;
            if (!this.m_9236_().m_8055_(this.lastFeetPos).m_60713_(block) && !(fluidState = this.m_9236_().m_6425_(this.lastFeetPos)).m_76178_()) {
                int replace = fluidState.m_205070_(FluidTags.f_13131_) ? 1 : (fluidState.m_205070_(FluidTags.f_13132_) ? 2 : 0);
                this.m_9236_().m_46597_(this.lastFeetPos, (BlockState)block.m_49966_().m_61124_((Property)ObsidianBlock.REPLACE_BY_LIQUID, (Comparable)Integer.valueOf(replace)));
            }
            this.lastFeetPos = feet;
        }
    }

    private void recoverAfterHealing() {
        this.healing = false;
        this.m_21557_(false);
        this.m_21219_();
        this.livingentitypatch.applyStun(StunType.FALL, 0.0f);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 2400, 2));
        this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 2400, 2));
        this.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 2400, 2));
        this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 2400, 2));
    }

    /*
     * Unable to fully structure code
     */
    public void m_8119_() {
        block84: {
            block85: {
                block86: {
                    block88: {
                        block87: {
                            super.m_8119_();
                            this.floatOnAnyFluid();
                            this.m_20101_();
                            if (this.m_9236_().f_46443_) break block84;
                            if (this instanceof HerobrineCloneEntity || this instanceof HerobrineChrisEntity) {
                                this.placeObsidianBlockWhenInWater((Block)AnnoyingVillagersModBlocks.OBSIDIAN_BLOCK.get());
                            } else if (this instanceof ShadowHerobrineCloneEntity || this instanceof Herobrine7Entity || this instanceof ArmoredHerobrineEntity || this instanceof ShadowHerobrineEntity) {
                                this.placeObsidianBlockWhenInWater((Block)AnnoyingVillagersModBlocks.SHADOW_OBSIDIAN_BLOCK.get());
                            } else if (!(this instanceof NullEntity)) {
                                this.placeObsidianBlockWhenInWater((Block)AnnoyingVillagersModBlocks.CRYING_OBSIDIAN_BLOCK.get());
                            }
                            if (this.m_21023_(MobEffects.f_19600_) && this.m_21023_(MobEffects.f_19596_) && this.m_21023_(MobEffects.f_19603_) && this.m_21023_(MobEffects.f_19606_) && new Random().nextBoolean()) {
                                try {
                                    this.m_20194_().m_129892_().m_82094_().execute("execute at @s run particle annoyingvillagers:full_cowl ^ ^ ^ 0.3 1.2 0.3 0 1", (Object)this.m_20203_().m_81324_().m_81325_(4));
                                }
                                catch (CommandSyntaxException var1_1) {
                                    // empty catch block
                                }
                            }
                            if (this.f_19797_ == 1) {
                                if (this.renderPortal) {
                                    AnnoyingVillagers.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with((Supplier<Entity>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$tick$0(), ()Lnet/minecraft/world/entity/Entity;)((HerobrineMob)this)), (Object)new ClientboundHerobrinePortalFx(HerobrinePortalProcedure.finalSurfacePos((Entity)this)));
                                    this.renderPortal = false;
                                }
                                if (this.initialSpawn) {
                                    this.m_21557_(true);
                                    livingentitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this, LivingEntityPatch.class);
                                    if (livingentitypatch != null && !this.m_9236_().m_5776_()) {
                                        if (this instanceof ReaperHerobrineEntity || this instanceof GlaiveHerobrineEntity) {
                                            livingentitypatch.playAnimationSynchronized(AVAnimations.GLOWING_AGONY_GUARD, 0.0f);
                                        } else {
                                            var3_22 = this;
                                            if (var3_22 instanceof AegisHerobrineEntity) {
                                                aegisHerobrineEntity = (AegisHerobrineEntity)var3_22;
                                                aegisHerobrineEntity.getPersistentData().m_128379_("init_animation", true);
                                            } else if (!(this instanceof SledgehammerHerobrineEntity) && !(this instanceof SwordsmanHerobrineEntity)) {
                                                livingentitypatch.playAnimationSynchronized(AVAnimations.HEROBRINE_ANIMATE, 0.0f);
                                            }
                                        }
                                    }
                                    this.initialSpawn = false;
                                }
                            }
                            if (!this.neverRecall) {
                                --this.recallTicks;
                                remaining = this.recallTicks;
                                if (remaining == 40) {
                                    AnnoyingVillagers.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with((Supplier<Entity>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$tick$1(), ()Lnet/minecraft/world/entity/Entity;)((HerobrineMob)this)), (Object)new ClientboundHerobrinePortalFx(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_())));
                                    var3_22 = this.m_9236_();
                                    if (var3_22 instanceof ServerLevel) {
                                        serverLevel = (ServerLevel)var3_22;
                                        try {
                                            this.m_20194_().m_129892_().m_82094_().execute("playsound annoyingvillagers:portal_natural neutral @a ~ ~ ~", (Object)this.m_20203_().m_81324_().m_81325_(4));
                                        }
                                        catch (CommandSyntaxException var3_23) {
                                            // empty catch block
                                        }
                                        HerobrinePortalProcedure.sinkIntoGround(serverLevel, this, 0.06);
                                    }
                                }
                                if (remaining <= 0) {
                                    this.m_9236_().m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)(this.getChatName() + " was sent back to the \u00a74Herobrine Vessel Realm\u00a7r")), false);
                                    this.m_146870_();
                                }
                            }
                            if (this.protectEntity == null && this.protectUUID != null) {
                                entity = ((ServerLevel)this.m_9236_()).m_8791_(this.protectUUID);
                                this.protectEntity = entity instanceof EliteHerobrineKnockedEntity != false ? (eliteHerobrineKnockedEntity = (EliteHerobrineKnockedEntity)entity) : null;
                            }
                            if (this.protectEntity != null && !this.protectEntity.m_6084_()) {
                                this.protectEntity = null;
                                this.protectUUID = null;
                                this.recallTicks = 41;
                            }
                            if (this.firstPossessedHerobrine == null && this.firstPossessedHerobrineUuid != null) {
                                this.firstPossessedHerobrine = entity = ((ServerLevel)this.m_9236_()).m_8791_(this.firstPossessedHerobrineUuid);
                            }
                            if (this.secondPossessedHerobrine == null && this.secondPossessedHerobrineUuid != null) {
                                this.secondPossessedHerobrine = entity = ((ServerLevel)this.m_9236_()).m_8791_(this.secondPossessedHerobrineUuid);
                            }
                            if (this.thirdPossessedHerobrine == null && this.thirdPossessedHerobrineUuid != null) {
                                this.thirdPossessedHerobrine = entity = ((ServerLevel)this.m_9236_()).m_8791_(this.thirdPossessedHerobrineUuid);
                            }
                            if (this.fourthPossessedHerobrine == null && this.fourthPossessedHerobrineUuid != null) {
                                this.fourthPossessedHerobrine = entity = ((ServerLevel)this.m_9236_()).m_8791_(this.fourthPossessedHerobrineUuid);
                            }
                            if (this.firstPossessedHerobrine != null && !this.firstPossessedHerobrine.m_6084_()) {
                                this.firstPossessedHerobrine = null;
                                this.firstPossessedHerobrineUuid = null;
                                if (this.healing && this.getEmptyBoundClone() == 4) {
                                    this.recoverAfterHealing();
                                }
                            }
                            if (this.secondPossessedHerobrine != null && !this.secondPossessedHerobrine.m_6084_()) {
                                this.secondPossessedHerobrine = null;
                                this.secondPossessedHerobrineUuid = null;
                                if (this.healing && this.getEmptyBoundClone() == 4) {
                                    this.recoverAfterHealing();
                                }
                            }
                            if (this.thirdPossessedHerobrine != null && !this.thirdPossessedHerobrine.m_6084_()) {
                                this.thirdPossessedHerobrine = null;
                                this.thirdPossessedHerobrineUuid = null;
                                if (this.healing && this.getEmptyBoundClone() == 4) {
                                    this.recoverAfterHealing();
                                }
                            }
                            if (this.fourthPossessedHerobrine != null && !this.fourthPossessedHerobrine.m_6084_()) {
                                this.fourthPossessedHerobrine = null;
                                this.fourthPossessedHerobrineUuid = null;
                                if (this.healing && this.getEmptyBoundClone() >= 4) {
                                    this.recoverAfterHealing();
                                }
                            }
                            if (!this.healing && this.healingCooldown > 0) {
                                --this.healingCooldown;
                            }
                            if (!(this.m_21223_() <= Math.max((float)((Integer)AnnoyingVillagersConfig.HEROBRINE_HEALING_HEALTH_TRIGGER.get()).intValue() / 100.0f * this.m_21233_(), 10.0f)) || this.healing || this.healingCooldown != 0) break block85;
                            if (!(this instanceof ShadowHerobrineEntity) && !(this instanceof NullEntity) && !(this instanceof AegisHerobrineEntity) && !(this instanceof SwordsmanHerobrineEntity) && !(this instanceof GlaiveHerobrineEntity) && !(this instanceof ReaperHerobrineEntity) && !(this instanceof SledgehammerHerobrineEntity)) break block86;
                            if (this.getEmptyBoundClone() > 0) {
                                this.summonClonesByAmount(this.getEmptyBoundClone());
                            }
                            this.healingAnimationCooldown = 60;
                            if (this.gregUUID == null) break block87;
                            serverLevel = (ServerLevel)this.m_9236_();
                            entity = serverLevel.m_8791_(this.gregUUID);
                            if (!(entity instanceof HerobrineGregEntity)) ** GOTO lbl-1000
                            herobrineGregEntity = (HerobrineGregEntity)entity;
                            if (entity.m_6084_()) {
                                try {
                                    herobrineGregEntity.m_20194_().m_129892_().m_82094_().execute("playsound annoyingvillagers:greg_requesting_assistance voice @a ~ ~ ~", (Object)this.m_20203_().m_81324_().m_81325_(4));
                                }
                                catch (CommandSyntaxException var4_25) {
                                    // empty catch block
                                }
                                herobrineGregEntity.m_9236_().m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)("<" + Component.m_237115_((String)"entity.annoyingvillagers.herobrine_greg").getString() + "> " + Component.m_237115_((String)"subtitles.herobrine_request").getString())), false);
                                herobrineGregEntity.m_21557_(true);
                            } else lbl-1000:
                            // 2 sources

                            {
                                try {
                                    this.m_20194_().m_129892_().m_82094_().execute("playsound annoyingvillagers:self_requesting_assistance voice @a ~ ~ ~", (Object)this.m_20203_().m_81324_().m_81325_(4));
                                }
                                catch (CommandSyntaxException var4_26) {
                                    // empty catch block
                                }
                                this.m_9236_().m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)("<" + this.getChatName() + "> " + Component.m_237115_((String)"subtitles.herobrine_request").getString())), false);
                            }
                            break block88;
                        }
                        try {
                            this.m_20194_().m_129892_().m_82094_().execute("playsound annoyingvillagers:self_requesting_assistance voice @a ~ ~ ~", (Object)this.m_20203_().m_81324_().m_81325_(4));
                        }
                        catch (CommandSyntaxException serverLevel) {
                            // empty catch block
                        }
                        this.m_9236_().m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)("<" + this.getChatName() + "> " + Component.m_237115_((String)"subtitles.herobrine_request").getString())), false);
                    }
                    this.healingCooldown = AnnoyingVillagersConfig.HEROBRINE_HEALING_MIN_COOLDOWN.get() == AnnoyingVillagersConfig.HEROBRINE_HEALING_MAX_COOLDOWN.get() ? (Integer)AnnoyingVillagersConfig.HEROBRINE_HEALING_MIN_COOLDOWN.get() * 1200 : new Random().nextInt((Integer)AnnoyingVillagersConfig.HEROBRINE_HEALING_MIN_COOLDOWN.get() * 1200, (Integer)AnnoyingVillagersConfig.HEROBRINE_HEALING_MAX_COOLDOWN.get() * 1200);
                    break block85;
                }
                if (this.getEmptyBoundClone() != 4) {
                    this.healingAnimationCooldown = 60;
                    try {
                        this.m_20194_().m_129892_().m_82094_().execute("playsound annoyingvillagers:self_requesting_assistance voice @a ~ ~ ~", (Object)this.m_20203_().m_81324_().m_81325_(4));
                    }
                    catch (CommandSyntaxException serverLevel) {
                        // empty catch block
                    }
                    this.m_9236_().m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)("<" + this.getChatName() + "> " + Component.m_237115_((String)"subtitles.herobrine_request").getString())), false);
                    this.healingCooldown = AnnoyingVillagersConfig.HEROBRINE_HEALING_MIN_COOLDOWN.get() == AnnoyingVillagersConfig.HEROBRINE_HEALING_MAX_COOLDOWN.get() ? (Integer)AnnoyingVillagersConfig.HEROBRINE_HEALING_MIN_COOLDOWN.get() * 1200 : new Random().nextInt((Integer)AnnoyingVillagersConfig.HEROBRINE_HEALING_MIN_COOLDOWN.get() * 1200, (Integer)AnnoyingVillagersConfig.HEROBRINE_HEALING_MAX_COOLDOWN.get() * 1200);
                }
            }
            if (this.healingAnimationCooldown > 0) {
                --this.healingAnimationCooldown;
            }
            if (this.healingAnimationCooldown == 50) {
                this.healing = true;
                this.m_21557_(true);
                if (this.gregUUID != null && (entity = (serverLevel = (ServerLevel)this.m_9236_()).m_8791_(this.gregUUID)) instanceof HerobrineGregEntity) {
                    herobrineGregEntity = (HerobrineGregEntity)entity;
                    if (entity.m_6084_() && herobrineGregEntity.getLivingentitypatch() != null) {
                        herobrineGregEntity.getLivingentitypatch().playAnimationSynchronized(AVAnimations.PORTAL_SUMMON, 0.0f);
                    }
                }
            }
            if (this.healingAnimationCooldown == 10) {
                this.healing = true;
                this.m_21557_(true);
                if (this.gregUUID != null && (entity = (serverLevel = (ServerLevel)this.m_9236_()).m_8791_(this.gregUUID)) instanceof HerobrineGregEntity) {
                    herobrineGregEntity = (HerobrineGregEntity)entity;
                    if (entity.m_6084_()) {
                        herobrineGregEntity.m_21557_(false);
                    }
                }
                this.m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 10, 3, false, false));
                if (this.firstPossessedHerobrine != null) {
                    ((Mob)this.firstPossessedHerobrine).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 30, 3, false, false));
                    this.clearHandAndDropItem(this.firstPossessedHerobrine);
                    var3_22 = this.firstPossessedHerobrine;
                    if (var3_22 instanceof LowHerobrineCloneEntity) {
                        lowHerobrineCloneEntity = (LowHerobrineCloneEntity)var3_22;
                        lowHerobrineCloneEntity.setSacrificing(true);
                    } else {
                        var3_22 = this.firstPossessedHerobrine;
                        if (var3_22 instanceof LowShadowHerobrineCloneEntity) {
                            lowShadowHerobrineCloneEntity = (LowShadowHerobrineCloneEntity)var3_22;
                            lowShadowHerobrineCloneEntity.setSacrificing(true);
                        }
                    }
                    this.firstPossessedHerobrine.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()));
                    try {
                        this.firstPossessedHerobrine.m_20194_().m_129892_().m_82094_().execute("playsound annoyingvillagers:herobrine_understood voice @a ~ ~ ~", (Object)this.firstPossessedHerobrine.m_20203_().m_81324_().m_81325_(4));
                    }
                    catch (CommandSyntaxException lowHerobrineCloneEntity) {
                        // empty catch block
                    }
                }
                if (this.secondPossessedHerobrine != null) {
                    ((Mob)this.secondPossessedHerobrine).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 10, 3, false, false));
                    this.clearHandAndDropItem(this.secondPossessedHerobrine);
                    var3_22 = this.secondPossessedHerobrine;
                    if (var3_22 instanceof LowHerobrineCloneEntity) {
                        lowHerobrineCloneEntity = (LowHerobrineCloneEntity)var3_22;
                        lowHerobrineCloneEntity.setSacrificing(true);
                    } else {
                        var3_22 = this.secondPossessedHerobrine;
                        if (var3_22 instanceof LowShadowHerobrineCloneEntity) {
                            lowShadowHerobrineCloneEntity = (LowShadowHerobrineCloneEntity)var3_22;
                            lowShadowHerobrineCloneEntity.setSacrificing(true);
                        }
                    }
                    this.secondPossessedHerobrine.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()));
                    try {
                        this.secondPossessedHerobrine.m_20194_().m_129892_().m_82094_().execute("playsound annoyingvillagers:herobrine_understood voice @a ~ ~ ~", (Object)this.secondPossessedHerobrine.m_20203_().m_81324_().m_81325_(4));
                    }
                    catch (CommandSyntaxException lowHerobrineCloneEntity) {
                        // empty catch block
                    }
                }
                if (this.thirdPossessedHerobrine != null) {
                    ((Mob)this.thirdPossessedHerobrine).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 10, 3, false, false));
                    this.clearHandAndDropItem(this.thirdPossessedHerobrine);
                    var3_22 = this.thirdPossessedHerobrine;
                    if (var3_22 instanceof LowHerobrineCloneEntity) {
                        lowHerobrineCloneEntity = (LowHerobrineCloneEntity)var3_22;
                        lowHerobrineCloneEntity.setSacrificing(true);
                    } else {
                        var3_22 = this.thirdPossessedHerobrine;
                        if (var3_22 instanceof LowShadowHerobrineCloneEntity) {
                            lowShadowHerobrineCloneEntity = (LowShadowHerobrineCloneEntity)var3_22;
                            lowShadowHerobrineCloneEntity.setSacrificing(true);
                        }
                    }
                    this.thirdPossessedHerobrine.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()));
                    this.thirdPossessedHerobrine.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()));
                    try {
                        this.thirdPossessedHerobrine.m_20194_().m_129892_().m_82094_().execute("playsound annoyingvillagers:herobrine_understood voice @a ~ ~ ~", (Object)this.thirdPossessedHerobrine.m_20203_().m_81324_().m_81325_(4));
                    }
                    catch (CommandSyntaxException lowHerobrineCloneEntity) {
                        // empty catch block
                    }
                }
                if (this.fourthPossessedHerobrine != null) {
                    ((Mob)this.fourthPossessedHerobrine).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 10, 3, false, false));
                    this.clearHandAndDropItem(this.fourthPossessedHerobrine);
                    var3_22 = this.fourthPossessedHerobrine;
                    if (var3_22 instanceof LowHerobrineCloneEntity) {
                        lowHerobrineCloneEntity = (LowHerobrineCloneEntity)var3_22;
                        lowHerobrineCloneEntity.setSacrificing(true);
                    } else {
                        var3_22 = this.fourthPossessedHerobrine;
                        if (var3_22 instanceof LowShadowHerobrineCloneEntity) {
                            lowShadowHerobrineCloneEntity = (LowShadowHerobrineCloneEntity)var3_22;
                            lowShadowHerobrineCloneEntity.setSacrificing(true);
                        }
                    }
                    this.fourthPossessedHerobrine.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()));
                    try {
                        this.fourthPossessedHerobrine.m_20194_().m_129892_().m_82094_().execute("playsound annoyingvillagers:herobrine_understood voice @a ~ ~ ~", (Object)this.fourthPossessedHerobrine.m_20203_().m_81324_().m_81325_(4));
                    }
                    catch (CommandSyntaxException var1_21) {
                        // empty catch block
                    }
                }
            }
            if (this.healing && this.healingAnimationCooldown == 0) {
                if (this.getEmptyBoundClone() == 4) {
                    this.m_21557_(false);
                    return;
                }
                this.m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 1, 3, false, false));
                if (this.livingentitypatch != null) {
                    this.livingentitypatch.playAnimationSynchronized(AVAnimations.HEROBRINE_HEALING, 0.0f);
                }
            }
        }
    }

    private void clearHandAndDropItem(Entity entity) {
        ItemEntity itementity;
        ItemStack itemstack;
        Level level;
        Level levelaccessor1 = this.m_9236_();
        LivingEntity livingentity = (LivingEntity)entity;
        if (levelaccessor1 instanceof Level && !(level = levelaccessor1).m_5776_()) {
            itemstack = livingentity.m_21205_();
            itementity = new ItemEntity(level, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), itemstack);
            itementity.m_32010_(10);
            level.m_7967_((Entity)itementity);
            ((LivingEntity)entity).m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        if (levelaccessor1 instanceof Level && !(level = levelaccessor1).m_5776_()) {
            itemstack = livingentity.m_21206_();
            itementity = new ItemEntity(level, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), itemstack);
            itementity.m_32010_(10);
            level.m_7967_((Entity)itementity);
            ((LivingEntity)entity).m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
    }

    private void summonClonesByAmount(int amount) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        float yaw = this.m_146908_();
        Vec3 forward = Vec3.m_82498_((float)0.0f, (float)yaw).m_82541_();
        Vec3 right = new Vec3(-forward.f_82481_, 0.0, forward.f_82479_).m_82541_();
        double fwdDist = Math.max(10.0, (double)this.m_20205_() * 10.0);
        double sideDist = Math.max(10.0, (double)this.m_20205_() * 10.0);
        double y = this.m_20186_() + 0.01;
        Vec3 posFront = this.m_20182_().m_82549_(forward.m_82490_(fwdDist));
        Vec3 posBack = this.m_20182_().m_82546_(forward.m_82490_(fwdDist));
        Vec3 posLeft = this.m_20182_().m_82546_(right.m_82490_(sideDist));
        Vec3 posRight = this.m_20182_().m_82549_(right.m_82490_(sideDist));
        switch (amount) {
            case 1: {
                this.summonLowCloneAt(server, new Vec3(posFront.f_82479_, y, posFront.f_82481_));
                break;
            }
            case 2: {
                this.summonLowCloneAt(server, new Vec3(posLeft.f_82479_, y, posLeft.f_82481_));
                this.summonLowCloneAt(server, new Vec3(posRight.f_82479_, y, posRight.f_82481_));
                break;
            }
            case 3: {
                this.summonLowCloneAt(server, new Vec3(posFront.f_82479_, y, posFront.f_82481_));
                this.summonLowCloneAt(server, new Vec3(posLeft.f_82479_, y, posLeft.f_82481_));
                this.summonLowCloneAt(server, new Vec3(posRight.f_82479_, y, posRight.f_82481_));
                break;
            }
            case 4: {
                this.summonLowCloneAt(server, new Vec3(posFront.f_82479_, y, posFront.f_82481_));
                this.summonLowCloneAt(server, new Vec3(posLeft.f_82479_, y, posLeft.f_82481_));
                this.summonLowCloneAt(server, new Vec3(posRight.f_82479_, y, posRight.f_82481_));
                this.summonLowCloneAt(server, new Vec3(posBack.f_82479_, y, posBack.f_82481_));
                break;
            }
        }
    }

    private ItemStack randomDamage(ItemStack itemStack) {
        int maxDamage = itemStack.m_41776_();
        itemStack.m_41721_(new Random().nextInt(maxDamage / 3, maxDamage * 3 / 4));
        return itemStack;
    }

    private void equipGearForLowClone(Mob mob) {
        if (this.f_19796_.m_188501_() < 0.3f) {
            mob.m_8061_(EquipmentSlot.HEAD, this.randomDamage(new ItemStack((ItemLike)AnnoyingVillagersModItems.BROKEN_DIAMOND_HELMET.get())));
        }
        if (this.f_19796_.m_188501_() < 0.3f) {
            mob.m_8061_(EquipmentSlot.CHEST, this.randomDamage(new ItemStack((ItemLike)AnnoyingVillagersModItems.BROKEN_DIAMOND_CHESTPLATE.get())));
        }
        if (this.f_19796_.m_188501_() < 0.3f) {
            mob.m_8061_(EquipmentSlot.LEGS, this.randomDamage(new ItemStack((ItemLike)AnnoyingVillagersModItems.BROKEN_DIAMOND_LEGGINGS.get())));
        }
        if (this.f_19796_.m_188501_() < 0.3f) {
            mob.m_8061_(EquipmentSlot.FEET, this.randomDamage(new ItemStack((ItemLike)AnnoyingVillagersModItems.BROKEN_DIAMOND_BOOTS.get())));
        }
    }

    private void summonLowCloneAt(ServerLevel server, Vec3 pos) {
        Object clone = this instanceof ShadowHerobrineEntity || this instanceof NullEntity ? new LowShadowHerobrineCloneEntity((EntityType<LowShadowHerobrineCloneEntity>)((EntityType)AnnoyingVillagersModEntities.LOW_SHADOW_HEROBRINE_CLONE.get()), (Level)server) : new LowHerobrineCloneEntity((EntityType<? extends LowHerobrineCloneEntity>)((EntityType)AnnoyingVillagersModEntities.LOW_HEROBRINE_CLONE.get()), (Level)server);
        int surfaceY = server.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BlockPos.m_274446_((Position)pos)).m_123342_();
        clone.m_7678_(pos.f_82479_, (double)surfaceY, pos.f_82481_, this.m_146908_(), this.m_146909_());
        if (clone instanceof LowShadowHerobrineCloneEntity) {
            Object lowShadowHerobrineCloneEntity = clone;
            ((LowShadowHerobrineCloneEntity)((Object)lowShadowHerobrineCloneEntity)).setRenderPortal(true);
            ((LowShadowHerobrineCloneEntity)((Object)lowShadowHerobrineCloneEntity)).setPossessedByEntity(this);
            ((LowShadowHerobrineCloneEntity)((Object)lowShadowHerobrineCloneEntity)).setPossessedByUuid(this.m_20148_());
        } else {
            LowHerobrineCloneEntity lowHerobrineCloneEntity = (LowHerobrineCloneEntity)((Object)clone);
            lowHerobrineCloneEntity.setRenderPortal(true);
            lowHerobrineCloneEntity.setPossessedByEntity(this);
            lowHerobrineCloneEntity.setPossessedByUuid(this.m_20148_());
        }
        this.equipGearForLowClone((Mob)clone);
        server.m_7967_((Entity)clone);
        clone.m_21557_(true);
        try {
            clone.m_20194_().m_129892_().m_82094_().execute("playsound annoyingvillagers:portal_natural neutral @a ~ ~ ~", (Object)clone.m_20203_().m_81324_().m_81325_(4));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        Level level;
        super.m_142687_(reason);
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (reason == Entity.RemovalReason.KILLED || reason == Entity.RemovalReason.DISCARDED) {
                HerobrineMobData.get(serverLevel).releaseIfMatches(serverLevel, this.m_20148_());
            }
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverlevelaccessor, DifficultyInstance difficultyinstance, MobSpawnType mobspawntype, @Nullable SpawnGroupData spawngroupdata, @Nullable CompoundTag compoundtag) {
        if (mobspawntype == MobSpawnType.NATURAL || mobspawntype == MobSpawnType.CHUNK_GENERATION) {
            ServerLevel serverLevel = serverlevelaccessor.m_6018_();
            HerobrineMobData herobrineMobData = HerobrineMobData.get(serverLevel);
            if (!herobrineMobData.tryClaim(serverLevel, this.m_20148_())) {
                this.m_146870_();
                return null;
            }
            BlockPos blockPos = this.m_20097_();
            int surfaceY = serverLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, blockPos).m_123342_();
            BlockPos spawnPos = new BlockPos(blockPos.m_123341_(), surfaceY, blockPos.m_123343_());
            this.m_20035_(spawnPos, this.m_146908_(), this.m_146909_());
            this.initialSpawn = false;
        }
        SpawnGroupData spawngroupdata1 = super.m_6518_(serverlevelaccessor, difficultyinstance, mobspawntype, spawngroupdata, compoundtag);
        HerobrineOnInitialSpawnProcedure.execute((LevelAccessor)serverlevelaccessor, (Entity)this, this.recallTicks, mobspawntype);
        return spawngroupdata1;
    }

    public void m_5993_(Entity entity, int i, DamageSource damagesource) {
        super.m_5993_(entity, i, damagesource);
        HerobrineTransfromProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), entity, (Entity)this);
    }

    private /* synthetic */ Entity lambda$tick$1() {
        return this;
    }

    private /* synthetic */ Entity lambda$tick$0() {
        return this;
    }

    public static class AnyFluidPathNavigation
    extends GroundPathNavigation {
        public AnyFluidPathNavigation(Mob mob, Level level) {
            super(mob, level);
        }

        @NotNull
        protected PathFinder m_5532_(int maxVisitedNodes) {
            this.f_26508_ = new WalkNodeEvaluator();
            this.f_26508_.m_77351_(true);
            return new PathFinder(this.f_26508_, maxVisitedNodes);
        }

        protected boolean m_7367_(@NotNull BlockPathTypes type) {
            if (type == BlockPathTypes.WATER || type == BlockPathTypes.WATER_BORDER || type == BlockPathTypes.LAVA || type == BlockPathTypes.DANGER_FIRE || type == BlockPathTypes.DAMAGE_FIRE) {
                return true;
            }
            return super.m_7367_(type);
        }

        public boolean m_6342_(@NotNull BlockPos blockPos) {
            return this.f_26495_.m_6425_(blockPos).m_76152_() != Fluids.f_76191_ || super.m_6342_(blockPos);
        }
    }
}

