/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.pla.annoyingvillagers.client.model.ModelSnakeBlade;
import com.pla.annoyingvillagers.client.model.ModelSnakeBladeFragment;
import com.pla.annoyingvillagers.entity.SnakeBladeEntity;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModItems;
import com.pla.annoyingvillagers.util.SnakeBladeHit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;

public class SnakeBladeRenderer
extends EntityRenderer<SnakeBladeEntity> {
    private static final ResourceLocation SNAKE_BLADE_TEXTURE = new ResourceLocation("annoyingvillagers", "textures/entities/snake_blade.png");
    private static final ResourceLocation FRAGMENT_CHAIN_TEXTURE = new ResourceLocation("annoyingvillagers", "textures/entities/fragment_chain.png");
    private static ModelSnakeBlade snakeBladeModel;
    private static ModelSnakeBladeFragment tongueModel;
    public static final int MAX_NECK_SEGMENTS = 128;
    private static final float FRAG_LEN = 0.6f;
    private static final float HEAD_CLEAR = 0.35f;

    public SnakeBladeRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
        ModelPart fragRoot = renderManagerIn.m_174023_(ModelSnakeBladeFragment.LAYER_LOCATION);
        tongueModel = new ModelSnakeBladeFragment(fragRoot);
        ModelPart bladeRoot = renderManagerIn.m_174023_(ModelSnakeBlade.LAYER_LOCATION);
        snakeBladeModel = new ModelSnakeBlade(bladeRoot);
    }

    public boolean shouldRender(SnakeBladeEntity entity, Frustum frustum, double x, double y, double z) {
        Entity next = entity.getFromEntity();
        return next != null && frustum.m_113029_(entity.m_20191_().m_82367_(next.m_20191_())) || super.m_5523_((Entity)entity, frustum, x, y, z);
    }

    public void render(SnakeBladeEntity entity, float pEntityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        super.m_7392_((Entity)entity, pEntityYaw, partialTicks, poseStack, buffer, light);
        poseStack.m_85836_();
        Entity fromEntity = entity.getFromEntity();
        float x = (float)Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_());
        float y = (float)Mth.m_14139_((double)partialTicks, (double)entity.f_19855_, (double)entity.m_20186_());
        float z = (float)Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_());
        if (fromEntity != null) {
            double step;
            float progress = (entity.prevProgress + (entity.getProgress() - entity.prevProgress) * partialTicks) / 5.0f;
            float tipOffset = 1.8f;
            Vec3 swordPos = SnakeBladeHit.getToolTipPos(fromEntity, partialTicks, tipOffset);
            Vec3 distVec = swordPos != null ? swordPos.m_82492_((double)x, (double)(y + 1.2f), (double)z) : this.getPositionOfPriorMob(entity, fromEntity, partialTicks).m_82492_((double)x, (double)y, (double)z);
            Vec3 to = distVec.m_82490_((double)(1.0f - progress));
            Vec3 from = distVec;
            int segmentCount = 0;
            Vec3 currentNeckButt = from;
            VertexConsumer snakebladeFragmentConsumer = entity.isEnchanted() ? ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)RenderType.m_110458_((ResourceLocation)FRAGMENT_CHAIN_TEXTURE), (boolean)true, (boolean)true) : buffer.m_6299_(RenderType.m_110458_((ResourceLocation)FRAGMENT_CHAIN_TEXTURE));
            double distanceLeft = from.m_82554_(to);
            for (double buildUpTo = Math.max(0.0, distanceLeft - (double)0.35f); segmentCount < 128 && buildUpTo > 0.001; buildUpTo -= step, ++segmentCount) {
                step = Math.min(buildUpTo, (double)0.6f);
                Vec3 dir = to.m_82546_(currentNeckButt);
                Vec3 next = dir.m_82541_().m_82490_(step).m_82549_(currentNeckButt);
                int neckLight = this.getLightColor(entity, next.m_82520_((double)x, (double)y, (double)z));
                SnakeBladeRenderer.renderNeckCube(currentNeckButt, next, poseStack, snakebladeFragmentConsumer, neckLight, OverlayTexture.f_118083_, 0.0f);
                currentNeckButt = next;
            }
            VertexConsumer snakeBladeComsumer = entity.isEnchanted() ? ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)RenderType.m_110458_((ResourceLocation)SNAKE_BLADE_TEXTURE), (boolean)true, (boolean)true) : buffer.m_6299_(RenderType.m_110458_((ResourceLocation)SNAKE_BLADE_TEXTURE));
            if (entity.hasBlade() || entity.isRetracting()) {
                poseStack.m_85836_();
                poseStack.m_85837_(to.f_82479_, to.f_82480_, to.f_82481_);
                Vec3 headDir = to.m_82546_(currentNeckButt);
                float rotY = (float)(Mth.m_14136_((double)headDir.f_82479_, (double)headDir.f_82481_) * 180.0 / Math.PI);
                float rotX = (float)(-Mth.m_14136_((double)headDir.f_82480_, (double)headDir.m_165924_()) * 180.0 / Math.PI);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rotY));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(rotX));
                snakeBladeModel.m_7695_(poseStack, snakeBladeComsumer, this.getLightColor(entity, to.m_82520_((double)x, (double)y, (double)z)), OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                poseStack.m_85849_();
            }
        }
        poseStack.m_85849_();
    }

    public static void renderNeckCube(Vec3 from, Vec3 to, PoseStack poseStack, VertexConsumer buffer, int packedLightIn, int overlayCoords, float additionalYaw) {
        Vec3 dir = to.m_82546_(from);
        float yaw = (float)(Mth.m_14136_((double)dir.f_82479_, (double)dir.f_82481_) * 57.29577951308232);
        float pitch = (float)(-Mth.m_14136_((double)dir.f_82480_, (double)dir.m_165924_()) * 57.29577951308232);
        poseStack.m_85836_();
        poseStack.m_85837_(from.f_82479_, from.f_82480_, from.f_82481_);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(yaw + additionalYaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        tongueModel.m_7695_(poseStack, buffer, packedLightIn, overlayCoords, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    private Vec3 getPositionOfPriorMob(SnakeBladeEntity segment, Entity mob, float partialTicks) {
        double d4 = Mth.m_14139_((double)partialTicks, (double)mob.f_19854_, (double)mob.m_20185_());
        double d5 = Mth.m_14139_((double)partialTicks, (double)mob.f_19855_, (double)mob.m_20186_());
        double d6 = Mth.m_14139_((double)partialTicks, (double)mob.f_19856_, (double)mob.m_20189_());
        float f3 = 0.0f;
        if (mob instanceof Player && segment.isCreator(mob)) {
            Player player = (Player)mob;
            float f = player.m_21324_(partialTicks);
            float f1 = Mth.m_14031_((float)(Mth.m_14116_((float)f) * (float)Math.PI));
            float f2 = Mth.m_14179_((float)partialTicks, (float)player.f_20884_, (float)player.f_20883_) * ((float)Math.PI / 180);
            int i = player.m_5737_() == HumanoidArm.RIGHT ? 1 : -1;
            ItemStack itemstack = player.m_21205_();
            if (!itemstack.m_150930_((Item)AnnoyingVillagersModItems.DEMONIAC_VOLTAGE_REAVER.get())) {
                i = -i;
            }
            double d0 = Mth.m_14031_((float)f2);
            double d1 = Mth.m_14089_((float)f2);
            double d2 = (double)i * 0.35;
            if ((this.f_114476_.f_114360_ == null || this.f_114476_.f_114360_.m_92176_().m_90612_()) && player == Minecraft.m_91087_().f_91074_) {
                double d7 = 960.0 / (double)((Integer)this.f_114476_.f_114360_.m_231837_().m_231551_()).intValue();
                Vec3 vec3 = this.f_114476_.f_114358_.m_167684_().m_167695_((float)i * 0.6f, -1.0f);
                vec3 = vec3.m_82490_(d7);
                vec3 = vec3.m_82524_(f1 * 0.25f);
                vec3 = vec3.m_82496_(-f1 * 0.35f);
                d4 = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) + vec3.f_82479_;
                d5 = Mth.m_14139_((double)partialTicks, (double)player.f_19855_, (double)player.m_20186_()) + vec3.f_82480_;
                d6 = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) + vec3.f_82481_;
                f3 = player.m_20192_() * 0.5f;
            } else {
                d4 = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) - d1 * d2 - d0 * 0.2;
                d5 = player.f_19855_ + (double)player.m_20192_() + (player.m_20186_() - player.f_19855_) * (double)partialTicks - 1.0;
                d6 = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) - d0 * d2 + d1 * 0.2;
                f3 = (player.m_6047_() ? -0.1875f : 0.0f) - player.m_20192_() * 0.4f;
            }
        }
        return new Vec3(d4, d5 + (double)f3, d6);
    }

    private int getLightColor(Entity head, Vec3 vec3) {
        Vec3i vec3i = new Vec3i(Mth.m_14107_((double)vec3.f_82479_), Mth.m_14107_((double)vec3.f_82480_), Mth.m_14107_((double)vec3.f_82481_));
        BlockPos blockpos = new BlockPos(vec3i);
        if (head.m_9236_().m_46805_(blockpos)) {
            int i = LevelRenderer.m_109541_((BlockAndTintGetter)head.m_9236_(), (BlockPos)blockpos);
            int j = LevelRenderer.m_109541_((BlockAndTintGetter)head.m_9236_(), (BlockPos)blockpos.m_7494_());
            int k = i & 0xFF;
            int l = j & 0xFF;
            int i1 = i >> 16 & 0xFF;
            int j1 = j >> 16 & 0xFF;
            return (k > l ? k : l) | (i1 > j1 ? i1 : j1) << 16;
        }
        return 0;
    }

    public ResourceLocation getTextureLocation(SnakeBladeEntity entity) {
        return SNAKE_BLADE_TEXTURE;
    }
}

