/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.compat.aaa_particles;

import com.pla.annoyingvillagers.entity.BabyEnderDragonEntity;
import java.lang.ref.WeakReference;
import java.util.Optional;
import mod.chloeprime.aaaparticles.api.client.effekseer.ParticleEmitter;
import mod.chloeprime.aaaparticles.api.common.DynamicParameter;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import mod.chloeprime.aaaparticles.client.installer.NativePlatform;
import mod.chloeprime.aaaparticles.client.registry.EffectRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BabyDragonBeamParticleEmitterInfo
extends ParticleEmitterInfo {
    private WeakReference<BabyEnderDragonEntity> casterRef = new WeakReference<Object>(null);
    private WeakReference<LivingEntity> targetRef = new WeakReference<Object>(null);
    private int durationTicks = 0;
    private ForwardAxis axis = ForwardAxis.PLUS_Z;
    private float roll = 0.0f;
    private Vec3 lastTargetPos = null;

    public BabyDragonBeamParticleEmitterInfo(ResourceLocation effek) {
        super(effek);
    }

    public BabyDragonBeamParticleEmitterInfo fromTo(Vec3 from, Vec3 to, ForwardAxis axis, float extraRollRad) {
        this.position(from.f_82479_, from.f_82480_, from.f_82481_);
        this.axis = axis;
        this.roll = extraRollRad;
        this.lastTargetPos = to;
        Vec3 d = to.m_82546_(from);
        double xz = Math.sqrt(d.f_82479_ * d.f_82479_ + d.f_82481_ * d.f_82481_);
        switch (axis) {
            case PLUS_Z: {
                float yaw = (float)Math.atan2(d.f_82479_, d.f_82481_);
                float pitch = (float)(-Math.atan2(d.f_82480_, xz));
                this.rotation(pitch, yaw, extraRollRad);
                break;
            }
            case PLUS_Y: {
                float yaw = (float)Math.atan2(d.f_82481_, d.f_82479_) + 1.5707964f;
                float pitch = (float)Math.atan2(xz, d.f_82480_) - 1.5707964f;
                this.rotation(pitch, yaw, extraRollRad);
            }
        }
        return this;
    }

    public BabyDragonBeamParticleEmitterInfo follow(BabyEnderDragonEntity caster, LivingEntity target, int durationTicks, ForwardAxis axis, float extraRollRad) {
        this.casterRef = new WeakReference<BabyEnderDragonEntity>(caster);
        this.targetRef = new WeakReference<LivingEntity>(target);
        this.durationTicks = durationTicks;
        this.axis = axis;
        this.roll = extraRollRad;
        return this;
    }

    private static Vec3 eyeLerped(BabyEnderDragonEntity e, float partial) {
        double x = Mth.m_14139_((double)partial, (double)e.f_19790_, (double)e.m_20185_());
        double y = Mth.m_14139_((double)partial, (double)e.f_19791_, (double)e.m_20186_()) + (double)e.m_20192_();
        double z = Mth.m_14139_((double)partial, (double)e.f_19792_, (double)e.m_20189_());
        return new Vec3(x, y, z);
    }

    private static Vec3 eyeLerped(LivingEntity e, float partial) {
        double x = Mth.m_14139_((double)partial, (double)e.f_19790_, (double)e.m_20185_());
        double y = Mth.m_14139_((double)partial, (double)e.f_19791_, (double)e.m_20186_()) + (double)e.m_20192_();
        double z = Mth.m_14139_((double)partial, (double)e.f_19792_, (double)e.m_20189_());
        return new Vec3(x, y, z);
    }

    private static void aim(ParticleEmitter em, Vec3 from, Vec3 to, ForwardAxis axis, float roll) {
        Vec3 d = to.m_82546_(from);
        double len = d.m_82553_();
        if (len < 1.0E-6) {
            len = 1.0E-6;
        }
        double xz = Math.sqrt(d.f_82479_ * d.f_82479_ + d.f_82481_ * d.f_82481_);
        switch (axis) {
            case PLUS_Z: {
                float yaw = (float)Math.atan2(d.f_82479_, d.f_82481_);
                float pitch = (float)(-Math.atan2(d.f_82480_, xz));
                em.setRotation(pitch, yaw, roll);
                break;
            }
            case PLUS_Y: {
                float yaw = (float)Math.atan2(d.f_82481_, d.f_82479_) + 1.5707964f;
                float pitch = (float)Math.atan2(xz, d.f_82480_) - 1.5707964f;
                em.setRotation(pitch, yaw, roll);
            }
        }
    }

    public void spawnInWorld(Level level, Player player) {
        if (NativePlatform.isRunningOnUnsupportedPlatform()) {
            return;
        }
        Optional.ofNullable(EffectRegistry.get((ResourceLocation)this.effek)).ifPresent(eff -> {
            Vec3 to0;
            BabyEnderDragonEntity caster0;
            ParticleEmitter em;
            ParticleEmitter particleEmitter = em = this.hasEmitter() ? eff.play(this.emitter) : eff.play();
            if (this.hasParameters()) {
                for (DynamicParameter p : this.parameters) {
                    em.setDynamicInput(p.index(), p.value());
                }
            }
            if (this.hasTriggers()) {
                this.triggers.forEach(arg_0 -> ((ParticleEmitter)em).sendTrigger(arg_0));
            }
            if ((caster0 = (BabyEnderDragonEntity)((Object)((Object)this.casterRef.get()))) == null || !caster0.m_6084_()) {
                em.stop();
                return;
            }
            int startTick = caster0.f_19797_;
            Vec3 f0 = caster0.m_20154_().m_82541_();
            double muzzle = 1.0;
            Vec3 from0 = new Vec3(caster0.m_20185_(), caster0.m_20188_(), caster0.m_20189_()).m_82549_(f0.m_82490_(muzzle));
            LivingEntity t0 = (LivingEntity)this.targetRef.get();
            this.lastTargetPos = to0 = t0 != null && t0.m_6084_() ? new Vec3(t0.m_20185_(), t0.m_20188_(), t0.m_20189_()) : (this.lastTargetPos != null ? this.lastTargetPos : from0.m_82549_(caster0.m_20154_()));
            em.setPosition((float)from0.f_82479_, (float)from0.f_82480_, (float)from0.f_82481_);
            BabyDragonBeamParticleEmitterInfo.aim(em, from0, to0, this.axis, this.roll);
            em.addPreDrawCallback((Emitter, partial) -> {
                Vec3 to;
                BabyEnderDragonEntity c = (BabyEnderDragonEntity)((Object)((Object)((Object)this.casterRef.get())));
                if (c == null || !c.m_6084_()) {
                    Emitter.stop();
                    return;
                }
                if (this.durationTicks > 0 && c.f_19797_ - startTick >= this.durationTicks) {
                    Emitter.stop();
                    return;
                }
                Vec3 fwd = c.m_20252_(partial).m_82541_();
                double muzzle2 = 1.0;
                Vec3 from = BabyDragonBeamParticleEmitterInfo.eyeLerped(c, partial).m_82549_(fwd.m_82490_(muzzle2));
                LivingEntity t = (LivingEntity)this.targetRef.get();
                this.lastTargetPos = to = t != null && t.m_6084_() ? BabyDragonBeamParticleEmitterInfo.eyeLerped(t, partial) : (this.lastTargetPos != null ? this.lastTargetPos : from.m_82549_(fwd));
                Emitter.setPosition((float)from.f_82479_, (float)from.f_82480_, (float)from.f_82481_);
                BabyDragonBeamParticleEmitterInfo.aim(Emitter, from, to, this.axis, this.roll);
            });
        });
    }

    public static enum ForwardAxis {
        PLUS_Z,
        PLUS_Y;

    }
}

