/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.compat.aaa_particles;

import java.util.Optional;
import mod.chloeprime.aaaparticles.api.client.effekseer.ParticleEmitter;
import mod.chloeprime.aaaparticles.api.common.DynamicParameter;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import mod.chloeprime.aaaparticles.client.installer.NativePlatform;
import mod.chloeprime.aaaparticles.client.registry.EffectRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EnderGlaiveExplosionParticleEmitterInfo
extends ParticleEmitterInfo {
    private ForwardAxis axis = ForwardAxis.PLUS_Z;
    private float roll = 0.0f;
    private Vec3 from = null;
    private Vec3 to = null;
    private boolean flipForward = true;

    public EnderGlaiveExplosionParticleEmitterInfo(ResourceLocation effek) {
        super(effek);
    }

    public EnderGlaiveExplosionParticleEmitterInfo fromTo(Vec3 from, Vec3 to, ForwardAxis axis, float extraRollRad, boolean flip) {
        this.from = from;
        this.to = to;
        this.axis = axis;
        this.roll = extraRollRad;
        this.flipForward = flip;
        return this;
    }

    private static void aim(ParticleEmitter em, Vec3 from, Vec3 to, ForwardAxis axis, float roll, boolean flip) {
        Vec3 d = to.m_82546_(from);
        if (flip) {
            d = d.m_82490_(-1.0);
        }
        double xz = Math.sqrt(d.f_82479_ * d.f_82479_ + d.f_82481_ * d.f_82481_);
        switch (axis) {
            case PLUS_Z: {
                float yaw = (float)Math.atan2(d.f_82479_, d.f_82481_);
                float pitch = (float)(-Math.atan2(d.f_82480_, xz));
                em.setRotation(pitch, yaw, roll);
                break;
            }
            case PLUS_Y: {
                float yaw = (float)Math.atan2(d.f_82481_, d.f_82479_) + 1.5707964f;
                float pitch = (float)Math.atan2(xz, d.f_82480_) - 1.5707964f;
                em.setRotation(pitch, yaw, roll);
            }
        }
    }

    public void spawnInWorld(Level level, Player player) {
        if (NativePlatform.isRunningOnUnsupportedPlatform()) {
            return;
        }
        if (this.from == null || this.to == null) {
            return;
        }
        Optional.ofNullable(EffectRegistry.get((ResourceLocation)this.effek)).ifPresent(eff -> {
            ParticleEmitter em;
            ParticleEmitter particleEmitter = em = this.hasEmitter() ? eff.play(this.emitter) : eff.play();
            if (this.hasParameters()) {
                for (DynamicParameter p : this.parameters) {
                    em.setDynamicInput(p.index(), p.value());
                }
            }
            if (this.hasTriggers()) {
                this.triggers.forEach(arg_0 -> ((ParticleEmitter)em).sendTrigger(arg_0));
            }
            em.setPosition((float)this.from.f_82479_, (float)this.from.f_82480_, (float)this.from.f_82481_);
            EnderGlaiveExplosionParticleEmitterInfo.aim(em, this.from, this.to, this.axis, this.roll);
        });
    }

    private static void aim(ParticleEmitter em, Vec3 from, Vec3 to, ForwardAxis axis, float roll) {
        Vec3 d = to.m_82546_(from);
        double xz = Math.sqrt(d.f_82479_ * d.f_82479_ + d.f_82481_ * d.f_82481_);
        switch (axis) {
            case PLUS_Z: {
                float yaw = (float)Math.atan2(d.f_82479_, d.f_82481_);
                float pitch = (float)(-Math.atan2(d.f_82480_, xz));
                em.setRotation(pitch, yaw, roll);
                break;
            }
            case PLUS_Y: {
                float yaw = (float)Math.atan2(d.f_82481_, d.f_82479_) + 1.5707964f;
                float pitch = (float)Math.atan2(xz, d.f_82480_) - 1.5707964f;
                em.setRotation(pitch, yaw, roll);
            }
        }
    }

    public static enum ForwardAxis {
        PLUS_Z,
        PLUS_Y;

    }
}

