/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.compat.dual_greatsword.skill;

import com.pla.annoyingvillagers.gameasset.AVAnimations;
import com.pla.annoyingvillagers.gameasset.AVSkillDataKeys;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class EarthquakeSkill
extends WeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("b19d1eb4-fefa-11ec-b939-0242ac12000");

    public EarthquakeSkill(Skill.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)AVSkillDataKeys.SUPERARMOR.get())).booleanValue()) {
                ((EpicFightDamageSource)event.getDamageSource()).setStunType(StunType.NONE);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID);
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        executer.playAnimationSynchronized(AVAnimations.GREATSWORD_DUAL_EARTHQUAKE, 0.0f);
        executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)AVSkillDataKeys.SUPERARMOR.get(), (Object)true, (ServerPlayer)executer.getOriginal());
        super.executeOnServer(executer, args);
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)AVSkillDataKeys.SUPERARMOR.get())).booleanValue()) {
            Player player = (Player)container.getExecuter().getOriginal();
            player.m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 5, 0, true, false, false));
        }
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }
}

