/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.entity;

import com.pla.annoyingvillagers.clazz.HerobrineMob;
import com.pla.annoyingvillagers.entity.BlockProjectileEntity;
import com.pla.annoyingvillagers.entity.InfectedTheMostMoistBurrit0Entity;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModBlocks;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModEntities;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModItems;
import com.pla.annoyingvillagers.procedures.ArmoredHerobrineOnHurtProcedure;
import com.pla.annoyingvillagers.procedures.ArmoredHerobrineOnPlayerTouchProcedure;
import com.pla.annoyingvillagers.spawnhandler.HerobrineMobData;
import com.pla.annoyingvillagers.util.DelayedTask;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class ArmoredHerobrineEntity
extends HerobrineMob {
    private boolean wasAiming = false;
    private int switchSwordFist = 300;

    public ArmoredHerobrineEntity(PlayMessages.SpawnEntity spawnentity, Level level) {
        this((EntityType<ArmoredHerobrineEntity>)((EntityType)AnnoyingVillagersModEntities.ARMORED_HEROBRINE.get()), level);
    }

    public ArmoredHerobrineEntity(EntityType<ArmoredHerobrineEntity> entitytype, Level level) {
        super(entitytype, level);
        this.m_274367_(4.0f);
        this.f_21364_ = 60;
        this.m_21557_(false);
        this.m_6593_(this.m_5446_());
        this.m_20340_(true);
        this.m_21530_();
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)AnnoyingVillagersModItems.HEROBRINE_OBSIDIAN_DIAMOND_HELMET.get()));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)AnnoyingVillagersModItems.HEROBRINE_OBSIDIAN_DIAMOND_CHESTPLATE.get()));
        this.setChatName(this.m_5446_().getString());
    }

    @Override
    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    public boolean m_6785_(double d0) {
        return false;
    }

    @Override
    public double m_6049_() {
        return -0.35;
    }

    @Override
    @NotNull
    public SoundEvent m_7975_(DamageSource damagesource) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    @Override
    @NotNull
    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource damagesource, float f) {
        if (!this.isHealing()) {
            ArmoredHerobrineOnHurtProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        return super.m_6469_(damagesource, f);
    }

    public void m_6667_(DamageSource damagesource) {
        super.m_6667_(damagesource);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            InfectedTheMostMoistBurrit0Entity infectedTheMostMoistBurrit0Entity = new InfectedTheMostMoistBurrit0Entity((EntityType<InfectedTheMostMoistBurrit0Entity>)((EntityType)AnnoyingVillagersModEntities.INFECTED_THEMOSTMOISTBURRIT0.get()), (Level)serverlevel);
            infectedTheMostMoistBurrit0Entity.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), serverlevel.m_213780_().m_188501_() * 360.0f, 0.0f);
            infectedTheMostMoistBurrit0Entity.m_6518_((ServerLevelAccessor)serverlevel, serverlevel.m_6436_(infectedTheMostMoistBurrit0Entity.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            serverlevel.m_7967_((Entity)infectedTheMostMoistBurrit0Entity);
        }
        if (!this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
    }

    private static String currentEfAnimIdOrNull(LivingEntity self) {
        try {
            LivingEntityPatch patch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)self, LivingEntityPatch.class);
            if (patch == null) {
                return null;
            }
            AnimationPlayer player = patch.getAnimator().getPlayerFor((DynamicAnimation)null);
            if (player == null) {
                return null;
            }
            DynamicAnimation anim = player.getAnimation();
            if (anim == null) {
                return null;
            }
            try {
                Method m = anim.getClass().getMethod("getLocation", new Class[0]);
                ResourceLocation rl = (ResourceLocation)m.invoke((Object)anim, new Object[0]);
                return rl != null ? rl.m_135815_().toLowerCase(Locale.ROOT) : null;
            }
            catch (Exception ignored) {
                return anim.toString().toLowerCase(Locale.ROOT);
            }
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static boolean isAiming(String id) {
        if (id == null) {
            return false;
        }
        return id.contains("biped/combat/fist_dash") || id.endsWith("/fist_dash") || id.contains("fist_dash");
    }

    public void shootDarkObsAtTarget(double speed) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        LivingEntity target = this.m_5448_();
        Vec3 to = target != null && target.m_6084_() ? target.m_20299_(1.0f) : this.m_146892_().m_82549_(this.m_20154_().m_82490_(16.0));
        BlockState block = ((Block)AnnoyingVillagersModBlocks.DARKOB.get()).m_49966_();
        BlockProjectileEntity throwingObsidian = new BlockProjectileEntity(this.m_9236_(), (LivingEntity)this, block);
        this.m_9236_().m_7967_((Entity)throwingObsidian);
        Vec3 dir = to.m_82546_(throwingObsidian.m_20182_());
        if (dir.m_82556_() < 1.0E-6) {
            dir = this.m_20154_();
        }
        Vec3 vel = dir.m_82541_().m_82490_(speed);
        throwingObsidian.m_20256_(vel);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            String animId = ArmoredHerobrineEntity.currentEfAnimIdOrNull((LivingEntity)this);
            boolean aimingNow = ArmoredHerobrineEntity.isAiming(animId);
            if (aimingNow && !this.wasAiming) {
                final ArmoredHerobrineEntity herobrine = this;
                new DelayedTask(10){

                    @Override
                    public void run() {
                        if (herobrine.m_6084_()) {
                            herobrine.shootDarkObsAtTarget(2.0);
                        }
                    }
                };
            }
            this.wasAiming = aimingNow;
            if (!this.m_21205_().m_41720_().equals(AnnoyingVillagersModItems.SHADOW_OBSIDIAN_SWORD.get()) && this.switchSwordFist == 0) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)AnnoyingVillagersModItems.SHADOW_OBSIDIAN_SWORD.get()));
                this.switchSwordFist = new Random().nextInt(200, 600);
            }
            if (this.m_21205_().m_41720_().equals(AnnoyingVillagersModItems.SHADOW_OBSIDIAN_SWORD.get()) && this.switchSwordFist == 0) {
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                this.switchSwordFist = new Random().nextInt(200, 600);
            }
            if (this.switchSwordFist > 0) {
                --this.switchSwordFist;
            }
        }
    }

    public void m_6075_() {
        super.m_6075_();
    }

    public void m_6123_(Player player) {
        super.m_6123_(player);
        if (!this.isHealing()) {
            ArmoredHerobrineOnPlayerTouchProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        }
    }

    public static boolean canSpawn(EntityType<ArmoredHerobrineEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        ServerLevel serverLevel = level.m_6018_();
        int passesDay = (int)(serverLevel.m_46467_() / 24000L);
        if (passesDay != 0 && passesDay % 3 != 0) {
            return false;
        }
        if (HerobrineMobData.get(serverLevel).isOccupied(serverLevel)) {
            return false;
        }
        if (!serverLevel.m_46462_()) {
            return false;
        }
        return Monster.m_219013_(entityType, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 100.0);
        builder = builder.m_22268_(Attributes.f_22284_, 10.0);
        builder = builder.m_22268_(Attributes.f_22281_, 4.0);
        builder = builder.m_22268_(Attributes.f_22277_, 256.0);
        return builder;
    }
}

