/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.entity;

import com.pla.annoyingvillagers.entity.BabyDragonBeamEntity;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModEntities;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class BabyEnderDragonEntity
extends FlyingMob {
    private UUID followTargetUUID;
    private Player followTarget;
    private int breathCooldown = 0;
    private int lifeLeft = 600;
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;

    public void setFollowTarget(Player followTarget) {
        this.followTarget = followTarget;
    }

    public void setFollowTargetUUID(UUID followTargetUUID) {
        this.followTargetUUID = followTargetUUID;
    }

    public UUID getFollowTargetUUID() {
        return this.followTargetUUID;
    }

    public BabyEnderDragonEntity(PlayMessages.SpawnEntity spawnentity, Level level) {
        this((EntityType<BabyEnderDragonEntity>)((EntityType)AnnoyingVillagersModEntities.BABY_ENDER_DRAGON.get()), level);
    }

    public BabyEnderDragonEntity(EntityType<BabyEnderDragonEntity> entitytype, Level level) {
        super(entitytype, level);
        this.m_20242_(true);
        this.m_21530_();
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation nav = new FlyingPathNavigation((Mob)this, level);
        nav.m_26440_(false);
        nav.m_26443_(true);
        nav.m_7008_(true);
        return nav;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 40;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, new Goal(){

            public boolean m_8036_() {
                return BabyEnderDragonEntity.this.followTarget != null && BabyEnderDragonEntity.this.followTarget.m_6084_();
            }

            public void m_8037_() {
                if (BabyEnderDragonEntity.this.followTarget != null && BabyEnderDragonEntity.this.followTarget.m_6084_()) {
                    BabyEnderDragonEntity.this.copyOwnerLook(BabyEnderDragonEntity.this.followTarget);
                    Vec3 posBehind3D = BabyEnderDragonEntity.posBehind3D(BabyEnderDragonEntity.this.followTarget, 1.0, 2.0, 1.0);
                    BabyEnderDragonEntity.this.m_21573_().m_26519_(posBehind3D.f_82479_, posBehind3D.f_82480_, posBehind3D.f_82481_, 9999.0);
                }
            }

            public boolean m_8045_() {
                return BabyEnderDragonEntity.this.followTarget != null && BabyEnderDragonEntity.this.followTarget.m_6084_() && (double)BabyEnderDragonEntity.this.m_20270_((Entity)BabyEnderDragonEntity.this.followTarget) > 1.0;
            }
        });
    }

    public boolean m_6469_(DamageSource damagesource, float f) {
        if (damagesource.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268464_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268425_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268565_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268714_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268526_)) {
            return false;
        }
        return super.m_6469_(damagesource, f);
    }

    public boolean m_6673_(DamageSource source) {
        return !source.m_276093_(DamageTypes.f_268724_);
    }

    private static Vec3 posBehind3D(Player p, double back, double upFromGround, double right) {
        Vec3 look = p.m_20154_().m_82541_();
        Vec3 forwardXZ = new Vec3(look.f_82479_, 0.0, look.f_82481_);
        if (forwardXZ.m_82556_() < 1.0E-6) {
            float yaw = p.m_146908_() * ((float)Math.PI / 180);
            forwardXZ = new Vec3((double)(-Mth.m_14031_((float)yaw)), 0.0, (double)Mth.m_14089_((float)yaw));
        }
        forwardXZ = forwardXZ.m_82541_();
        Vec3 rightVec = new Vec3(-forwardXZ.f_82481_, 0.0, forwardXZ.f_82479_);
        double tx = p.m_20185_() - forwardXZ.f_82479_ * back + rightVec.f_82479_ * right;
        double tz = p.m_20189_() - forwardXZ.f_82481_ * back + rightVec.f_82481_ * right;
        int blockY = Mth.m_14107_((double)p.m_20186_());
        double ty = (double)blockY + upFromGround;
        if ((blockY & 1) != 0) {
            // empty if block
        }
        return new Vec3(tx, ty, tz);
    }

    protected BodyRotationControl m_7560_() {
        return new BodyRotationControl((Mob)this){

            public void m_8121_() {
                BabyEnderDragonEntity self = BabyEnderDragonEntity.this;
                self.f_20885_ = self.m_146908_();
                self.f_20883_ = self.m_146908_();
            }
        };
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.followTarget != null && this.followTarget.m_6084_()) {
            this.copyOwnerLook(this.followTarget);
        }
    }

    public static LivingEntity getNearestLivingEntity(Level level, Entity sourceEntity, double range) {
        AABB searchBox = sourceEntity.m_20191_().m_82400_(range);
        return level.m_45982_(level.m_6443_(LivingEntity.class, searchBox, e -> e != sourceEntity && !(e instanceof BabyEnderDragonEntity) && e.m_6084_()), TargetingConditions.f_26872_, (LivingEntity)sourceEntity, sourceEntity.m_20185_(), sourceEntity.m_20186_(), sourceEntity.m_20189_());
    }

    private void copyOwnerLook(Player owner) {
        float targetYaw = owner.m_146908_();
        float targetPitch = owner.m_146909_() * 0.35f;
        this.m_146922_(Mth.m_14148_((float)this.m_146908_(), (float)targetYaw, (float)10.0f));
        this.m_146926_(Mth.m_14148_((float)this.m_146909_(), (float)targetPitch, (float)8.0f));
        this.f_20883_ = this.m_146908_();
        this.f_20885_ = this.m_146908_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
        if (!this.m_9236_().f_46443_) {
            if (--this.lifeLeft <= 0) {
                this.m_146870_();
                return;
            }
            if (this.followTarget == null && this.followTargetUUID != null) {
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) {
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)level;
                MinecraftServer server = serverLevel.m_7654_();
                ServerPlayer serverPlayer = server.m_6846_().m_11259_(this.followTargetUUID);
                if (serverPlayer != null) {
                    this.followTarget = serverPlayer;
                }
            }
            if (this.followTarget != null && !this.followTarget.m_6084_()) {
                this.followTarget = null;
                this.followTargetUUID = null;
                this.m_146870_();
            }
            if (this.followTarget != null && this.followTarget.m_6084_()) {
                double distanceSq = this.m_20280_((Entity)this.followTarget);
                if (distanceSq > 4.0) {
                    Vec3 posBehind3D = BabyEnderDragonEntity.posBehind3D(this.followTarget, 1.0, 2.0, 1.0);
                    this.m_6021_(posBehind3D.f_82479_, posBehind3D.f_82480_, posBehind3D.f_82481_);
                }
                if (this.breathCooldown <= 0) {
                    LivingEntity target = this.followTarget.m_21214_();
                    if (target == null || !target.m_6084_()) {
                        target = this.followTarget.m_21188_();
                    }
                    if (target == null || !target.m_6084_()) {
                        target = BabyEnderDragonEntity.getNearestLivingEntity(this.followTarget.m_9236_(), (Entity)this.followTarget, 30.0);
                    }
                    if (target != null) {
                        Vec3 look = this.m_20154_().m_82541_();
                        double dist = 0.5;
                        double sx = this.m_20185_() + look.f_82479_ * dist;
                        double sy = this.m_20188_();
                        double sz = this.m_20189_() + look.f_82481_ * dist;
                        BabyDragonBeamEntity beam = new BabyDragonBeamEntity((EntityType<? extends BabyDragonBeamEntity>)((EntityType)AnnoyingVillagersModEntities.BABY_DRAGON_BEAM.get()), this.m_9236_(), this, target, sx, sy, sz, 100, 2);
                        this.m_9236_().m_7967_((Entity)beam);
                        this.breathCooldown = 120;
                    }
                }
            }
            if (this.breathCooldown > 0) {
                --this.breathCooldown;
            }
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.followTargetUUID != null) {
            tag.m_128362_("FollowTarget", this.followTargetUUID);
            tag.m_128405_("BreathCooldown", this.breathCooldown);
            tag.m_128405_("LifeLeft", this.lifeLeft);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("FollowTarget")) {
            this.followTargetUUID = tag.m_128342_("FollowTarget");
        }
        this.breathCooldown = tag.m_128451_("BreathCooldown");
        this.lifeLeft = tag.m_128441_("LifeLeft") ? tag.m_128451_("LifeLeft") : 600;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22276_, 150.0);
        builder = builder.m_22268_(Attributes.f_22280_, 3.0);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        builder = builder.m_22268_(Attributes.f_22282_, 1.0);
        return builder;
    }
}

