/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.annoyingvillagers.block.DarkObUpBlock;
import com.pla.annoyingvillagers.block.ShadowObsidianBlock;
import com.pla.annoyingvillagers.blockentity.DarkObUpBlockEntity;
import com.pla.annoyingvillagers.blockentity.ShadowObsidianBlockEntity;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModBlocks;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModEntities;
import com.pla.annoyingvillagers.util.ObsidianWeaponUtil;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockProjectileEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<BlockState> DATA_BLOCK = SynchedEntityData.m_135353_(BlockProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private static final EntityDataAccessor<Float> ROT_X = SynchedEntityData.m_135353_(BlockProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROT_Y = SynchedEntityData.m_135353_(BlockProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROT_Z = SynchedEntityData.m_135353_(BlockProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private boolean notReadyForShoot = false;
    private UUID playerUUID;

    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    public void setNotReadyForShoot(boolean notReadyForShoot) {
        this.notReadyForShoot = notReadyForShoot;
    }

    public BlockProjectileEntity(EntityType<? extends BlockProjectileEntity> type, Level level) {
        super(type, level);
        this.initRandomRotation();
    }

    public BlockProjectileEntity(Level level, LivingEntity shooter, BlockState block) {
        super((EntityType)AnnoyingVillagersModEntities.BLOCK_PROJECTILE.get(), shooter, level);
        this.setCarriedBlock(block);
        this.initRandomRotation();
    }

    public void setRotX(float v) {
        this.f_19804_.m_135381_(ROT_X, (Object)Float.valueOf(v));
    }

    public void setRotY(float v) {
        this.f_19804_.m_135381_(ROT_Y, (Object)Float.valueOf(v));
    }

    public void setRotZ(float v) {
        this.f_19804_.m_135381_(ROT_Z, (Object)Float.valueOf(v));
    }

    public float getRotX() {
        return ((Float)this.f_19804_.m_135370_(ROT_X)).floatValue();
    }

    public float getRotY() {
        return ((Float)this.f_19804_.m_135370_(ROT_Y)).floatValue();
    }

    public float getRotZ() {
        return ((Float)this.f_19804_.m_135370_(ROT_Z)).floatValue();
    }

    private void initRandomRotation() {
        if (!this.m_9236_().f_46443_) {
            RandomSource r = this.f_19796_;
            this.setRotX((r.m_188501_() - 0.5f) * 10.0f);
            this.setRotY((r.m_188501_() - 0.5f) * 10.0f);
            this.setRotZ((r.m_188501_() - 0.5f) * 10.0f);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_BLOCK, (Object)Blocks.f_50069_.m_49966_());
        this.f_19804_.m_135372_(ROT_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROT_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROT_Z, (Object)Float.valueOf(0.0f));
    }

    public void setCarriedBlock(BlockState state) {
        this.f_19804_.m_135381_(DATA_BLOCK, (Object)state);
    }

    protected void m_5790_(EntityHitResult result) {
        Player p2;
        boolean blockDamage;
        super.m_5790_(result);
        if (this.notReadyForShoot) {
            return;
        }
        Entity target = result.m_82443_();
        UUID ownerId = this.playerUUID;
        boolean isHerobrine = ObsidianWeaponUtil.isHerobrineFaction(target);
        boolean bl = blockDamage = ownerId == null && isHerobrine || ownerId != null && target instanceof Player && (p2 = (Player)target).m_20148_().equals(ownerId);
        if (blockDamage) {
            return;
        }
        if (!target.m_9236_().m_5776_() && target.m_20194_() != null) {
            try {
                target.m_20194_().m_129892_().m_82094_().execute("execute at @s run particle epicfight:hit_blunt ^ ^1.5 ^0.8 0.1 0.1 0.1 1 1", (Object)target.m_20203_().m_81324_().m_81325_(4));
            }
            catch (CommandSyntaxException p2) {
                // empty catch block
            }
        }
        if (!target.m_9236_().m_5776_()) {
            target.m_9236_().m_5594_((Player)null, new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("annoyingvillagers", "obsidian_hit")), SoundSource.BLOCKS, 1.0f, (float)(0.5 + Math.random() * 0.5));
        } else {
            target.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("annoyingvillagers", "obsidian_hit")), SoundSource.BLOCKS, 1.0f, (float)(0.5 + Math.random() * 0.5), false);
        }
        if (this.m_19749_() == null) {
            target.m_6469_(target.m_9236_().m_269111_().m_269264_(), 2.0f);
        } else {
            target.m_6469_(target.m_9236_().m_269111_().m_269104_((Entity)this, this.m_19749_()), 2.0f);
        }
        if (!target.m_9236_().m_5776_() && target.m_20194_() != null) {
            try {
                target.m_20194_().m_129892_().m_82094_().execute("indestructible @s play \"epicfight:biped/combat/hit_long\" 0 10", (Object)target.m_20203_().m_81324_().m_81325_(4));
            }
            catch (CommandSyntaxException p2) {
                // empty catch block
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
                float strength = 1.0f;
                double dx = this.m_20185_() - target.m_20185_();
                double dz = this.m_20189_() - target.m_20189_();
                livingEntity.m_147240_((double)strength, dx, dz);
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        if (this.notReadyForShoot) {
            return;
        }
        BlockPos pos = result.m_82425_();
        BlockState hitState = this.m_9236_().m_8055_(pos);
        if (!this.m_9236_().f_46443_) {
            if (!hitState.m_60819_().m_76178_()) {
                return;
            }
            if (hitState.m_247087_()) {
                return;
            }
            BlockPos placePos = pos.m_121945_(result.m_82434_());
            if (this.m_9236_().m_8055_(placePos).m_60795_() || !this.m_9236_().m_6425_(placePos).m_76178_() || this.m_9236_().m_8055_(placePos).m_247087_()) {
                BlockState placeState;
                UUID owner = this.playerUUID;
                if (this.getCarriedBlock().m_60713_((Block)AnnoyingVillagersModBlocks.DARKOB.get())) {
                    placeState = ((Block)AnnoyingVillagersModBlocks.DARK_OB_UP.get()).m_49966_();
                    if (owner != null && placeState.m_61138_((Property)DarkObUpBlock.FROM_PLAYER)) {
                        placeState = (BlockState)placeState.m_61124_((Property)DarkObUpBlock.FROM_PLAYER, (Comparable)Boolean.valueOf(true));
                    }
                } else if (this.getCarriedBlock().m_60713_((Block)AnnoyingVillagersModBlocks.SHADOW_OBSIDIAN_BLOCK.get())) {
                    placeState = ((Block)AnnoyingVillagersModBlocks.SHADOW_OBSIDIAN_BLOCK.get()).m_49966_();
                    if (owner != null && placeState.m_61138_((Property)ShadowObsidianBlock.FROM_PLAYER)) {
                        placeState = (BlockState)placeState.m_61124_((Property)ShadowObsidianBlock.FROM_PLAYER, (Comparable)Boolean.valueOf(true));
                    }
                } else {
                    placeState = this.getCarriedBlock();
                }
                this.m_9236_().m_46597_(placePos, placeState);
                BlockEntity blockEntity = this.m_9236_().m_7702_(placePos);
                if (owner != null) {
                    if (blockEntity instanceof ShadowObsidianBlockEntity) {
                        ShadowObsidianBlockEntity shadowObsidianBlockEntity = (ShadowObsidianBlockEntity)blockEntity;
                        shadowObsidianBlockEntity.setOwner(owner);
                        blockEntity.m_6596_();
                    } else if (blockEntity instanceof DarkObUpBlockEntity) {
                        DarkObUpBlockEntity darkObUpBlockEntity = (DarkObUpBlockEntity)blockEntity;
                        darkObUpBlockEntity.setOwner(owner);
                        blockEntity.m_6596_();
                    }
                }
            }
            this.m_146870_();
        }
    }

    public BlockState getCarriedBlock() {
        return (BlockState)this.f_19804_.m_135370_(DATA_BLOCK);
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128365_("Block", (Tag)NbtUtils.m_129202_((BlockState)this.getCarriedBlock()));
        tag.m_128350_("RotX", this.getRotX());
        tag.m_128350_("RotY", this.getRotY());
        tag.m_128350_("RotZ", this.getRotZ());
        tag.m_128379_("NotReadyForShoot", this.notReadyForShoot);
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("Block")) {
            this.setCarriedBlock(NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)tag.m_128469_("Block")));
        }
        this.setRotX(tag.m_128441_("RotX") ? tag.m_128457_("RotX") : 0.0f);
        this.setRotY(tag.m_128441_("RotY") ? tag.m_128457_("RotY") : 0.0f);
        this.setRotZ(tag.m_128441_("RotZ") ? tag.m_128457_("RotZ") : 0.0f);
        this.notReadyForShoot = tag.m_128471_("NotReadyForShoot");
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20398_((float)0.9f, (float)0.9f);
    }

    protected float m_7139_() {
        return 0.005f;
    }
}

