/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.entity;

import com.pla.annoyingvillagers.block.EndFireBlock;
import com.pla.annoyingvillagers.compat.aaa_particles.DragonBeamParticleEmitterInfo;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class DragonBeamEntity
extends Entity {
    public EnderDragon caster;
    public LivingEntity target;
    public double endPosX;
    public double endPosY;
    public double endPosZ;
    public double collidePosX;
    public double collidePosY;
    public double collidePosZ;
    public double prevCollidePosX;
    public double prevCollidePosY;
    public double prevCollidePosZ;
    public float renderYaw;
    public float renderPitch;
    public boolean on = true;
    public Direction blockSide = null;
    private int power;
    private static final EntityDataAccessor<Float> YAW = SynchedEntityData.m_135353_(DragonBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> PITCH = SynchedEntityData.m_135353_(DragonBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.m_135353_(DragonBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CASTER = SynchedEntityData.m_135353_(DragonBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TARGET = SynchedEntityData.m_135353_(DragonBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float prevYaw;
    public float prevPitch;
    private Vec3 targetPos;
    @OnlyIn(value=Dist.CLIENT)
    private Vec3[] attractorPos;
    private boolean renderBeam = false;
    private boolean playSound = false;

    public DragonBeamEntity(EntityType<? extends DragonBeamEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19811_ = true;
        if (pLevel.f_46443_) {
            this.attractorPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
        }
    }

    public DragonBeamEntity(EntityType<? extends DragonBeamEntity> type, Level world, EnderDragon caster, LivingEntity target, double x, double y, double z, int duration, int pow) {
        this(type, world);
        this.caster = caster;
        this.target = target;
        this.setDuration(duration);
        this.setPower(pow);
        this.m_6034_(x, y, z);
        Vec3 from = new Vec3(x, y, z);
        Vec3 to = target.m_20299_(1.0f);
        float yawRad = DragonBeamEntity.yawTowards(from, to);
        float pitchRad = DragonBeamEntity.pitchTowards(from, to);
        this.setYaw(yawRad);
        this.setPitch(pitchRad);
        if (world.f_46443_) {
            this.renderYaw = yawRad;
            this.renderPitch = pitchRad;
        }
        if (!world.f_46443_) {
            this.setCasterID(caster.m_19879_());
            this.setTargetID(target.m_19879_());
        }
        this.calculateEndPos();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DURATION, (Object)0);
        this.f_19804_.m_135372_(CASTER, (Object)-1);
        this.f_19804_.m_135372_(TARGET, (Object)-1);
    }

    public void setTargetID(int id) {
        this.f_19804_.m_135381_(TARGET, (Object)id);
    }

    public int getTargetID() {
        return (Integer)this.f_19804_.m_135370_(TARGET);
    }

    protected void m_7378_(CompoundTag compoundTag) {
    }

    protected void m_7380_(CompoundTag compoundTag) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public float getYaw() {
        return ((Float)this.m_20088_().m_135370_(YAW)).floatValue();
    }

    public void setYaw(float yaw) {
        this.m_20088_().m_135381_(YAW, (Object)Float.valueOf(yaw));
    }

    public float getPitch() {
        return ((Float)this.m_20088_().m_135370_(PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.m_20088_().m_135381_(PITCH, (Object)Float.valueOf(pitch));
    }

    public int getDuration() {
        return (Integer)this.m_20088_().m_135370_(DURATION);
    }

    public void setDuration(int duration) {
        this.m_20088_().m_135381_(DURATION, (Object)duration);
    }

    public int getCasterID() {
        return (Integer)this.m_20088_().m_135370_(CASTER);
    }

    public void setCasterID(int id) {
        this.m_20088_().m_135381_(CASTER, (Object)id);
    }

    public void setPower(int power) {
        this.power = power;
    }

    private static float yawTowards(Vec3 from, Vec3 to) {
        Vec3 d = to.m_82546_(from);
        return (float)Math.atan2(d.f_82481_, d.f_82479_);
    }

    private static float pitchTowards(Vec3 from, Vec3 to) {
        Vec3 d = to.m_82546_(from);
        double len = d.m_82553_();
        return len == 0.0 ? 0.0f : (float)Math.asin(d.f_82480_ / len);
    }

    private void calculateEndPos() {
        double radius = 128.0;
        double yaw = this.getYaw();
        double pitch = this.getPitch();
        this.endPosX = this.m_20185_() + radius * Math.cos(yaw) * Math.cos(pitch);
        this.endPosZ = this.m_20189_() + radius * Math.sin(yaw) * Math.cos(pitch);
        this.endPosY = this.m_20186_() + radius * Math.sin(pitch);
    }

    public DragonBeamHitResult raytraceEntities(Level world, Vec3 from, Vec3 to, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        DragonBeamHitResult result = new DragonBeamHitResult();
        result.setBlockHit((HitResult)world.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)));
        result.setBlockHit((HitResult)world.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)));
        if (result.blockHit != null) {
            Vec3 hitVec = result.blockHit.m_82450_();
            BlockPos hitBlock = result.blockHit.m_82425_();
            this.collidePosX = hitVec.f_82479_;
            this.collidePosY = hitVec.f_82480_;
            this.collidePosZ = hitVec.f_82481_;
            this.blockSide = result.blockHit.m_82434_();
            if (world.f_46443_) {
                AAALevel.addParticle((Level)world, (boolean)false, (ParticleEmitterInfo)new ParticleEmitterInfo(new ResourceLocation("annoyingvillagers", "dragon_beam_hit")).clone().position((double)hitBlock.m_123341_(), (double)hitBlock.m_123342_(), (double)hitBlock.m_123343_()));
            }
            if (!world.f_46443_) {
                BlockState hitState;
                boolean shouldBreak = true;
                if (this.target != null && this.target.m_6084_()) {
                    double targetDist2;
                    double hitDist2 = from.m_82557_(hitVec);
                    shouldBreak = hitDist2 + 1.0E-6 < (targetDist2 = from.m_82557_(this.target.m_20299_(1.0f)));
                    BlockPos targetFeet = this.target.m_20183_();
                    BlockPos targetEyes = BlockPos.m_274446_((Position)this.target.m_20299_(1.0f));
                    if (hitBlock.m_123342_() >= targetFeet.m_123342_() && hitBlock.m_123342_() <= targetEyes.m_123342_()) {
                        shouldBreak = false;
                    }
                }
                if (shouldBreak && !(hitState = world.m_8055_(hitBlock)).m_60795_()) {
                    BlockPos above;
                    if (hitState.m_60800_((BlockGetter)world, hitBlock) > 0.0f) {
                        world.m_46953_(hitBlock, true, (Entity)this.caster);
                    }
                    if (world.m_8055_(above = hitBlock.m_7494_()).m_60795_()) {
                        world.m_46597_(above, ((EndFireBlock)((Object)AnnoyingVillagersModBlocks.END_FIRE.get())).m_49966_());
                    }
                }
                if (world.m_8055_(hitBlock.m_7494_()).m_60795_() && world.m_8055_(hitBlock).m_60804_((BlockGetter)world, hitBlock)) {
                    world.m_46597_(hitBlock.m_7494_(), ((EndFireBlock)((Object)AnnoyingVillagersModBlocks.END_FIRE.get())).m_49966_());
                }
            }
        } else {
            this.collidePosX = this.endPosX;
            this.collidePosY = this.endPosY;
            this.collidePosZ = this.endPosZ;
            this.blockSide = null;
        }
        List entities = world.m_45976_(LivingEntity.class, new AABB(Math.min(this.m_20185_(), this.collidePosX), Math.min(this.m_20186_(), this.collidePosY), Math.min(this.m_20189_(), this.collidePosZ), Math.max(this.m_20185_(), this.collidePosX), Math.max(this.m_20186_(), this.collidePosY), Math.max(this.m_20189_(), this.collidePosZ)).m_82377_(1.0, 1.0, 1.0));
        for (LivingEntity entity : entities) {
            if (entity == this.caster) continue;
            float pad = entity.m_6143_() + 0.5f;
            AABB aabb = entity.m_20191_().m_82377_((double)pad, (double)pad, (double)pad);
            Optional hit = aabb.m_82371_(from, to);
            if (aabb.m_82390_(from)) {
                result.addEntityHit(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            result.addEntityHit(entity);
        }
        return result;
    }

    public boolean isRenderable() {
        return this.target != null && this.target.m_6084_() || this.targetPos != null;
    }

    public void m_7334_(Entity entityIn) {
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6783_(double distance) {
        return distance < 1024.0;
    }

    public void m_8119_() {
        Vec3 to;
        Entity e;
        super.m_8119_();
        this.prevCollidePosX = this.collidePosX;
        this.prevCollidePosY = this.collidePosY;
        this.prevCollidePosZ = this.collidePosZ;
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        this.prevYaw = this.renderYaw;
        this.prevPitch = this.renderPitch;
        if (this.m_9236_().f_46443_) {
            this.renderYaw = this.getYaw();
            this.renderPitch = this.getPitch();
        }
        if (this.f_19797_ == 1 && this.m_9236_().f_46443_) {
            this.caster = (EnderDragon)this.m_9236_().m_6815_(this.getCasterID());
            this.target = (LivingEntity)this.m_9236_().m_6815_(this.getTargetID());
        }
        if (this.m_9236_().f_46443_ && this.target == null && this.getTargetID() != -1 && (e = this.m_9236_().m_6815_(this.getTargetID())) instanceof LivingEntity) {
            LivingEntity living;
            this.target = living = (LivingEntity)e;
        }
        if (this.caster != null) {
            this.m_6027_(this.caster.m_20185_(), this.caster.m_20186_() + (double)this.caster.m_20206_() * 0.6, this.caster.m_20189_());
        }
        if (this.target != null && this.target.m_6084_()) {
            from = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.targetPos = to = this.target.m_20299_(1.0f);
            targetYaw = DragonBeamEntity.yawTowards(from, to);
            targetPitch = DragonBeamEntity.pitchTowards(from, to);
            interpolatedYaw = Mth.m_14179_((float)0.85f, (float)this.getYaw(), (float)targetYaw);
            interpolatedPitch = Mth.m_14179_((float)0.85f, (float)this.getPitch(), (float)targetPitch);
            this.setYaw(interpolatedYaw);
            this.setPitch(interpolatedPitch);
            if (this.m_9236_().f_46443_) {
                this.renderYaw = interpolatedYaw;
                this.renderPitch = interpolatedPitch;
            }
        } else if (this.targetPos != null) {
            from = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            to = this.targetPos;
            targetYaw = DragonBeamEntity.yawTowards(from, to);
            targetPitch = DragonBeamEntity.pitchTowards(from, to);
            interpolatedYaw = Mth.m_14179_((float)0.5f, (float)this.getYaw(), (float)targetYaw);
            interpolatedPitch = Mth.m_14179_((float)0.5f, (float)this.getPitch(), (float)targetPitch);
            this.setYaw(interpolatedYaw);
            this.setPitch(interpolatedPitch);
            if (this.m_9236_().f_46443_) {
                this.renderYaw = interpolatedYaw;
                this.renderPitch = interpolatedPitch;
            }
        } else {
            return;
        }
        if (!this.on || this.caster != null && !this.caster.m_6084_()) {
            this.m_146870_();
            return;
        }
        if (this.m_9236_().f_46443_ && this.f_19797_ <= 10 && this.caster != null) {
            int particleCount = 8;
            while (--particleCount != 0) {
                double radius = 2.0f * this.caster.m_20205_();
                double yaw = (double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI;
                double pitch = (double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI;
                double ox = radius * Math.sin(yaw) * Math.sin(pitch);
                double var10000 = radius * Math.cos(pitch);
                double oz = radius * Math.cos(yaw) * Math.sin(pitch);
                double rootX = this.caster.m_20185_();
                double rootY = this.caster.m_20186_() + (double)(this.caster.m_20206_() / 2.0f) + (double)0.3f;
                double rootZ = this.caster.m_20189_();
                this.attractorPos[0] = new Vec3(rootX, rootY, rootZ);
            }
        }
        this.calculateEndPos();
        if (this.isRenderable() && this.m_9236_().m_5776_() && !this.renderBeam && this.f_19797_ >= 3) {
            this.renderBeam = true;
            Vec3 from = new Vec3(this.caster.f_31080_.m_20185_(), this.caster.f_31080_.m_20188_(), this.caster.f_31080_.m_20189_());
            to = new Vec3(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            new DragonBeamParticleEmitterInfo(new ResourceLocation("annoyingvillagers", "dragon_beam")).fromTo(from, to, DragonBeamParticleEmitterInfo.ForwardAxis.PLUS_Z, 0.0f).follow(this.caster.f_31080_, this.target, 120, DragonBeamParticleEmitterInfo.ForwardAxis.PLUS_Z, 0.0f).spawnInWorld(this.caster.m_9236_(), null);
        }
        if (this.isRenderable() && this.f_19797_ >= 50) {
            if (!this.playSound) {
                this.playSound = true;
                if (!this.m_9236_().m_5776_()) {
                    this.m_9236_().m_5594_((Player)null, new BlockPos((int)this.targetPos.f_82479_, (int)this.targetPos.f_82480_, (int)this.targetPos.f_82481_), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("annoyingvillagers", "dragon_breath")), SoundSource.NEUTRAL, (float)Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)0.05, (double)0.5), (float)Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)0.8, (double)1.1));
                } else {
                    this.m_9236_().m_7785_(this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("annoyingvillagers", "dragon_breath")), SoundSource.NEUTRAL, (float)Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)0.05, (double)0.5), (float)Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)0.8, (double)1.1), false);
                }
            }
            List<LivingEntity> hit = this.raytraceEntities((Level)this.m_9236_(), (Vec3)new Vec3((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()), (Vec3)new Vec3((double)this.endPosX, (double)this.endPosY, (double)this.endPosZ), (boolean)false, (boolean)true, (boolean)true).entities;
            if (!this.m_9236_().f_46443_) {
                for (LivingEntity target : hit) {
                    target.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this.caster), (float)this.power);
                    target.f_19864_ = true;
                    target.m_20334_(0.0, 0.0, 0.0);
                    target.m_6001_(0.0, 0.0, 0.0);
                }
            }
        }
        if (this.f_19797_ > this.getDuration()) {
            this.on = false;
        }
    }

    public static class DragonBeamHitResult {
        private BlockHitResult blockHit;
        private final List<LivingEntity> entities = new ArrayList<LivingEntity>();

        public BlockHitResult getBlockHit() {
            return this.blockHit;
        }

        public void setBlockHit(HitResult rayTraceResult) {
            if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
                this.blockHit = (BlockHitResult)rayTraceResult;
            }
        }

        public void addEntityHit(LivingEntity entity) {
            this.entities.add(entity);
        }
    }
}

