/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.annoyingvillagers.AnnoyingVillagers;
import com.pla.annoyingvillagers.clazz.HerobrineMob;
import com.pla.annoyingvillagers.entity.EliteHerobrineKnockedEntity;
import com.pla.annoyingvillagers.entity.HerobrineGregEntity;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModEntities;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModItems;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModMobEffects;
import com.pla.annoyingvillagers.item.EnderGlaiveItem;
import com.pla.annoyingvillagers.network.ClientboundGlaiveExplosionFx;
import com.pla.annoyingvillagers.network.ClientboundMuteExplosionAtPos;
import com.pla.annoyingvillagers.procedures.HerobrineWeaponEffectProcedure;
import com.pla.annoyingvillagers.util.DelayedTask;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;

public class GlaiveHerobrineEntity
extends HerobrineMob {
    private int nextStack = 3;

    public GlaiveHerobrineEntity(PlayMessages.SpawnEntity spawnentity, Level level) {
        this((EntityType<GlaiveHerobrineEntity>)((EntityType)AnnoyingVillagersModEntities.GLAIVE_HEROBRINE.get()), level);
    }

    public GlaiveHerobrineEntity(EntityType<GlaiveHerobrineEntity> entitytype, Level level) {
        super(entitytype, level);
        this.m_274367_(2.9f);
        this.f_21364_ = 300;
        this.m_21557_(false);
        this.m_6593_(this.m_5446_());
        this.m_20340_(true);
        this.m_21530_();
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)AnnoyingVillagersModItems.ENDER_GLAIVE.get()));
        this.setChatName(this.m_5446_().getString());
    }

    public int getCooldownTicks() {
        return this.getPersistentData().m_128451_("SwordCooldown");
    }

    public void setCooldownTicks(int ticks) {
        this.getPersistentData().m_128405_("SwordCooldown", ticks);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        pCompound.m_128405_("NextStack", this.nextStack);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.nextStack = pCompound.m_128441_("NextStack") ? pCompound.m_128451_("NextStack") : this.nextStack;
    }

    public boolean m_7327_(Entity pEntity) {
        if (!pEntity.m_9236_().m_5776_()) {
            this.getPersistentData().m_128405_("HitCount", (this.getPersistentData().m_128441_("HitCount") ? this.getPersistentData().m_128451_("HitCount") : 0) + 1);
        }
        return super.m_7327_(pEntity);
    }

    @Override
    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    public boolean m_6785_(double d0) {
        return false;
    }

    @Override
    public double m_6049_() {
        return -0.35;
    }

    @Override
    @NotNull
    public SoundEvent m_7975_(DamageSource damagesource) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    @Override
    @NotNull
    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource damagesource, float f) {
        if (!this.getPersistentData().m_128471_("kick_x")) {
            GlaiveHerobrineEntity livingentity;
            this.m_6858_(true);
            final GlaiveHerobrineEntity entity = this;
            new DelayedTask(10){

                @Override
                public void run() {
                    entity.m_6858_(false);
                }
            };
            if (Math.random() <= 0.5 && this instanceof LivingEntity && !(livingentity = this).m_9236_().m_5776_()) {
                livingentity.m_7292_(new MobEffectInstance((MobEffect)AnnoyingVillagersModMobEffects.BLOCK.get(), 1, 1, false, false));
            }
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        if (damagesource.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        return super.m_6469_(damagesource, f);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        boolean playSound = false;
        ItemStack itemStack = this.m_21205_();
        if (this.getPersistentData().m_128471_("SecondForm") && this.getPersistentData().m_128451_("HitCount") >= 3) {
            final GlaiveHerobrineEntity glaiveHerobrineEntity = this;
            Item item = itemStack.m_41720_();
            if (item instanceof EnderGlaiveItem) {
                final EnderGlaiveItem enderGlaiveItem = (EnderGlaiveItem)item;
                try {
                    if (!this.m_9236_().m_5776_()) {
                        this.m_20194_().m_129892_().m_82094_().execute("indestructible @s play \"wom:biped/combat/agony_auto_1\" 0 1", (Object)this.m_20203_().m_81324_().m_81325_(4));
                    }
                    new DelayedTask(3){

                        @Override
                        public void run() {
                            if (!glaiveHerobrineEntity.m_9236_().m_5776_()) {
                                Vec3 tipPos = EnderGlaiveItem.getJointWithTranslation((Entity)glaiveHerobrineEntity, new Vec3f(0.0f, 0.0f, 0.0f), Armatures.BIPED.toolR, 4.3f, 2.3f);
                                BlockPos mutePos = BlockPos.m_274446_((Position)tipPos);
                                AnnoyingVillagers.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> glaiveHerobrineEntity), (Object)new ClientboundMuteExplosionAtPos(mutePos, 4));
                                glaiveHerobrineEntity.m_9236_().m_255391_((Entity)glaiveHerobrineEntity, tipPos.f_82479_, tipPos.f_82480_, tipPos.f_82481_, 2.0f, true, Level.ExplosionInteraction.TNT);
                                Vec3 glaivePos = EnderGlaiveItem.getJointWithTranslation((Entity)glaiveHerobrineEntity, new Vec3f(0.0f, 0.0f, 0.0f), Armatures.BIPED.toolR, 1.3f, 2.3f);
                                Vec3 explosionPos = EnderGlaiveItem.getJointWithTranslation((Entity)glaiveHerobrineEntity, new Vec3f(0.0f, 0.0f, 0.0f), Armatures.BIPED.toolR, 10.3f, 2.3f);
                                AnnoyingVillagers.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> glaiveHerobrineEntity), (Object)new ClientboundGlaiveExplosionFx(glaivePos, explosionPos));
                                glaiveHerobrineEntity.m_9236_().m_5594_((Player)null, new BlockPos((int)explosionPos.f_82479_, (int)explosionPos.f_82480_, (int)explosionPos.f_82481_), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("annoyingvillagers:ender_shot")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                                glaiveHerobrineEntity.getPersistentData().m_128405_("HitCount", glaiveHerobrineEntity.getPersistentData().m_128441_("HitCount") ? glaiveHerobrineEntity.getPersistentData().m_128451_("HitCount") - 3 : 0);
                            }
                        }
                    };
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.getPersistentData().m_128471_("SecondForm")) {
                HerobrineWeaponEffectProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
                int cooldown = this.getCooldownTicks();
                if (cooldown > 0) {
                    this.setCooldownTicks(cooldown - 1);
                } else {
                    this.getPersistentData().m_128473_("SecondForm");
                }
            } else if (!this.getPersistentData().m_128471_("SecondForm") && this.getPersistentData().m_128451_("HitCount") >= this.nextStack) {
                this.getPersistentData().m_128379_("SecondForm", true);
                this.setCooldownTicks(200);
                this.getPersistentData().m_128405_("HitCount", 3);
                this.nextStack = new Random().nextInt(3, 6);
                playSound = true;
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 2));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 2));
            }
        }
        if (playSound) {
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_5594_((Player)null, new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("annoyingvillagers:second_form_release")), SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("annoyingvillagers:second_form_release")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            }
        }
    }

    public void m_6667_(DamageSource damagesource) {
        super.m_6667_(damagesource);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel levelaccessor;
            ServerLevel serverlevel = levelaccessor = (ServerLevel)level;
            EliteHerobrineKnockedEntity eliteHerobrineKnockedEntity = new EliteHerobrineKnockedEntity((EntityType<EliteHerobrineKnockedEntity>)((EntityType)AnnoyingVillagersModEntities.ELITE_HEROBRINE_KNOCKED.get()), (Level)serverlevel);
            eliteHerobrineKnockedEntity.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), levelaccessor.m_213780_().m_188501_() * 360.0f, 0.0f);
            eliteHerobrineKnockedEntity.getPersistentData().m_128359_("FromElite", "EnderGlaive");
            eliteHerobrineKnockedEntity.m_6518_((ServerLevelAccessor)serverlevel, levelaccessor.m_6436_(eliteHerobrineKnockedEntity.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            this.m_142687_(Entity.RemovalReason.KILLED);
            levelaccessor.m_7967_((Entity)eliteHerobrineKnockedEntity);
            if (this.getGregUUID() != null && (entity = levelaccessor.m_8791_(this.getGregUUID())) instanceof HerobrineGregEntity) {
                HerobrineGregEntity herobrineGregEntity = (HerobrineGregEntity)entity;
                if (entity.m_6084_()) {
                    herobrineGregEntity.requestProtect(eliteHerobrineKnockedEntity.m_20148_(), eliteHerobrineKnockedEntity);
                }
            }
        }
    }

    public void m_6075_() {
        super.m_6075_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 240.0);
        builder = builder.m_22268_(Attributes.f_22284_, 23.9);
        builder = builder.m_22268_(Attributes.f_22281_, 4.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        return builder;
    }
}

