/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.entity;

import com.pla.annoyingvillagers.clazz.HerobrineMob;
import com.pla.annoyingvillagers.entity.BlockProjectileEntity;
import com.pla.annoyingvillagers.entity.InfectedPlayerMobEntity;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModBlocks;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModEntities;
import com.pla.annoyingvillagers.procedures.HerobrineCloneBaseTickProcedure;
import com.pla.annoyingvillagers.procedures.HerobrineCloneOnHurtProcedure;
import com.pla.annoyingvillagers.spawnhandler.HerobrineMobData;
import com.pla.annoyingvillagers.util.DelayedTask;
import java.lang.reflect.Method;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import se.gory_moon.player_mobs.utils.NameManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class HerobrineCloneEntity
extends HerobrineMob {
    private boolean wasAiming = false;

    public HerobrineCloneEntity(PlayMessages.SpawnEntity spawnentity, Level level) {
        this((EntityType<HerobrineCloneEntity>)((EntityType)AnnoyingVillagersModEntities.HEROBRINE_CLONE.get()), level);
    }

    public HerobrineCloneEntity(EntityType<HerobrineCloneEntity> entitytype, Level level) {
        super(entitytype, level);
        this.m_274367_(0.7f);
        this.f_21364_ = 300;
        this.m_21557_(false);
        this.m_21530_();
        this.m_20340_(false);
        this.setChatName(this.m_5446_().getString());
    }

    @Override
    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    public boolean m_6785_(double d0) {
        return false;
    }

    @Override
    public double m_6049_() {
        return -0.35;
    }

    @Override
    protected void m_7472_(@NotNull DamageSource damagesource, int i, boolean flag) {
        super.m_7472_(damagesource, i, flag);
        this.m_19983_(new ItemStack((ItemLike)Blocks.f_50080_));
    }

    @Override
    @NotNull
    public SoundEvent m_7975_(DamageSource damagesource) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft", "entity.generic.hurt"));
    }

    @Override
    @NotNull
    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft", "entity.generic.death"));
    }

    public void m_8038_(ServerLevel serverlevel, LightningBolt lightningbolt) {
        super.m_8038_(serverlevel, lightningbolt);
    }

    @Override
    public boolean m_142535_(float f, float f1, @NotNull DamageSource damagesource) {
        return super.m_142535_(f, f1, damagesource);
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource damagesource, float f) {
        HerobrineCloneOnHurtProcedure.execute((Entity)this);
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        return super.m_6469_(damagesource, f);
    }

    public void m_6667_(DamageSource damagesource) {
        super.m_6667_(damagesource);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            InfectedPlayerMobEntity corpse = new InfectedPlayerMobEntity((EntityType<? extends InfectedPlayerMobEntity>)((EntityType)AnnoyingVillagersModEntities.INFECTED_PLAYER_MOB.get()), (Level)serverLevel);
            corpse.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            String killedName = this.getPersistentData().m_128461_("killed_name");
            corpse.getPersistentData().m_128359_("possessed_by", "herobrine_clone");
            if (killedName.isEmpty()) {
                killedName = String.valueOf(NameManager.INSTANCE.getRandomName());
            }
            corpse.setUsername(killedName);
            corpse.m_6593_((Component)Component.m_237113_((String)killedName));
            corpse.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            this.m_6842_(true);
            this.m_142687_(Entity.RemovalReason.KILLED);
            corpse.m_8061_(EquipmentSlot.HEAD, this.m_6844_(EquipmentSlot.HEAD).m_41777_());
            corpse.m_8061_(EquipmentSlot.CHEST, this.m_6844_(EquipmentSlot.CHEST).m_41777_());
            corpse.m_8061_(EquipmentSlot.LEGS, this.m_6844_(EquipmentSlot.LEGS).m_41777_());
            corpse.m_8061_(EquipmentSlot.FEET, this.m_6844_(EquipmentSlot.FEET).m_41777_());
            serverLevel.m_7967_((Entity)corpse);
        }
    }

    private static String currentEfAnimIdOrNull(LivingEntity self) {
        try {
            LivingEntityPatch patch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)self, LivingEntityPatch.class);
            if (patch == null) {
                return null;
            }
            AnimationPlayer player = patch.getAnimator().getPlayerFor((DynamicAnimation)null);
            if (player == null) {
                return null;
            }
            DynamicAnimation anim = player.getAnimation();
            if (anim == null) {
                return null;
            }
            try {
                Method m = anim.getClass().getMethod("getLocation", new Class[0]);
                ResourceLocation rl = (ResourceLocation)m.invoke((Object)anim, new Object[0]);
                return rl != null ? rl.m_135815_().toLowerCase(Locale.ROOT) : null;
            }
            catch (Exception ignored) {
                return anim.toString().toLowerCase(Locale.ROOT);
            }
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static boolean isAiming(String id) {
        if (id == null) {
            return false;
        }
        return id.contains("biped/combat/fist_dash") || id.endsWith("/fist_dash") || id.contains("fist_dash");
    }

    public void shootDarkObsAtTarget(double speed) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        LivingEntity target = this.m_5448_();
        Vec3 to = target != null && target.m_6084_() ? target.m_20299_(1.0f) : this.m_146892_().m_82549_(this.m_20154_().m_82490_(16.0));
        BlockState block = ((Block)AnnoyingVillagersModBlocks.OBSIDIAN_BLOCK.get()).m_49966_();
        BlockProjectileEntity throwingObsidian = new BlockProjectileEntity(this.m_9236_(), (LivingEntity)this, block);
        this.m_9236_().m_7967_((Entity)throwingObsidian);
        Vec3 dir = to.m_82546_(throwingObsidian.m_20182_());
        if (dir.m_82556_() < 1.0E-6) {
            dir = this.m_20154_();
        }
        Vec3 vel = dir.m_82541_().m_82490_(speed);
        throwingObsidian.m_20256_(vel);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            String animId = HerobrineCloneEntity.currentEfAnimIdOrNull((LivingEntity)this);
            boolean aimingNow = HerobrineCloneEntity.isAiming(animId);
            if (aimingNow && !this.wasAiming) {
                final HerobrineCloneEntity herobrine = this;
                new DelayedTask(10){

                    @Override
                    public void run() {
                        if (herobrine.m_6084_()) {
                            herobrine.shootDarkObsAtTarget(2.0);
                        }
                    }
                };
            }
            this.wasAiming = aimingNow;
        }
    }

    public void m_6075_() {
        super.m_6075_();
        HerobrineCloneBaseTickProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
    }

    public static boolean canSpawn(EntityType<HerobrineCloneEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        ServerLevel serverLevel = level.m_6018_();
        int passesDay = (int)(serverLevel.m_46467_() / 24000L);
        if (passesDay != 0 && passesDay % 3 != 0) {
            return false;
        }
        if (HerobrineMobData.get(serverLevel).isOccupied(serverLevel)) {
            return false;
        }
        if (!serverLevel.m_46462_()) {
            return false;
        }
        return Monster.m_219013_(entityType, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 40.0);
        builder = builder.m_22268_(Attributes.f_22284_, 40.0);
        builder = builder.m_22268_(Attributes.f_22281_, 9.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        builder = builder.m_22268_(Attributes.f_22282_, 2.0);
        return builder;
    }
}

