/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.annoyingvillagers.AnnoyingVillagers;
import com.pla.annoyingvillagers.block.ObsidianBlock;
import com.pla.annoyingvillagers.clazz.HerobrineMob;
import com.pla.annoyingvillagers.config.AnnoyingVillagersConfig;
import com.pla.annoyingvillagers.entity.AlexEntity;
import com.pla.annoyingvillagers.entity.AngrySteveEntity;
import com.pla.annoyingvillagers.entity.BbqEntity;
import com.pla.annoyingvillagers.entity.BlueDemon2Entity;
import com.pla.annoyingvillagers.entity.BlueDemonEntity;
import com.pla.annoyingvillagers.entity.BlueVillagerGeneralEntity;
import com.pla.annoyingvillagers.entity.ChrisEntity;
import com.pla.annoyingvillagers.entity.EliteHerobrineKnockedEntity;
import com.pla.annoyingvillagers.entity.GreenVillagerGeneralEntity;
import com.pla.annoyingvillagers.entity.JevEntity;
import com.pla.annoyingvillagers.entity.LowHerobrineCloneEntity;
import com.pla.annoyingvillagers.entity.LowShadowHerobrineCloneEntity;
import com.pla.annoyingvillagers.entity.PlayerNpcEntity;
import com.pla.annoyingvillagers.entity.PurpleVillagerGeneralEntity;
import com.pla.annoyingvillagers.entity.RedVillagerGeneralEntity;
import com.pla.annoyingvillagers.entity.Steve2Entity;
import com.pla.annoyingvillagers.entity.SteveEntity;
import com.pla.annoyingvillagers.entity.VillagerScoutCaptainEntity;
import com.pla.annoyingvillagers.entity.VillagerScoutEntity;
import com.pla.annoyingvillagers.gameasset.AVAnimations;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModBlocks;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModEntities;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModItems;
import com.pla.annoyingvillagers.network.ClientboundHerobrinePortalFx;
import com.pla.annoyingvillagers.procedures.HerobrinePortalProcedure;
import com.pla.annoyingvillagers.spawnhandler.GregData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.effect.EpicFightMobEffects;

public class HerobrineGregEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> WHITE_EYE = SynchedEntityData.m_135353_(HerobrineGregEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> USE_HEROBRINE_TEXTURE = SynchedEntityData.m_135353_(HerobrineGregEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean summoning = false;
    private int summonTiming = -1;
    private int escapeTiming = -1;
    private final LivingEntityPatch<?> livingentitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this, LivingEntityPatch.class);
    private int summonTimestamp = -1;
    private boolean combatMode = false;
    private int recallTime;
    private Entity firstSummonedHerobrine;
    private Entity secondSummonedHerobrine;
    private Entity thirdSummonedHerobrine;
    private UUID firstSummonedHerobrineUUID;
    private UUID secondSummonedHerobrineUUID;
    private UUID thirdSummonedHerobrineUUID;
    private BlockPos lastFeetPos = null;
    private final List<Item> listWeapons = new ArrayList<Item>(Arrays.asList(Items.f_42388_, Items.f_42391_, (Item)AnnoyingVillagersModItems.DIAMOND_SWORD.get(), (Item)AnnoyingVillagersModItems.DIAMOND_SPEAR.get(), (Item)AnnoyingVillagersModItems.DIAMOND_LONG_SWORD.get(), (Item)AnnoyingVillagersModItems.DIAMOND_GREAT_SWORD.get(), (Item)AnnoyingVillagersModItems.DIAMOND_BLADE.get(), (Item)AnnoyingVillagersModItems.DIAMOND_DAGGER.get(), (Item)AnnoyingVillagersModItems.HOOKED_DIAMOND_SWORD.get(), (Item)AnnoyingVillagersModItems.DIAMOND_MAGNET_SWORD.get(), (Item)AnnoyingVillagersModItems.DIAMOND_GREATE_BLADE.get(), (Item)AnnoyingVillagersModItems.DIAMOND_LONG_BLADE.get(), (Item)AnnoyingVillagersModItems.DIAMOND_HALBERD.get(), (Item)AnnoyingVillagersModItems.DIAMOND_SCYTHE.get(), (Item)AnnoyingVillagersModItems.DIAMOND_TWIN_BLADE.get(), (Item)AnnoyingVillagersModItems.DIAMOND_GIANT_AXE.get(), (Item)AnnoyingVillagersModItems.DIAMOND_BATTLE_AXE.get(), (Item)AnnoyingVillagersModItems.DIAMOND_GLAIVE.get(), (Item)AnnoyingVillagersModItems.DIAMOND_DOUBLE_BIT_AXE.get()));

    public LivingEntityPatch<?> getLivingentitypatch() {
        return this.livingentitypatch;
    }

    public void setWhiteEye(boolean whiteEye) {
        this.f_19804_.m_135381_(WHITE_EYE, (Object)whiteEye);
    }

    public boolean isWhiteEye() {
        return (Boolean)this.f_19804_.m_135370_(WHITE_EYE);
    }

    public void setUseHerobrineTexture(boolean useHerobrineTexture) {
        this.f_19804_.m_135381_(USE_HEROBRINE_TEXTURE, (Object)useHerobrineTexture);
    }

    public int getEscapeTiming() {
        return this.escapeTiming;
    }

    public void setEscapeTiming(int escapeTiming) {
        this.escapeTiming = escapeTiming;
    }

    public boolean isUseHerobrineTexture() {
        return (Boolean)this.f_19804_.m_135370_(USE_HEROBRINE_TEXTURE);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WHITE_EYE, (Object)false);
        this.f_19804_.m_135372_(USE_HEROBRINE_TEXTURE, (Object)false);
    }

    public boolean isSummoning() {
        return this.summoning;
    }

    public void setSummoning(boolean summoning) {
        this.summoning = summoning;
    }

    public int getSummonTimestamp() {
        return this.summonTimestamp;
    }

    public HerobrineGregEntity(PlayMessages.SpawnEntity spawnentity, Level level) {
        this((EntityType<HerobrineGregEntity>)((EntityType)AnnoyingVillagersModEntities.HEROBRINE_GREG.get()), level);
    }

    public HerobrineGregEntity(EntityType<HerobrineGregEntity> entitytype, Level level) {
        super(entitytype, level);
        this.m_274367_(2.5f);
        this.f_21364_ = 50;
        this.m_21557_(false);
        this.m_21530_();
        this.m_6593_((Component)Component.m_237113_((String)"Greg"));
        this.m_20340_(true);
        int min = (Integer)AnnoyingVillagersConfig.HEROBRINE_RECALL_MIN_TIME.get();
        int max = (Integer)AnnoyingVillagersConfig.HEROBRINE_RECALL_MAX_TIME.get();
        int randomMin = Math.min(min, max);
        int randomMax = Math.max(min, max);
        this.recallTime = (randomMin + new Random().nextInt(randomMax - randomMin + 1)) * 60 * 20;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new Goal(){

            public boolean m_8036_() {
                return HerobrineGregEntity.this.firstSummonedHerobrine != null && HerobrineGregEntity.this.firstSummonedHerobrine.m_6084_() && HerobrineGregEntity.this.m_20270_(HerobrineGregEntity.this.firstSummonedHerobrine) > 18.0f;
            }

            public void m_8037_() {
                if (HerobrineGregEntity.this.firstSummonedHerobrine != null && HerobrineGregEntity.this.firstSummonedHerobrine.m_6084_()) {
                    HerobrineGregEntity.this.m_21573_().m_5624_(HerobrineGregEntity.this.firstSummonedHerobrine, 2.0);
                    HerobrineGregEntity.this.m_21563_().m_24960_(HerobrineGregEntity.this.firstSummonedHerobrine, 30.0f, 30.0f);
                    if (HerobrineGregEntity.this.m_20280_(HerobrineGregEntity.this.firstSummonedHerobrine) > 20.0) {
                        if (HerobrineGregEntity.this.m_21573_().m_26571_()) {
                            HerobrineGregEntity.this.m_21573_().m_5624_(HerobrineGregEntity.this.firstSummonedHerobrine, 2.0);
                        }
                    } else {
                        HerobrineGregEntity.this.m_21573_().m_26573_();
                    }
                }
            }

            public boolean m_8045_() {
                return HerobrineGregEntity.this.firstSummonedHerobrine != null && HerobrineGregEntity.this.firstSummonedHerobrine.m_6084_() && (double)HerobrineGregEntity.this.m_20270_(HerobrineGregEntity.this.firstSummonedHerobrine) > 50.0;
            }
        });
        this.f_21345_.m_25352_(1, new Goal(){

            public boolean m_8036_() {
                return HerobrineGregEntity.this.secondSummonedHerobrine != null && HerobrineGregEntity.this.secondSummonedHerobrine.m_6084_() && HerobrineGregEntity.this.m_20270_(HerobrineGregEntity.this.secondSummonedHerobrine) > 18.0f;
            }

            public void m_8037_() {
                if (HerobrineGregEntity.this.secondSummonedHerobrine != null && HerobrineGregEntity.this.secondSummonedHerobrine.m_6084_()) {
                    HerobrineGregEntity.this.m_21573_().m_5624_(HerobrineGregEntity.this.secondSummonedHerobrine, 2.0);
                    HerobrineGregEntity.this.m_21563_().m_24960_(HerobrineGregEntity.this.secondSummonedHerobrine, 30.0f, 30.0f);
                    if (HerobrineGregEntity.this.m_20280_(HerobrineGregEntity.this.secondSummonedHerobrine) > 20.0) {
                        if (HerobrineGregEntity.this.m_21573_().m_26571_()) {
                            HerobrineGregEntity.this.m_21573_().m_5624_(HerobrineGregEntity.this.secondSummonedHerobrine, 2.0);
                        }
                    } else {
                        HerobrineGregEntity.this.m_21573_().m_26573_();
                    }
                }
            }

            public boolean m_8045_() {
                return HerobrineGregEntity.this.secondSummonedHerobrine != null && HerobrineGregEntity.this.secondSummonedHerobrine.m_6084_() && (double)HerobrineGregEntity.this.m_20270_(HerobrineGregEntity.this.secondSummonedHerobrine) > 50.0;
            }
        });
        this.f_21345_.m_25352_(1, new Goal(){

            public boolean m_8036_() {
                return HerobrineGregEntity.this.thirdSummonedHerobrine != null && HerobrineGregEntity.this.thirdSummonedHerobrine.m_6084_() && HerobrineGregEntity.this.m_20270_(HerobrineGregEntity.this.thirdSummonedHerobrine) > 18.0f;
            }

            public void m_8037_() {
                if (HerobrineGregEntity.this.thirdSummonedHerobrine != null && HerobrineGregEntity.this.thirdSummonedHerobrine.m_6084_()) {
                    HerobrineGregEntity.this.m_21573_().m_5624_(HerobrineGregEntity.this.thirdSummonedHerobrine, 2.0);
                    HerobrineGregEntity.this.m_21563_().m_24960_(HerobrineGregEntity.this.thirdSummonedHerobrine, 30.0f, 30.0f);
                    if (HerobrineGregEntity.this.m_20280_(HerobrineGregEntity.this.thirdSummonedHerobrine) > 20.0) {
                        if (HerobrineGregEntity.this.m_21573_().m_26571_()) {
                            HerobrineGregEntity.this.m_21573_().m_5624_(HerobrineGregEntity.this.thirdSummonedHerobrine, 2.0);
                        }
                    } else {
                        HerobrineGregEntity.this.m_21573_().m_26573_();
                    }
                }
            }

            public boolean m_8045_() {
                return HerobrineGregEntity.this.thirdSummonedHerobrine != null && HerobrineGregEntity.this.thirdSummonedHerobrine.m_6084_() && (double)HerobrineGregEntity.this.m_20270_(HerobrineGregEntity.this.thirdSummonedHerobrine) > 50.0;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, VillagerScoutEntity.class, 12.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, VillagerScoutCaptainEntity.class, 12.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, BlueVillagerGeneralEntity.class, 12.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, GreenVillagerGeneralEntity.class, 12.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, RedVillagerGeneralEntity.class, 12.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, PurpleVillagerGeneralEntity.class, 12.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, PlayerNpcEntity.class, 12.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 12.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, SteveEntity.class, 24.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Steve2Entity.class, 12.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, AngrySteveEntity.class, 12.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, AlexEntity.class, 12.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, JevEntity.class, 12.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, ChrisEntity.class, 12.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, BlueDemonEntity.class, 12.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, BlueDemon2Entity.class, 12.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, BbqEntity.class, 12.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new FloatGoal((Mob)this));
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public double m_6049_() {
        return -0.35;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new HerobrineMob.AnyFluidPathNavigation((Mob)this, level);
    }

    public boolean m_20069_() {
        FluidState fs = this.m_9236_().m_6425_(this.m_20183_());
        if (!fs.m_76178_() && this.m_203441_(fs)) {
            return false;
        }
        return super.m_20069_();
    }

    public boolean m_203441_(FluidState state) {
        return !state.m_76178_();
    }

    public boolean m_6063_() {
        return false;
    }

    private void assignProtect(Entity entity, UUID protectUUID, EliteHerobrineKnockedEntity protectEntity) {
        if (entity != null && entity.m_6084_()) {
            if (entity instanceof HerobrineMob) {
                HerobrineMob herobrineMob = (HerobrineMob)entity;
                herobrineMob.setProtectUUID(protectUUID);
                herobrineMob.setProtectEntity(protectEntity);
            } else if (entity instanceof LowShadowHerobrineCloneEntity) {
                LowShadowHerobrineCloneEntity lowShadowHerobrineCloneEntity = (LowShadowHerobrineCloneEntity)entity;
                lowShadowHerobrineCloneEntity.setProtectUUID(protectUUID);
                lowShadowHerobrineCloneEntity.setProtectEntity(protectEntity);
            }
        }
    }

    public void requestProtect(UUID protectUUID, EliteHerobrineKnockedEntity protectEntity) {
        this.m_9236_().m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)("<" + this.m_5446_().getString() + "> Protect him !!!")), false);
        this.assignProtect(this.firstSummonedHerobrine, protectUUID, protectEntity);
        this.assignProtect(this.secondSummonedHerobrine, protectUUID, protectEntity);
        this.assignProtect(this.thirdSummonedHerobrine, protectUUID, protectEntity);
    }

    private void floatOnAnyFluid() {
        BlockPos pos = this.m_20183_();
        FluidState fluidState = this.m_9236_().m_6425_(pos);
        if (fluidState.m_76178_()) {
            return;
        }
        CollisionContext collisionContext = CollisionContext.m_82750_((Entity)this);
        Fluid typeHere = fluidState.m_76152_();
        FluidState above = this.m_9236_().m_6425_(pos.m_7494_());
        if (collisionContext.m_6513_(LiquidBlock.f_54690_, pos, true) && above.m_76152_() != typeHere) {
            this.m_6853_(true);
            double surfaceY = (float)pos.m_123342_() + fluidState.m_76155_((BlockGetter)this.m_9236_(), pos);
            double bottomY = this.m_20191_().f_82289_;
            double diff = surfaceY - bottomY - 0.001;
            if (diff > 0.0) {
                Vec3 vel = this.m_20184_();
                this.m_20334_(vel.f_82479_, Math.max(vel.f_82480_, Math.min(0.2, diff * 0.2)), vel.f_82481_);
            }
        } else {
            this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
        }
        this.f_19789_ = 0.0f;
    }

    private void placeObsidianBlockWhenInWater(Block block) {
        BlockPos feet = this.m_20097_();
        if (this.lastFeetPos == null) {
            this.lastFeetPos = feet;
        }
        if (!feet.equals((Object)this.lastFeetPos)) {
            FluidState fluidState;
            if (!this.m_9236_().m_8055_(this.lastFeetPos).m_60713_(block) && !(fluidState = this.m_9236_().m_6425_(this.lastFeetPos)).m_76178_()) {
                int replace = fluidState.m_205070_(FluidTags.f_13131_) ? 1 : (fluidState.m_205070_(FluidTags.f_13132_) ? 2 : 0);
                this.m_9236_().m_46597_(this.lastFeetPos, (BlockState)block.m_49966_().m_61124_((Property)ObsidianBlock.REPLACE_BY_LIQUID, (Comparable)Integer.valueOf(replace)));
            }
            this.lastFeetPos = feet;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.floatOnAnyFluid();
        this.m_20101_();
        if (!this.m_9236_().f_46443_) {
            Entity entity;
            Level level;
            this.placeObsidianBlockWhenInWater((Block)AnnoyingVillagersModBlocks.CRYING_OBSIDIAN_BLOCK.get());
            if (!this.isDay(this.m_9236_())) {
                if (!this.isWhiteEye()) {
                    this.setWhiteEye(true);
                }
                if (!this.m_6844_(EquipmentSlot.CHEST).m_41720_().equals(AnnoyingVillagersModItems.BROKEN_DIAMOND_CHESTPLATE.get())) {
                    this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)AnnoyingVillagersModItems.BROKEN_DIAMOND_CHESTPLATE.get()));
                }
            } else {
                if (this.isWhiteEye() && this.summonTiming == -1) {
                    this.setWhiteEye(false);
                }
                if (!this.combatMode && this.m_6844_(EquipmentSlot.CHEST).m_41720_().equals(AnnoyingVillagersModItems.BROKEN_DIAMOND_CHESTPLATE.get())) {
                    this.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
                }
            }
            if (this.m_9236_().m_46468_() % 24000L == 13001L && this.summonTimestamp == -1) {
                if (new Random().nextBoolean()) {
                    this.m_9236_().m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)("<\u00a75Herobrine\u00a7r> " + Component.m_237115_((String)"subtitles.herobrine_prepare_for_fight").getString())), false);
                    this.summonTimestamp = new Random().nextInt(13100, 22200);
                    AnnoyingVillagers.LOGGER.info("[AV MOD DEBUG]: Greg will summon elites at {}", (Object)this.summonTimestamp);
                } else {
                    this.m_9236_().m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)("<\u00a75Herobrine\u00a7r> " + String.valueOf(Component.m_237115_((String)"subtitles.herobrine_no_fight")))), false);
                }
            }
            if (this.m_9236_().m_46468_() % 24000L == (long)this.summonTimestamp) {
                this.summonTimestamp = -2;
                this.combatMode = true;
                this.m_21557_(true);
                this.summoning = true;
                this.summonTiming = 20;
                this.m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 120, 3, false, false));
            }
            if (this.m_21223_() <= 2.0f && this.summonTiming == -1) {
                if (!this.isDay(this.m_9236_())) {
                    this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)AnnoyingVillagersModItems.BROKEN_DIAMOND_CHESTPLATE.get()));
                }
                this.setWhiteEye(true);
                this.m_21557_(true);
                this.summoning = true;
                this.summonTiming = 20;
                this.m_21153_(1.0f);
                this.m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 120, 3, false, false));
            }
            if (this.summonTiming > 0) {
                --this.summonTiming;
            }
            if (this.summonTiming == 10) {
                try {
                    this.m_20194_().m_129892_().m_82094_().execute("playsound annoyingvillagers:portal_summon voice @a ~ ~ ~", (Object)this.m_20203_().m_81324_().m_81325_(4));
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
                this.m_9236_().m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)("<" + this.m_5446_().getString() + "> " + Component.m_237115_((String)"subtitles.herobrine_summon").getString())), false);
            }
            if (this.summonTiming == 1) {
                if (this.combatMode) {
                    this.summonHerobrines();
                } else {
                    this.summonHerobrinesAndEscape();
                }
            }
            if (this.escapeTiming > 0) {
                --this.escapeTiming;
            }
            if (this.escapeTiming == 60 && this.combatMode) {
                try {
                    this.m_20194_().m_129892_().m_82094_().execute("playsound annoyingvillagers:portal_natural neutral @a ~ ~ ~", (Object)this.m_20203_().m_81324_().m_81325_(4));
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
                if (this.livingentitypatch != null) {
                    this.livingentitypatch.playAnimationSynchronized(AVAnimations.PORTAL_SUMMON, 0.0f);
                }
                AnnoyingVillagers.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ClientboundHerobrinePortalFx(HerobrinePortalProcedure.finalSurfacePos((Entity)this)));
            }
            if (this.escapeTiming == 40 && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                HerobrinePortalProcedure.sinkIntoGround(serverLevel, this, 0.06);
            }
            if (this.escapeTiming == 1) {
                LowShadowHerobrineCloneEntity lowShadowHerobrineCloneEntity;
                this.m_9236_().m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)("<\u00a75Herobrine\u00a7r> " + Component.m_237115_((String)"subtitles.herobrine_will_be_back").getString())), false);
                level = this.firstSummonedHerobrine;
                if (level instanceof LowShadowHerobrineCloneEntity) {
                    lowShadowHerobrineCloneEntity = (LowShadowHerobrineCloneEntity)level;
                    lowShadowHerobrineCloneEntity.setAutoKill(true);
                    try {
                        lowShadowHerobrineCloneEntity.m_20194_().m_129892_().m_82094_().execute("kill @s", (Object)this.m_20203_().m_81324_().m_81325_(4));
                    }
                    catch (CommandSyntaxException commandSyntaxException) {
                        // empty catch block
                    }
                }
                if ((level = this.secondSummonedHerobrine) instanceof LowShadowHerobrineCloneEntity) {
                    lowShadowHerobrineCloneEntity = (LowShadowHerobrineCloneEntity)level;
                    lowShadowHerobrineCloneEntity.setAutoKill(true);
                    try {
                        lowShadowHerobrineCloneEntity.m_20194_().m_129892_().m_82094_().execute("kill @s", (Object)this.m_20203_().m_81324_().m_81325_(4));
                    }
                    catch (CommandSyntaxException commandSyntaxException) {
                        // empty catch block
                    }
                }
                if ((level = this.thirdSummonedHerobrine) instanceof LowShadowHerobrineCloneEntity) {
                    lowShadowHerobrineCloneEntity = (LowShadowHerobrineCloneEntity)level;
                    lowShadowHerobrineCloneEntity.setAutoKill(true);
                    try {
                        lowShadowHerobrineCloneEntity.m_20194_().m_129892_().m_82094_().execute("kill @s", (Object)this.m_20203_().m_81324_().m_81325_(4));
                    }
                    catch (CommandSyntaxException commandSyntaxException) {
                        // empty catch block
                    }
                }
                this.m_146870_();
            }
            if (this.firstSummonedHerobrine == null && this.firstSummonedHerobrineUUID != null) {
                entity = ((ServerLevel)this.m_9236_()).m_8791_(this.firstSummonedHerobrineUUID);
                if (entity instanceof HerobrineMob || entity instanceof LowShadowHerobrineCloneEntity) {
                    this.firstSummonedHerobrine = entity;
                } else {
                    this.firstSummonedHerobrineUUID = null;
                }
            }
            if (this.firstSummonedHerobrine != null && !this.firstSummonedHerobrine.m_6084_()) {
                this.firstSummonedHerobrineUUID = null;
            }
            if (this.secondSummonedHerobrine == null && this.secondSummonedHerobrineUUID != null) {
                entity = ((ServerLevel)this.m_9236_()).m_8791_(this.secondSummonedHerobrineUUID);
                if (entity instanceof HerobrineMob || entity instanceof LowShadowHerobrineCloneEntity) {
                    this.secondSummonedHerobrine = entity;
                } else {
                    this.secondSummonedHerobrineUUID = null;
                }
            }
            if (this.secondSummonedHerobrine != null && !this.secondSummonedHerobrine.m_6084_()) {
                this.secondSummonedHerobrineUUID = null;
            }
            if (this.thirdSummonedHerobrine == null && this.thirdSummonedHerobrineUUID != null) {
                entity = ((ServerLevel)this.m_9236_()).m_8791_(this.thirdSummonedHerobrineUUID);
                if (entity instanceof HerobrineMob || entity instanceof LowShadowHerobrineCloneEntity) {
                    this.thirdSummonedHerobrine = entity;
                } else {
                    this.thirdSummonedHerobrineUUID = null;
                }
            }
            if (this.thirdSummonedHerobrine != null && !this.thirdSummonedHerobrine.m_6084_()) {
                this.thirdSummonedHerobrineUUID = null;
            }
            if (this.combatMode && this.escapeTiming == -1 && this.summonTiming == -2 && this.firstSummonedHerobrineUUID == null && this.secondSummonedHerobrineUUID == null && this.thirdSummonedHerobrineUUID == null) {
                this.escapeTiming = 80;
                this.m_21557_(true);
            }
            if (this.combatMode && this.escapeTiming == -1 && this.recallTime >= 0) {
                --this.recallTime;
                if (this.recallTime == 20) {
                    this.m_21557_(true);
                }
                if (this.recallTime <= 0) {
                    this.escapeTiming = 61;
                }
            }
            if (this.combatMode) {
                this.m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 1, 3, false, false));
            }
        }
    }

    private void summonHerobrine(String herobrineMobId, double spawnX, double spawnY, double spawnZ, double summonLookX, double summonLookZ, boolean renderPortal) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel levelaccessor = (ServerLevel)level;
            ResourceLocation mobResourceLocation = new ResourceLocation(herobrineMobId);
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(mobResourceLocation);
            if (type != null && (entity = type.m_20615_(this.m_9236_())) instanceof Mob) {
                Mob herobrine = (Mob)entity;
                if (herobrine instanceof HerobrineMob) {
                    HerobrineMob herobrineMob = (HerobrineMob)herobrine;
                    herobrineMob.setGregUUID(this.m_20148_());
                    herobrineMob.setRenderPortal(renderPortal);
                    herobrineMob.setRecallTicks(this.recallTime);
                } else if (herobrine instanceof LowHerobrineCloneEntity) {
                    LowHerobrineCloneEntity lowHerobrineCloneEntity = (LowHerobrineCloneEntity)herobrine;
                    lowHerobrineCloneEntity.setSummoned(true);
                    this.equipGearForLowHerobrineClone((Entity)lowHerobrineCloneEntity);
                } else if (herobrine instanceof LowShadowHerobrineCloneEntity) {
                    LowShadowHerobrineCloneEntity lowShadowHerobrineCloneEntity = (LowShadowHerobrineCloneEntity)herobrine;
                    if (renderPortal) {
                        AnnoyingVillagers.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ClientboundHerobrinePortalFx(new Vec3(spawnX, spawnY, spawnZ)));
                    } else {
                        this.equipGearForLowHerobrineClone((Entity)lowShadowHerobrineCloneEntity);
                    }
                    lowShadowHerobrineCloneEntity.setSummoned(true);
                }
                herobrine.m_7678_(spawnX, spawnY, spawnZ, this.m_146908_(), this.m_146909_());
                herobrine.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(summonLookX, spawnY, summonLookZ));
                herobrine.m_6518_((ServerLevelAccessor)levelaccessor, levelaccessor.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                levelaccessor.m_7967_((Entity)herobrine);
                if (this.combatMode) {
                    if (this.firstSummonedHerobrineUUID == null) {
                        this.firstSummonedHerobrineUUID = herobrine.m_20148_();
                        this.firstSummonedHerobrine = herobrine;
                    } else if (this.secondSummonedHerobrineUUID == null) {
                        this.secondSummonedHerobrineUUID = herobrine.m_20148_();
                        this.secondSummonedHerobrine = herobrine;
                    } else {
                        this.thirdSummonedHerobrineUUID = herobrine.m_20148_();
                        this.thirdSummonedHerobrine = herobrine;
                    }
                }
            }
        }
    }

    private void spawnHerobrineOffset(String id, double forwardDist, double lateralDist, double baseY, double fx, double fz, double lx, double lz, boolean renderPortal) {
        double spawnX = this.m_20185_() + fx * forwardDist + lx * lateralDist;
        double spawnZ = this.m_20189_() + fz * forwardDist + lz * lateralDist;
        double lookX = spawnX + fx * 10.0;
        double lookZ = spawnZ + fz * 10.0;
        this.summonHerobrine(id, spawnX, baseY, spawnZ, lookX, lookZ, renderPortal);
    }

    private void spawnRandomHerobrinesInRadius(String id, int count, int radius, boolean renderPortal) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        int cx = Mth.m_14107_((double)this.m_20185_());
        int cz = Mth.m_14107_((double)this.m_20189_());
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        int r2 = radius * radius;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                if (dx == 0 && dz == 0 || dx * dx + dz * dz > r2) continue;
                int x = cx + dx;
                int z = cz + dz;
                int y = sl.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
                candidates.add(new BlockPos(x, y, z));
            }
        }
        Collections.shuffle(candidates, new Random(this.m_217043_().m_188505_()));
        double yawRad = Math.toRadians(this.m_146908_());
        double fx = -Math.sin(yawRad);
        double fz = Math.cos(yawRad);
        int spawned = 0;
        for (BlockPos pos : candidates) {
            if (spawned >= count) break;
            if (!sl.m_46749_(pos) || !sl.m_6857_().m_61937_(pos) || !sl.m_46859_(pos) || !sl.m_46859_(pos.m_7494_()) || sl.m_46859_(pos.m_7495_())) continue;
            double spawnX = (double)pos.m_123341_() + 0.5;
            double spawnY = pos.m_123342_();
            double spawnZ = (double)pos.m_123343_() + 0.5;
            double lookX = spawnX + fx * 10.0;
            double lookZ = spawnZ + fz * 10.0;
            this.summonHerobrine(id, spawnX, spawnY, spawnZ, lookX, lookZ, renderPortal);
            ++spawned;
        }
    }

    private void summonEscapeAtDay() {
        this.escapeTiming = 70;
        AnnoyingVillagers.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ClientboundHerobrinePortalFx(HerobrinePortalProcedure.finalSurfacePos((Entity)this)));
        double yawRad = Math.toRadians(this.m_146908_());
        double fx = -Math.sin(yawRad);
        double fz = Math.cos(yawRad);
        double lx = Math.cos(yawRad);
        double lz = Math.sin(yawRad);
        double y = this.m_20186_();
        double front = 1.0;
        double side = 1.0;
        String leftHerobrine = Math.random() <= 0.5 ? "annoyingvillagers:low_herobrine_clone" : "annoyingvillagers:low_shadow_herobrine_clone";
        this.spawnHerobrineOffset(leftHerobrine, 0.0, side, y, fx, fz, lx, lz, false);
        String rightHerobrine = Math.random() <= 0.5 ? "annoyingvillagers:low_herobrine_clone" : "annoyingvillagers:low_shadow_herobrine_clone";
        this.spawnHerobrineOffset(rightHerobrine, 0.0, -side, y, fx, fz, lx, lz, false);
        if (Math.random() >= 0.7) {
            String frontHerobrine = Math.random() <= 0.5 ? "annoyingvillagers:low_herobrine_clone" : "annoyingvillagers:low_shadow_herobrine_clone";
            this.spawnHerobrineOffset(frontHerobrine, front, 0.0, y, fx, fz, lx, lz, false);
        }
    }

    private void summonEscapeAtNight() {
        this.escapeTiming = 70;
        AnnoyingVillagers.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ClientboundHerobrinePortalFx(HerobrinePortalProcedure.finalSurfacePos((Entity)this)));
        ArrayList<String> herobrines = new ArrayList<String>();
        herobrines.add("annoyingvillagers:herobrine_clone");
        herobrines.add("annoyingvillagers:shadow_herobrine_clone");
        herobrines.add("annoyingvillagers:herobrine_chris");
        herobrines.add("annoyingvillagers:herobrine_7");
        herobrines.add("annoyingvillagers:armored_herobrine");
        herobrines.add("annoyingvillagers:low_shadow_herobrine_clone");
        Random random = new Random();
        String herobrineId = (String)herobrines.get(random.nextInt(herobrines.size()));
        if (herobrineId.equals("annoyingvillagers:low_shadow_herobrine_clone")) {
            this.spawnRandomHerobrinesInRadius(herobrineId, new Random().nextInt(10, 20), 20, true);
        } else {
            double yawRad = Math.toRadians(this.m_146908_());
            double fx = -Math.sin(yawRad);
            double fz = Math.cos(yawRad);
            double lx = Math.cos(yawRad);
            double lz = Math.sin(yawRad);
            double y = this.m_20186_();
            double front = 1.0;
            this.spawnHerobrineOffset(herobrineId, front, 0.0, y, fx, fz, lx, lz, false);
        }
    }

    private ElitePattern pickWeightedElitePattern(Random random) {
        double roll = random.nextDouble();
        if (roll <= (double)0.1f) {
            return ElitePattern.THREE_E;
        }
        if (roll <= (double)0.2f) {
            return ElitePattern.TWOE_PLUS_1S;
        }
        if (roll <= (double)0.3f) {
            return ElitePattern.TWO_E;
        }
        if (roll <= (double)0.4f) {
            return ElitePattern.ONEE_PLUS_2S;
        }
        if (roll <= 0.5) {
            return ElitePattern.ONEE_PLUS_1S;
        }
        return ElitePattern.SOLO_1E;
    }

    private static <T> T pickRandom(List<T> list, Random random) {
        return list.remove(random.nextInt(list.size()));
    }

    private void summonAtNight() {
        ArrayList<String> herobrines = new ArrayList<String>();
        herobrines.add("annoyingvillagers:shadow_herobrine");
        herobrines.add("annoyingvillagers:elite");
        herobrines.add("annoyingvillagers:null");
        herobrines.add("annoyingvillagers:elite");
        ArrayList<String> elites = new ArrayList<String>();
        elites.add("annoyingvillagers:swordsman_herobrine");
        elites.add("annoyingvillagers:aegis_herobrine");
        elites.add("annoyingvillagers:glaive_herobrine");
        elites.add("annoyingvillagers:reaper_herobrine");
        elites.add("annoyingvillagers:sledgehammer_herobrine");
        float yaw = this.m_146908_();
        double rad = Math.toRadians(yaw);
        double fx = -Math.sin(rad);
        double fz = Math.cos(rad);
        double lx = Math.cos(rad);
        double lz = Math.sin(rad);
        double baseY = this.m_20186_();
        double centerForward = 3.0;
        double side = 1.0;
        double thirdForward = 4.0;
        double centerX = this.m_20185_() + fx * centerForward;
        double centerZ = this.m_20189_() + fz * centerForward;
        double lookX = centerX + fx * 10.0;
        double lookZ = centerZ + fz * 10.0;
        this.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(centerX, baseY, centerZ));
        if (!(this.m_9236_() instanceof ServerLevel)) {
            return;
        }
        AnnoyingVillagers.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ClientboundHerobrinePortalFx(new Vec3(centerX, baseY, centerZ)));
        Random random = new Random();
        String pick = (String)herobrines.get(random.nextInt(herobrines.size()));
        if (pick.equals("annoyingvillagers:shadow_herobrine") || pick.equals("annoyingvillagers:null")) {
            this.summonHerobrine(pick, centerX, baseY, centerZ, lookX, lookZ, false);
            return;
        }
        ElitePattern pattern = this.pickWeightedElitePattern(random);
        switch (pattern) {
            case SOLO_1E: {
                this.summonHerobrine((String)HerobrineGregEntity.pickRandom(elites, random), centerX, baseY, centerZ, lookX, lookZ, false);
                break;
            }
            case ONEE_PLUS_1S: {
                this.spawnHerobrineOffset((String)HerobrineGregEntity.pickRandom(elites, random), centerForward, side, baseY, fx, fz, lx, lz, false);
                this.spawnHerobrineOffset("annoyingvillagers:low_shadow_herobrine_clone", centerForward, -side, baseY, fx, fz, lx, lz, false);
                break;
            }
            case ONEE_PLUS_2S: {
                this.spawnHerobrineOffset("annoyingvillagers:low_shadow_herobrine_clone", centerForward, side, baseY, fx, fz, lx, lz, false);
                this.spawnHerobrineOffset("annoyingvillagers:low_shadow_herobrine_clone", centerForward, -side, baseY, fx, fz, lx, lz, false);
                this.spawnHerobrineOffset((String)HerobrineGregEntity.pickRandom(elites, random), thirdForward, 0.0, baseY, fx, fz, lx, lz, false);
                break;
            }
            case TWO_E: {
                this.spawnHerobrineOffset((String)HerobrineGregEntity.pickRandom(elites, random), centerForward, side, baseY, fx, fz, lx, lz, false);
                this.spawnHerobrineOffset((String)HerobrineGregEntity.pickRandom(elites, random), centerForward, -side, baseY, fx, fz, lx, lz, false);
                break;
            }
            case TWOE_PLUS_1S: {
                this.spawnHerobrineOffset("annoyingvillagers:low_shadow_herobrine_clone", centerForward, side, baseY, fx, fz, lx, lz, false);
                this.spawnHerobrineOffset((String)HerobrineGregEntity.pickRandom(elites, random), centerForward, -side, baseY, fx, fz, lx, lz, false);
                this.spawnHerobrineOffset((String)HerobrineGregEntity.pickRandom(elites, random), thirdForward, 0.0, baseY, fx, fz, lx, lz, false);
                break;
            }
            case THREE_E: {
                this.spawnHerobrineOffset((String)HerobrineGregEntity.pickRandom(elites, random), centerForward, side, baseY, fx, fz, lx, lz, false);
                this.spawnHerobrineOffset((String)HerobrineGregEntity.pickRandom(elites, random), centerForward, -side, baseY, fx, fz, lx, lz, false);
                this.spawnHerobrineOffset((String)HerobrineGregEntity.pickRandom(elites, random), thirdForward, 0.0, baseY, fx, fz, lx, lz, false);
            }
        }
    }

    private void summonHerobrines() {
        if (this.livingentitypatch != null) {
            this.livingentitypatch.playAnimationSynchronized(AVAnimations.PORTAL_SUMMON, 0.0f);
        }
        this.m_20340_(false);
        this.setUseHerobrineTexture(true);
        this.summonAtNight();
        this.summonTiming = -2;
    }

    private void summonHerobrinesAndEscape() {
        if (this.livingentitypatch != null) {
            this.livingentitypatch.playAnimationSynchronized(AVAnimations.PORTAL_SUMMON, 0.0f);
        }
        if (this.isDay(this.m_9236_())) {
            this.summonEscapeAtDay();
        } else {
            this.summonEscapeAtNight();
        }
    }

    public boolean m_6785_(double d0) {
        return false;
    }

    @NotNull
    public SoundEvent m_7975_(DamageSource damagesource) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    @NotNull
    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean isDay(Level level) {
        long timeOfDay = level.m_46468_() % 24000L;
        return timeOfDay >= 0L && timeOfDay < 13000L;
    }

    public boolean m_6469_(DamageSource damagesource, float f) {
        if (this.summoning || this.escapeTiming >= 0) {
            return false;
        }
        if (this.m_21223_() == 1.0f || this.combatMode) {
            if (!this.m_9236_().m_5776_()) {
                try {
                    this.m_20194_().m_129892_().m_82094_().execute("playsound epicfight:entity.hit.clash neutral @p", (Object)this.m_20203_().m_81324_().m_81325_(4));
                    this.m_20194_().m_129892_().m_82094_().execute("execute at @s run particle epicfight:hit_blade ^ ^1.5 ^0.8 0.1 0.1 0.1 1 1", (Object)this.m_20203_().m_81324_().m_81325_(4));
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268724_)) {
            return super.m_6469_(damagesource, f);
        }
        return super.m_6469_(damagesource, 1.0f);
    }

    private ItemStack randomDamage(ItemStack itemStack) {
        int maxDamage = itemStack.m_41776_();
        itemStack.m_41721_(new Random().nextInt(maxDamage / 3, maxDamage * 3 / 4));
        return itemStack;
    }

    private void equipGearForLowHerobrineClone(Entity entity) {
        if (entity instanceof LowShadowHerobrineCloneEntity && this.f_19796_.m_188501_() < 0.2f) {
            entity.m_8061_(EquipmentSlot.HEAD, this.randomDamage(new ItemStack((ItemLike)Items.f_42480_)));
            entity.m_8061_(EquipmentSlot.CHEST, this.randomDamage(new ItemStack((ItemLike)Items.f_42481_)));
            entity.m_8061_(EquipmentSlot.LEGS, this.randomDamage(new ItemStack((ItemLike)Items.f_42482_)));
            entity.m_8061_(EquipmentSlot.FEET, this.randomDamage(new ItemStack((ItemLike)Items.f_42483_)));
            entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42430_));
            entity.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42430_));
        } else {
            if (this.f_19796_.m_188501_() < 0.3f) {
                entity.m_8061_(EquipmentSlot.HEAD, this.randomDamage(new ItemStack((ItemLike)AnnoyingVillagersModItems.BROKEN_DIAMOND_HELMET.get())));
            }
            if (this.f_19796_.m_188501_() < 0.3f) {
                entity.m_8061_(EquipmentSlot.CHEST, this.randomDamage(new ItemStack((ItemLike)AnnoyingVillagersModItems.BROKEN_DIAMOND_CHESTPLATE.get())));
            }
            if (this.f_19796_.m_188501_() < 0.3f) {
                entity.m_8061_(EquipmentSlot.LEGS, this.randomDamage(new ItemStack((ItemLike)AnnoyingVillagersModItems.BROKEN_DIAMOND_LEGGINGS.get())));
            }
            if (this.f_19796_.m_188501_() < 0.3f) {
                entity.m_8061_(EquipmentSlot.FEET, this.randomDamage(new ItemStack((ItemLike)AnnoyingVillagersModItems.BROKEN_DIAMOND_BOOTS.get())));
            }
            entity.m_8061_(EquipmentSlot.MAINHAND, this.randomDamage(new ItemStack((ItemLike)this.listWeapons.get(this.f_19796_.m_188503_(this.listWeapons.size())))));
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverlevelaccessor, DifficultyInstance difficultyinstance, MobSpawnType mobspawntype, @Nullable SpawnGroupData spawngroupdata, @Nullable CompoundTag compoundtag) {
        if (mobspawntype == MobSpawnType.NATURAL || mobspawntype == MobSpawnType.CHUNK_GENERATION) {
            ServerLevel serverLevel = serverlevelaccessor.m_6018_();
            GregData gregData = GregData.get(serverLevel);
            if (!gregData.tryClaim(serverLevel, this.m_20148_())) {
                this.m_146870_();
                return null;
            }
            BlockPos blockPos = this.m_20097_();
            int surfaceY = serverLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, blockPos).m_123342_();
            BlockPos spawnPos = new BlockPos(blockPos.m_123341_(), surfaceY, blockPos.m_123343_());
            this.m_20035_(spawnPos, this.m_146908_(), this.m_146909_());
        }
        SpawnGroupData spawngroupdata1 = super.m_6518_(serverlevelaccessor, difficultyinstance, mobspawntype, spawngroupdata, compoundtag);
        if (!this.m_9236_().m_5776_() && this.m_20194_() != null) {
            try {
                this.m_20194_().m_129892_().m_82094_().execute("tellraw @a {\"text\":\"Greg has joined the game\",\"color\":\"yellow\"}", (Object)this.m_20203_().m_81324_().m_81325_(4));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return spawngroupdata1;
    }

    public void m_5993_(Entity entity, int i, DamageSource damagesource) {
        super.m_5993_(entity, i, damagesource);
    }

    public void m_6075_() {
        super.m_6075_();
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setWhiteEye(pCompound.m_128471_("WhiteEye"));
        this.setUseHerobrineTexture(pCompound.m_128471_("UseHerobrineTexture"));
        this.summoning = pCompound.m_128471_("Summoning");
        this.summonTiming = pCompound.m_128451_("SummonTiming");
        this.escapeTiming = pCompound.m_128451_("EscapeTiming");
        this.summonTimestamp = pCompound.m_128451_("SummonTimestamp");
        this.combatMode = pCompound.m_128471_("CombatMode");
        this.recallTime = pCompound.m_128451_("RecallTime");
        if (pCompound.m_128403_("FirstSummonedHerobrineUUID")) {
            this.firstSummonedHerobrineUUID = pCompound.m_128342_("FirstSummonedHerobrineUUID");
        }
        if (pCompound.m_128403_("SecondSummonedHerobrineUUID")) {
            this.secondSummonedHerobrineUUID = pCompound.m_128342_("SecondSummonedHerobrineUUID");
        }
        if (pCompound.m_128403_("ThirdSummonedHerobrineUUID")) {
            this.thirdSummonedHerobrineUUID = pCompound.m_128342_("ThirdSummonedHerobrineUUID");
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("WhiteEye", this.isWhiteEye());
        pCompound.m_128379_("UseHerobrineTexture", this.isUseHerobrineTexture());
        pCompound.m_128379_("Summoning", this.summoning);
        pCompound.m_128405_("SummonTiming", this.summonTiming);
        pCompound.m_128405_("EscapeTiming", this.escapeTiming);
        pCompound.m_128405_("SummonTimestamp", this.summonTimestamp);
        pCompound.m_128379_("CombatMode", this.combatMode);
        pCompound.m_128405_("RecallTime", this.recallTime);
        if (this.firstSummonedHerobrineUUID != null) {
            pCompound.m_128362_("FirstSummonedHerobrineUUID", this.firstSummonedHerobrineUUID);
        }
        if (this.secondSummonedHerobrineUUID != null) {
            pCompound.m_128362_("SecondSummonedHerobrineUUID", this.secondSummonedHerobrineUUID);
        }
        if (this.thirdSummonedHerobrineUUID != null) {
            pCompound.m_128362_("ThirdSummonedHerobrineUUID", this.thirdSummonedHerobrineUUID);
        }
    }

    public static boolean canSpawn(EntityType<HerobrineGregEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        ServerLevel serverLevel = level.m_6018_();
        int passesDay = (int)(serverLevel.m_46467_() / 24000L);
        if (passesDay != 0 && passesDay % 5 != 0) {
            return false;
        }
        if (GregData.get(serverLevel).isOccupied(serverLevel)) {
            return false;
        }
        return Monster.m_219013_(entityType, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        Level level;
        super.m_142687_(reason);
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (reason == Entity.RemovalReason.KILLED || reason == Entity.RemovalReason.DISCARDED) {
                GregData.get(serverLevel).releaseIfMatches(serverLevel, this.m_20148_());
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.5);
        builder = builder.m_22268_(Attributes.f_22276_, 40.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        return builder;
    }

    private static enum ElitePattern {
        SOLO_1E,
        ONEE_PLUS_1S,
        ONEE_PLUS_2S,
        TWO_E,
        TWOE_PLUS_1S,
        THREE_E;

    }
}

