/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.annoyingvillagers.AnnoyingVillagers;
import com.pla.annoyingvillagers.clazz.HerobrineMob;
import com.pla.annoyingvillagers.config.AnnoyingVillagersConfig;
import com.pla.annoyingvillagers.entity.EliteHerobrineKnockedEntity;
import com.pla.annoyingvillagers.entity.InfectedPlayerMobEntity;
import com.pla.annoyingvillagers.entity.PlayerMobDeadEntity;
import com.pla.annoyingvillagers.gameasset.AVAnimations;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModEntities;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModParticleTypes;
import com.pla.annoyingvillagers.network.ClientboundHerobrinePortalFx;
import com.pla.annoyingvillagers.procedures.HerobrineOnInitialSpawnProcedure;
import com.pla.annoyingvillagers.procedures.HerobrinePortalProcedure;
import com.pla.annoyingvillagers.procedures.LowHerobrineCloneOnHurtProcedure;
import com.pla.annoyingvillagers.util.CommonGoals;
import com.pla.annoyingvillagers.util.DelayedTask;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import se.gory_moon.player_mobs.entity.PlayerMobEntity;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.effect.EpicFightMobEffects;

public class LowHerobrineCloneEntity
extends PlayerMobEntity {
    private boolean summoned = false;
    private boolean initialSpawn = true;
    private boolean autoKill = false;
    private HerobrineMob possessedByEntity;
    private UUID possessedByUuid;
    private boolean bound = false;
    private boolean sacrificing = false;
    private final LivingEntityPatch<?> livingentitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this, LivingEntityPatch.class);
    private EliteHerobrineKnockedEntity protectEntity;
    private UUID protectUUID;
    boolean renderPortal = false;

    public boolean isSacrificing() {
        return this.sacrificing;
    }

    public HerobrineMob getPossessedByEntity() {
        return this.possessedByEntity;
    }

    public void setRenderPortal(boolean renderPortal) {
        this.renderPortal = renderPortal;
    }

    public boolean isSummoned() {
        return this.summoned;
    }

    public void setSummoned(boolean summoned) {
        this.summoned = summoned;
    }

    public void setInitialSpawn(boolean initialSpawn) {
        this.initialSpawn = initialSpawn;
    }

    public void setPossessedByUuid(UUID possessedByUuid) {
        this.possessedByUuid = possessedByUuid;
    }

    public void setPossessedByEntity(HerobrineMob possessedByEntity) {
        this.possessedByEntity = possessedByEntity;
    }

    public void setSacrificing(boolean sacrificing) {
        this.sacrificing = sacrificing;
    }

    public LowHerobrineCloneEntity(EntityType<? extends LowHerobrineCloneEntity> type, Level level) {
        super(type, level);
        this.m_274367_(3.0f);
        this.f_21364_ = 50;
        this.m_21557_(false);
        this.m_21530_();
        this.m_20340_(false);
    }

    public LowHerobrineCloneEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends LowHerobrineCloneEntity>)((EntityType)AnnoyingVillagersModEntities.LOW_HEROBRINE_CLONE.get()), level);
    }

    public boolean m_6469_(DamageSource damagesource, float f) {
        if (this.sacrificing) {
            if (new Random().nextBoolean()) {
                try {
                    this.m_20194_().m_129892_().m_82094_().execute("playsound epicfight:entity.hit.clash neutral @p", (Object)this.m_20203_().m_81324_().m_81325_(4));
                    this.m_20194_().m_129892_().m_82094_().execute("execute at @s run particle epicfight:hit_blade ^ ^1.5 ^0.8 0.1 0.1 0.1 1 1", (Object)this.m_20203_().m_81324_().m_81325_(4));
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
                return false;
            }
            return super.m_6469_(damagesource, f / 2.0f);
        }
        LowHerobrineCloneOnHurtProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), damagesource.m_7639_());
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        return super.m_6469_(damagesource, f);
    }

    public boolean m_8077_() {
        return false;
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"\u00a75Low Herobrine Clone\u00a7r");
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_148105_().clear();
        this.f_21346_.m_148105_().clear();
        this.f_21345_.m_25352_(1, new Goal(){

            public boolean m_8036_() {
                return LowHerobrineCloneEntity.this.protectEntity != null && LowHerobrineCloneEntity.this.protectEntity.m_6084_() && LowHerobrineCloneEntity.this.m_20270_((Entity)LowHerobrineCloneEntity.this.protectEntity) > 9.0f;
            }

            public void m_8037_() {
                if (LowHerobrineCloneEntity.this.protectEntity != null && LowHerobrineCloneEntity.this.protectEntity.m_6084_()) {
                    LowHerobrineCloneEntity.this.m_21573_().m_5624_((Entity)LowHerobrineCloneEntity.this.protectEntity, 2.0);
                    LowHerobrineCloneEntity.this.m_21563_().m_24960_((Entity)LowHerobrineCloneEntity.this.protectEntity, 30.0f, 30.0f);
                    if (LowHerobrineCloneEntity.this.m_20280_((Entity)LowHerobrineCloneEntity.this.protectEntity) > 10.0) {
                        if (LowHerobrineCloneEntity.this.m_21573_().m_26571_()) {
                            LowHerobrineCloneEntity.this.m_21573_().m_5624_((Entity)LowHerobrineCloneEntity.this.protectEntity, 2.0);
                        }
                    } else {
                        LowHerobrineCloneEntity.this.m_21573_().m_26573_();
                    }
                }
            }

            public boolean m_8045_() {
                return LowHerobrineCloneEntity.this.protectEntity != null && LowHerobrineCloneEntity.this.protectEntity.m_6084_() && (double)LowHerobrineCloneEntity.this.m_20270_((Entity)LowHerobrineCloneEntity.this.protectEntity) > 50.0;
            }
        });
        this.f_21345_.m_25352_(1, new Goal(){

            public boolean m_8036_() {
                return LowHerobrineCloneEntity.this.possessedByEntity != null && LowHerobrineCloneEntity.this.possessedByEntity.m_6084_() && LowHerobrineCloneEntity.this.m_20270_((Entity)LowHerobrineCloneEntity.this.possessedByEntity) > 18.0f;
            }

            public void m_8037_() {
                if (LowHerobrineCloneEntity.this.possessedByEntity != null && LowHerobrineCloneEntity.this.possessedByEntity.m_6084_()) {
                    LowHerobrineCloneEntity.this.m_21573_().m_5624_((Entity)LowHerobrineCloneEntity.this.possessedByEntity, 2.0);
                    LowHerobrineCloneEntity.this.m_21563_().m_24960_((Entity)LowHerobrineCloneEntity.this.possessedByEntity, 30.0f, 30.0f);
                    if (LowHerobrineCloneEntity.this.m_20280_((Entity)LowHerobrineCloneEntity.this.possessedByEntity) > 20.0) {
                        if (LowHerobrineCloneEntity.this.m_21573_().m_26571_()) {
                            LowHerobrineCloneEntity.this.m_21573_().m_5624_((Entity)LowHerobrineCloneEntity.this.possessedByEntity, 2.0);
                        }
                    } else {
                        LowHerobrineCloneEntity.this.m_21573_().m_26573_();
                    }
                }
            }

            public boolean m_8045_() {
                return LowHerobrineCloneEntity.this.possessedByEntity != null && LowHerobrineCloneEntity.this.possessedByEntity.m_6084_() && (double)LowHerobrineCloneEntity.this.m_20270_((Entity)LowHerobrineCloneEntity.this.possessedByEntity) > 50.0;
            }
        });
        CommonGoals.registerGoalForHostileNpc((Monster)this);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6785_(double d0) {
        return false;
    }

    public double m_6049_() {
        return -0.35;
    }

    public SoundEvent m_7975_(DamageSource damagesource) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public void m_6667_(DamageSource damagesource) {
        ItemEntity itementity;
        ItemStack itemstack;
        Level level;
        super.m_6667_(damagesource);
        if (!this.autoKill) {
            Level level2 = this.m_9236_();
            if (level2 instanceof ServerLevel) {
                serverLevel = (ServerLevel)level2;
                InfectedPlayerMobEntity corpse = new InfectedPlayerMobEntity((EntityType<? extends InfectedPlayerMobEntity>)((EntityType)AnnoyingVillagersModEntities.INFECTED_PLAYER_MOB.get()), serverLevel);
                corpse.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
                String killedName = this.m_7770_().getString();
                corpse.getPersistentData().m_128359_("possessed_by", "low_herobrine_clone");
                corpse.setUsername(killedName);
                corpse.m_6593_((Component)Component.m_237113_((String)killedName));
                corpse.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                this.m_6842_(true);
                this.m_142687_(Entity.RemovalReason.KILLED);
                corpse.m_8061_(EquipmentSlot.HEAD, this.m_6844_(EquipmentSlot.HEAD).m_41777_());
                corpse.m_8061_(EquipmentSlot.CHEST, this.m_6844_(EquipmentSlot.CHEST).m_41777_());
                corpse.m_8061_(EquipmentSlot.LEGS, this.m_6844_(EquipmentSlot.LEGS).m_41777_());
                corpse.m_8061_(EquipmentSlot.FEET, this.m_6844_(EquipmentSlot.FEET).m_41777_());
                serverLevel.m_7967_((Entity)corpse);
            }
        } else {
            serverLevel = this.m_9236_();
            if (serverLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)serverLevel;
                if (((Boolean)AnnoyingVillagersConfig.PHYSIC_MOD_COMPAT.get()).booleanValue()) {
                    final PlayerMobDeadEntity corpse = new PlayerMobDeadEntity((EntityType<? extends PlayerMobDeadEntity>)((EntityType)AnnoyingVillagersModEntities.PLAYER_MOB_DEAD.get()), (Level)serverLevel);
                    corpse.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
                    corpse.setUsername(this.getUsername());
                    corpse.setProfile(this.getProfile());
                    corpse.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    this.m_6842_(true);
                    this.m_142687_(Entity.RemovalReason.KILLED);
                    serverLevel.m_7967_((Entity)corpse);
                    new DelayedTask(3){

                        @Override
                        public void run() {
                            try {
                                corpse.m_20194_().m_129892_().m_82094_().execute("kill @s", (Object)corpse.m_20203_().m_81324_().m_81325_(4));
                            }
                            catch (CommandSyntaxException commandSyntaxException) {
                                // empty catch block
                            }
                        }
                    };
                }
            }
        }
        Level levelaccessor1 = this.m_9236_();
        LowHerobrineCloneEntity livingentity = this;
        if (levelaccessor1 instanceof Level && !(level = levelaccessor1).m_5776_()) {
            itemstack = livingentity.m_21205_();
            itementity = new ItemEntity(level, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), itemstack);
            itementity.m_32010_(10);
            level.m_7967_((Entity)itementity);
        }
        if (levelaccessor1 instanceof Level && !(level = levelaccessor1).m_5776_()) {
            itemstack = livingentity.m_21206_();
            itementity = new ItemEntity(level, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), itemstack);
            itementity.m_32010_(10);
            level.m_7967_((Entity)itementity);
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverlevelaccessor, DifficultyInstance difficultyinstance, MobSpawnType mobspawntype, @Nullable SpawnGroupData spawngroupdata, @Nullable CompoundTag compoundtag) {
        HerobrineOnInitialSpawnProcedure.execute((LevelAccessor)serverlevelaccessor, (Entity)this, 0, mobspawntype);
        return spawngroupdata;
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.summoned = pCompound.m_128471_("Summoned");
        this.renderPortal = pCompound.m_128471_("RenderPortal");
        this.initialSpawn = pCompound.m_128471_("InitialSpawn");
        this.autoKill = pCompound.m_128471_("AutoKill");
        if (pCompound.m_128403_("ProtectUUID")) {
            this.protectUUID = pCompound.m_128342_("ProtectUUID");
        }
        if (pCompound.m_128403_("PossessedByUuid")) {
            this.possessedByUuid = pCompound.m_128342_("PossessedByUuid");
        }
        this.bound = pCompound.m_128471_("Bound");
        this.sacrificing = pCompound.m_128471_("Sacrificing");
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Summoned", this.summoned);
        pCompound.m_128379_("InitialSpawn", this.initialSpawn);
        pCompound.m_128379_("RenderPortal", this.renderPortal);
        pCompound.m_128379_("AutoKill", this.autoKill);
        if (this.protectUUID != null) {
            pCompound.m_128362_("ProtectUUID", this.protectUUID);
        }
        if (this.possessedByUuid != null) {
            pCompound.m_128362_("PossessedByUuid", this.possessedByUuid);
        }
        pCompound.m_128379_("Bound", this.bound);
        pCompound.m_128379_("Sacrificing", this.sacrificing);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            Entity entity2;
            if (this.f_19797_ == 1 && this.initialSpawn) {
                LivingEntityPatch livingentitypatch;
                if (this.renderPortal) {
                    AnnoyingVillagers.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ClientboundHerobrinePortalFx(HerobrinePortalProcedure.finalSurfacePos((Entity)this)));
                    this.renderPortal = false;
                }
                if (this.summoned) {
                    this.m_21557_(true);
                }
                if ((livingentitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this, LivingEntityPatch.class)) != null && !this.m_9236_().m_5776_()) {
                    livingentitypatch.playAnimationSynchronized(AVAnimations.HEROBRINE_ANIMATE, 0.0f);
                }
                this.initialSpawn = false;
            }
            if (this.protectEntity == null && this.protectUUID != null) {
                EliteHerobrineKnockedEntity eliteHerobrineKnockedEntity;
                entity2 = ((ServerLevel)this.m_9236_()).m_8791_(this.protectUUID);
                this.protectEntity = entity2 instanceof EliteHerobrineKnockedEntity ? (eliteHerobrineKnockedEntity = (EliteHerobrineKnockedEntity)entity2) : null;
            }
            if (this.protectEntity != null && !this.protectEntity.m_6084_()) {
                this.protectEntity = null;
                this.protectUUID = null;
                this.autoKill = true;
                this.m_6074_();
            }
            if (this.possessedByEntity == null && this.possessedByUuid != null) {
                HerobrineMob herobrineMob;
                entity2 = ((ServerLevel)this.m_9236_()).m_8791_(this.possessedByUuid);
                this.possessedByEntity = entity2 instanceof HerobrineMob ? (herobrineMob = (HerobrineMob)entity2) : null;
            }
            if (!this.bound && this.possessedByEntity != null && this.possessedByEntity.m_6084_() && !this.possessedByEntity.isHealing() && this.possessedByEntity.isAvailableSlot() && this.possessedByEntity.boundPossessed((Entity)this)) {
                this.bound = true;
            }
            if (this.possessedByEntity != null && !this.possessedByEntity.m_6084_()) {
                AABB area = new AABB(this.m_20183_()).m_82400_(60.0);
                List nearby = this.m_9236_().m_6249_((Entity)this, area, entity -> entity instanceof EliteHerobrineKnockedEntity);
                if (!nearby.isEmpty()) {
                    Entity entity3 = (Entity)nearby.get(0);
                    if (entity3 instanceof EliteHerobrineKnockedEntity) {
                        EliteHerobrineKnockedEntity eliteHerobrineKnockedEntity;
                        this.protectEntity = eliteHerobrineKnockedEntity = (EliteHerobrineKnockedEntity)entity3;
                        this.protectUUID = eliteHerobrineKnockedEntity.m_20148_();
                    } else {
                        this.possessedByEntity = null;
                        this.possessedByUuid = null;
                        this.autoKill = true;
                        this.m_6074_();
                    }
                } else {
                    this.possessedByEntity = null;
                    this.possessedByUuid = null;
                    this.autoKill = true;
                    this.m_6074_();
                }
            }
            if (this.sacrificing) {
                if (this.m_21223_() <= 2.0f) {
                    this.sacrificing = false;
                    this.autoKill = true;
                    this.m_6074_();
                }
                this.m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 1, 3, false, false));
                if (this.livingentitypatch != null) {
                    this.livingentitypatch.playAnimationSynchronized(AVAnimations.HEROBRINE_SACRIFICING, 0.0f);
                }
                if (this.f_19797_ % 140 == 0 && (double)this.possessedByEntity.m_21223_() < (double)this.possessedByEntity.m_21233_() * 0.8) {
                    try {
                        this.m_20194_().m_129892_().m_82094_().execute("playsound annoyingvillagers:herobrine_understood voice @a ~ ~ ~", (Object)this.m_20203_().m_81324_().m_81325_(4));
                    }
                    catch (CommandSyntaxException area) {
                        // empty catch block
                    }
                }
                if (this.f_19797_ % 20 == 0 && this.possessedByEntity != null) {
                    if (this.possessedByEntity.m_21233_() == this.possessedByEntity.m_21223_()) {
                        this.sacrificing = false;
                        this.autoKill = true;
                        this.m_6074_();
                    }
                    if (this.m_21223_() <= 4.0f) {
                        this.sacrificing = false;
                        this.autoKill = true;
                        this.m_6074_();
                    } else {
                        this.m_21153_(this.m_21223_() - 2.0f);
                    }
                    this.possessedByEntity.m_5634_(this.possessedByEntity.m_21233_() * 0.01f);
                }
                if (this.possessedByEntity != null) {
                    ServerLevel server = (ServerLevel)this.m_9236_();
                    Vec3 from = LowHerobrineCloneEntity.getArmPosition((Entity)this, new Vec3f(0.0f, 0.0f, 0.0f), Armatures.BIPED.toolR, 1.2f, 0.0);
                    if (from == null) {
                        return;
                    }
                    Vec3 to = this.possessedByEntity.m_146892_();
                    AABB box = this.possessedByEntity.m_20191_().m_82400_(0.05);
                    Vec3 end = box.m_82371_(from, to).orElse(to);
                    Vec3 d = end.m_82546_(from);
                    double len = d.m_82553_();
                    if (len <= 1.0E-4) {
                        return;
                    }
                    Vec3 dir = d.m_82490_(1.0 / len);
                    Vec3 any = Math.abs(dir.f_82480_) < 0.99 ? new Vec3(0.0, 1.0, 0.0) : new Vec3(1.0, 0.0, 0.0);
                    Vec3 u = dir.m_82537_(any).m_82541_();
                    Vec3 v = dir.m_82537_(u).m_82541_();
                    int steps = Mth.m_14045_((int)((int)(len * 6.0)), (int)6, (int)72);
                    double step = len / (double)steps;
                    int stride = 4;
                    int phase = (this.f_19797_ >> 1) % 4;
                    RandomSource r = this.m_217043_();
                    for (int i = phase; i <= steps; i += 4) {
                        if (r.m_188501_() < 0.7f) continue;
                        double t = (double)i * step / len;
                        double R = 0.05 + 0.2 * t;
                        double ang = r.m_188500_() * (Math.PI * 2);
                        double rad = R * Math.sqrt(r.m_188500_());
                        Vec3 off = u.m_82490_(Math.cos(ang) * rad).m_82549_(v.m_82490_(Math.sin(ang) * rad));
                        Vec3 p = from.m_82549_(dir.m_82490_((double)i * step)).m_82549_(off);
                        double vx = dir.f_82479_ * 0.02 + off.f_82479_ * 0.1;
                        double vy = dir.f_82480_ * 0.02 + off.f_82480_ * 0.1;
                        double vz = dir.f_82481_ * 0.02 + off.f_82481_ * 0.1;
                        server.m_8767_((ParticleOptions)((SimpleParticleType)AnnoyingVillagersModParticleTypes.LIGHT.get()), p.f_82479_, p.f_82480_, p.f_82481_, 1, vx, vy, vz, 0.0);
                    }
                }
            }
        }
    }

    private static Vec3 getArmPosition(Entity entity, Vec3f translation, Joint joint, float handToTip, double yOffset) {
        LivingEntityPatch entitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, LivingEntityPatch.class);
        if (entitypatch == null) {
            return null;
        }
        float interpolation = 0.0f;
        OpenMatrix4f m = entitypatch.getArmature().getBindedTransformFor(entitypatch.getAnimator().getPose(interpolation), joint);
        if (translation != null) {
            OpenMatrix4f tLocal = new OpenMatrix4f().translate(translation);
            OpenMatrix4f.mul((OpenMatrix4f)m, (OpenMatrix4f)tLocal, (OpenMatrix4f)m);
        }
        if (handToTip != 0.0f) {
            OpenMatrix4f tipOffset = new OpenMatrix4f().translate(new Vec3f(0.0f, 0.0f, -handToTip));
            OpenMatrix4f.mul((OpenMatrix4f)m, (OpenMatrix4f)tipOffset, (OpenMatrix4f)m);
        }
        float yawRad = (float)(-Math.toRadians(((LivingEntity)entitypatch.getOriginal()).f_20884_ + 180.0f));
        OpenMatrix4f worldYaw = new OpenMatrix4f().rotate(yawRad, new Vec3f(0.0f, 1.0f, 0.0f));
        OpenMatrix4f.mul((OpenMatrix4f)worldYaw, (OpenMatrix4f)m, (OpenMatrix4f)m);
        LivingEntity base = (LivingEntity)entitypatch.getOriginal();
        return new Vec3((double)m.m30 + base.m_20185_(), (double)m.m31 + (base.m_20186_() + (double)entity.m_20206_() / 1.8 - 1.0) + yOffset, (double)m.m32 + base.m_20189_());
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 40.0);
        builder = builder.m_22268_(Attributes.f_22284_, 25.0);
        builder = builder.m_22268_(Attributes.f_22281_, 10.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        return builder;
    }
}

