/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.annoyingvillagers.config.AnnoyingVillagersConfig;
import com.pla.annoyingvillagers.entity.JevEntity;
import com.pla.annoyingvillagers.entity.PlayerMobDeadEntity;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModEntities;
import com.pla.annoyingvillagers.procedures.PlayerNpcOnHurtProcedure;
import com.pla.annoyingvillagers.util.CommonGoals;
import com.pla.annoyingvillagers.util.DelayedTask;
import com.pla.annoyingvillagers.util.EquipmentDataLoader;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import se.gory_moon.player_mobs.entity.PlayerMobEntity;

public class PlayerNpcEntity
extends PlayerMobEntity {
    private final SimpleContainer inventory = new SimpleContainer(27);
    private int gapCooldown;
    private int enderPearlCooldown;

    public int getGapCooldown() {
        return this.gapCooldown;
    }

    public int getEnderPearlCooldown() {
        return this.enderPearlCooldown;
    }

    public void setGapCooldown() {
        this.gapCooldown = this.f_19796_.m_216339_(60, 200);
    }

    public void setEnderPearlCooldown() {
        this.enderPearlCooldown = this.f_19796_.m_216339_(60, 200);
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public PlayerNpcEntity(PlayMessages.SpawnEntity spawnentity, Level level) {
        this((EntityType<? extends PlayerNpcEntity>)((EntityType)AnnoyingVillagersModEntities.PLAYER_NPC.get()), level);
    }

    public PlayerNpcEntity(EntityType<? extends PlayerNpcEntity> entitytype, Level level) {
        super(entitytype, level);
        this.m_274367_(2.6f);
        this.f_21364_ = 50;
        this.m_21557_(false);
        this.m_20340_(true);
        this.m_21530_();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.m_7927_());
        tag.m_128405_("GapCooldown", this.gapCooldown);
        tag.m_128405_("EnderPearlCooldown", this.enderPearlCooldown);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Inventory", 10)) {
            this.inventory.m_7797_(tag.m_128437_("Inventory", 10));
        }
        this.gapCooldown = tag.m_128451_("GapCooldown");
        this.enderPearlCooldown = tag.m_128451_("EnderPearlCooldown");
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
        super.m_7472_(source, looting, recentlyHit);
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            this.m_19983_(stack);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void hostileHunterPlayerMob() {
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, PlayerMobEntity.class, true));
        CommonGoals.attackAllMonstersGoals(this);
        CommonGoals.attackAllNpcGoals((Mob)this);
    }

    private void villagerHunterPlayerMob() {
        CommonGoals.runAwayFromHerobrineGoals((PathfinderMob)this, 20.0f);
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, PlayerMobEntity.class, 12.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 12.0f, 1.2, 1.8));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, JevEntity.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        CommonGoals.attackAllVillagerArmyGoal((Mob)this);
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
    }

    private void monsterHunterPlayerMob() {
        CommonGoals.attackAllMonstersGoals(this);
        CommonGoals.runAwayFromVillagerArmyGoals(this);
    }

    private void playerHunterPlayerMob() {
        CommonGoals.runAwayFromHerobrineGoals((PathfinderMob)this, 20.0f);
        CommonGoals.runAwayFromVillagerArmyGoals(this);
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, PlayerNpcEntity.class, true));
        CommonGoals.attackAllNpcGoals((Mob)this);
    }

    private void animalHunterPlayerMob() {
        CommonGoals.runAwayFromHerobrineGoals((PathfinderMob)this, 20.0f);
        CommonGoals.runAwayFromVillagerArmyGoals(this);
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, true));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, PlayerNpcEntity.class, 12.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 12.0f, 1.2, 1.8));
    }

    protected void m_8099_() {
        String role;
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        CompoundTag data = this.getPersistentData();
        if (!data.m_128441_("behavior")) {
            List<String> roles = List.of("monster_hunter", "player_hunter", "hostile_hunt", "passive_hunt", "animal_hunter");
            role = roles.get(this.m_217043_().m_188503_(roles.size()));
            data.m_128359_("behavior", role);
        } else {
            role = data.m_128461_("behavior");
        }
        switch (role) {
            case "hostile_hunter": {
                this.hostileHunterPlayerMob();
                break;
            }
            case "village_hunter": {
                this.villagerHunterPlayerMob();
                break;
            }
            case "monster_hunter": {
                this.monsterHunterPlayerMob();
                break;
            }
            case "player_hunter": {
                this.playerHunterPlayerMob();
                break;
            }
            case "animal_hunter": {
                this.animalHunterPlayerMob();
                break;
            }
            default: {
                Random random = new Random();
                if ((double)random.nextFloat() < 0.2) {
                    data.m_128359_("behavior", "hostile_hunter");
                    this.hostileHunterPlayerMob();
                    break;
                }
                if ((double)random.nextFloat() < 0.4) {
                    data.m_128359_("behavior", "village_hunter");
                    this.villagerHunterPlayerMob();
                    break;
                }
                if ((double)random.nextFloat() < 0.6) {
                    data.m_128359_("behavior", "monster_hunter");
                    this.monsterHunterPlayerMob();
                    break;
                }
                if ((double)random.nextFloat() < 0.8) {
                    data.m_128359_("behavior", "player_hunter");
                    this.playerHunterPlayerMob();
                    break;
                }
                data.m_128359_("behavior", "animal_hunter");
                this.animalHunterPlayerMob();
            }
        }
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double d0) {
        return false;
    }

    public double m_6049_() {
        return -0.35;
    }

    public SoundEvent m_7975_(DamageSource damagesource) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean m_6469_(DamageSource damagesource, float f) {
        PlayerNpcOnHurtProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this, damagesource.m_7639_(), f);
        return super.m_6469_(damagesource, f);
    }

    public void m_6667_(DamageSource damagesource) {
        super.m_6667_(damagesource);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel levelaccessor = (ServerLevel)level;
            if (this.getPersistentData().m_128471_("die_by_possess")) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            } else if (((Boolean)AnnoyingVillagersConfig.PHYSIC_MOD_COMPAT.get()).booleanValue()) {
                final PlayerMobDeadEntity corpse = new PlayerMobDeadEntity((EntityType<? extends PlayerMobDeadEntity>)((EntityType)AnnoyingVillagersModEntities.PLAYER_MOB_DEAD.get()), (Level)levelaccessor);
                corpse.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
                corpse.setUsername(this.getUsername());
                corpse.setProfile(this.getProfile());
                corpse.m_6842_(true);
                corpse.m_6518_((ServerLevelAccessor)levelaccessor, levelaccessor.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                levelaccessor.m_7967_((Entity)corpse);
                this.m_142687_(Entity.RemovalReason.KILLED);
                new DelayedTask(3){

                    @Override
                    public void run() {
                        try {
                            corpse.m_20194_().m_129892_().m_82094_().execute("kill @s", (Object)corpse.m_20203_().m_81324_().m_81325_(4));
                        }
                        catch (CommandSyntaxException commandSyntaxException) {
                            // empty catch block
                        }
                    }
                };
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.f_19797_ % 20 == 0) {
            if (!this.m_6084_() || this.m_213877_() || this.m_9236_() == null) {
                return;
            }
            List items = this.m_9236_().m_45976_(ItemEntity.class, this.m_20191_().m_82400_(2.0));
            for (ItemEntity item : items) {
                if (item.m_32063_() || item.m_213877_()) continue;
                ItemEntity itemEntity = item;
                if (!this.m_6084_() || this.m_213877_() || this.m_9236_() == null) {
                    return;
                }
                ItemStack stack = itemEntity.m_32055_();
                ItemStack remaining = stack.m_41777_();
                for (int i = 0; i < this.inventory.m_6643_() && !remaining.m_41619_(); ++i) {
                    ItemStack slotStack = this.inventory.m_8020_(i);
                    if (slotStack.m_41619_()) {
                        this.inventory.m_6836_(i, remaining);
                        remaining = ItemStack.f_41583_;
                        break;
                    }
                    if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)remaining) || slotStack.m_41613_() >= slotStack.m_41741_()) continue;
                    int transferable = Math.min(remaining.m_41613_(), slotStack.m_41741_() - slotStack.m_41613_());
                    slotStack.m_41769_(transferable);
                    remaining.m_41774_(transferable);
                }
                if (remaining.m_41619_()) {
                    itemEntity.m_20334_((this.m_20185_() - itemEntity.m_20185_()) * 0.25, (this.m_20186_() + 1.0 - itemEntity.m_20186_()) * 0.25, (this.m_20189_() - itemEntity.m_20189_()) * 0.25);
                    itemEntity.m_32010_(0);
                    PlayerNpcEntity entity = this;
                    new DelayedTask(5, (Entity)entity, itemEntity){
                        final /* synthetic */ Entity val$entity;
                        final /* synthetic */ ItemEntity val$itemEntity;
                        {
                            this.val$entity = entity;
                            this.val$itemEntity = itemEntity;
                            super(waitTicks);
                        }

                        @Override
                        public void run() {
                            if (!this.val$entity.m_6084_() || this.val$entity.m_213877_() || this.val$entity.m_9236_() == null) {
                                return;
                            }
                            this.val$itemEntity.m_146870_();
                            this.val$entity.m_9236_().m_5594_(null, this.val$entity.m_20183_(), SoundEvents.f_12019_, SoundSource.HOSTILE, 0.2f, 1.0f);
                        }
                    };
                    continue;
                }
                if (this.m_21223_() <= 0.0f) {
                    return;
                }
                itemEntity.m_32045_(remaining);
            }
        }
        if (!this.m_9236_().f_46443_) {
            if (this.gapCooldown > 0) {
                --this.gapCooldown;
            }
            if (this.enderPearlCooldown > 0) {
                --this.enderPearlCooldown;
            }
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverlevelaccessor, DifficultyInstance difficultyinstance, MobSpawnType mobspawntype, @Nullable SpawnGroupData spawngroupdata, @Nullable CompoundTag compoundtag) {
        SpawnGroupData returnSpawnGroupData = super.m_6518_(serverlevelaccessor, difficultyinstance, mobspawntype, spawngroupdata, compoundtag);
        ServerLevel serverLevel = serverlevelaccessor.m_6018_();
        if ((mobspawntype == MobSpawnType.CHUNK_GENERATION || mobspawntype == MobSpawnType.NATURAL) && serverLevel.m_46461_() && Math.random() <= 0.8) {
            BlockPos blockPos = this.m_20097_();
            int surfaceY = serverLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, blockPos).m_123342_();
            BlockPos spawnPos = new BlockPos(blockPos.m_123341_(), surfaceY, blockPos.m_123343_());
            if (serverLevel.m_6425_(spawnPos).m_76178_()) {
                this.m_20035_(spawnPos, this.m_146908_(), this.m_146909_());
            }
        }
        List<String> commands = EquipmentDataLoader.getEquipCommands(0.85f, (Entity)this);
        for (String cmd : commands) {
            try {
                this.m_20194_().m_129892_().m_82094_().execute(cmd, (Object)this.m_20203_().m_81324_().m_81325_(4));
            }
            catch (CommandSyntaxException commandSyntaxException) {}
        }
        try {
            this.m_20194_().m_129892_().m_82094_().execute("tellraw @a {\"text\":\"" + this.m_5446_().getString() + " has joined the game\",\"color\":\"yellow\"}", (Object)this.m_20203_().m_81324_().m_81325_(4));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        try {
            this.m_20194_().m_129892_().m_82094_().execute("data merge entity @s {CanPickUpLoot: 1b}", (Object)this.m_20203_().m_81324_().m_81325_(4));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (Math.random() <= 0.05) {
            try {
                this.m_20194_().m_129892_().m_82094_().execute("team add player", (Object)this.m_20203_().m_81324_().m_81325_(4));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            try {
                this.m_20194_().m_129892_().m_82094_().execute("team join player @s", (Object)this.m_20203_().m_81324_().m_81325_(4));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        if (Math.random() <= 0.15) {
            this.getPersistentData().m_128347_("npc_level", 3.0);
        }
        return returnSpawnGroupData;
    }

    public void m_5993_(Entity entity, int i, DamageSource damagesource) {
        super.m_5993_(entity, i, damagesource);
    }

    public void m_6075_() {
        super.m_6075_();
    }

    public static boolean canSpawn(EntityType<PlayerNpcEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        ServerLevel serverLevel = level.m_6018_();
        if (serverLevel.m_46462_()) {
            return false;
        }
        return Monster.m_219019_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.26);
        builder = builder.m_22268_(Attributes.f_22276_, 30.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        return builder;
    }
}

