/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.annoyingvillagers.clazz.HerobrineMob;
import com.pla.annoyingvillagers.entity.DragonBeamEntity;
import com.pla.annoyingvillagers.entity.EliteHerobrineKnockedEntity;
import com.pla.annoyingvillagers.entity.HerobrineGregEntity;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModEntities;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModItems;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModMobEffects;
import com.pla.annoyingvillagers.procedures.HerobrineWeaponEffectProcedure;
import com.pla.annoyingvillagers.util.DelayedTask;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ReaperHerobrineEntity
extends HerobrineMob {
    private EnderDragon enderDragon;
    private UUID enderDragonUUID;
    private boolean spawnEnderDragon = false;
    private int breathCooldown = 0;
    private int nextStack = 3;
    private int dragonSummonCooldown = 3600;

    public ReaperHerobrineEntity(PlayMessages.SpawnEntity spawnentity, Level level) {
        this((EntityType<ReaperHerobrineEntity>)((EntityType)AnnoyingVillagersModEntities.REAPER_HEROBRINE.get()), level);
    }

    public ReaperHerobrineEntity(EntityType<ReaperHerobrineEntity> entitytype, Level level) {
        super(entitytype, level);
        this.m_274367_(2.9f);
        this.f_21364_ = 300;
        this.m_21557_(false);
        this.m_6593_(this.m_5446_());
        this.m_20340_(true);
        this.m_21530_();
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)AnnoyingVillagersModItems.ENDER_SLAYER_SCYTHE.get()));
        this.setChatName(this.m_5446_().getString());
    }

    @Override
    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getCooldownTicks() {
        return this.getPersistentData().m_128451_("DragonCooldown");
    }

    public void setCooldownTicks(int ticks) {
        this.getPersistentData().m_128405_("DragonCooldown", ticks);
    }

    @Override
    @NotNull
    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    @Override
    public boolean m_6785_(double d0) {
        return false;
    }

    @Override
    public double m_6049_() {
        return -0.35;
    }

    @Override
    @NotNull
    public SoundEvent m_7975_(DamageSource damagesource) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    @Override
    @NotNull
    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        if (this.enderDragonUUID != null) {
            tag.m_128362_("EnderDragonUUID", this.enderDragonUUID);
        }
        tag.m_128379_("SpawnEnderDragon", this.spawnEnderDragon);
        tag.m_128405_("NextStack", this.nextStack);
        tag.m_128405_("DragonSummonCooldown", this.dragonSummonCooldown);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("EnderDragonUUID")) {
            this.enderDragonUUID = tag.m_128342_("EnderDragonUUID");
        }
        this.spawnEnderDragon = tag.m_128471_("SpawnEnderDragon");
        this.nextStack = tag.m_128441_("NextStack") ? tag.m_128451_("NextStack") : this.nextStack;
        this.dragonSummonCooldown = tag.m_128441_("DragonSummonCooldown") ? tag.m_128451_("DragonSummonCooldown") : this.dragonSummonCooldown;
    }

    private void spawnEnderDragon() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel levelaccessor;
            ServerLevel serverlevel = levelaccessor = (ServerLevel)level;
            EnderDragon dragon = new EnderDragon(EntityType.f_20565_, (Level)serverlevel);
            dragon.m_7678_(this.m_20185_(), this.m_20186_() + 20.0, this.m_20189_(), new Random().nextFloat() * 360.0f, 0.0f);
            dragon.m_6518_((ServerLevelAccessor)serverlevel, serverlevel.m_6436_(dragon.m_20183_()), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
            dragon.m_287266_(BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()));
            dragon.m_31157_().m_31416_(EnderDragonPhase.f_31387_);
            dragon.m_20049_("av_dragon");
            dragon.getPersistentData().m_128362_("herobrine_uuid", this.m_20148_());
            serverlevel.m_7967_((Entity)dragon);
            try {
                dragon.m_20194_().m_129892_().m_82094_().execute("team join herobrine @s", (Object)dragon.m_20203_().m_81324_().m_81325_(4));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            this.enderDragonUUID = dragon.m_20148_();
            this.enderDragon = dragon;
            if (this.m_9236_().m_7654_() != null) {
                this.m_9236_().m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)("<" + this.getChatName() + "> " + Component.m_237115_((String)"subtitles.herobrine_summon").getString())), false);
            }
        }
    }

    public boolean m_7327_(Entity pEntity) {
        if (!pEntity.m_9236_().m_5776_() && !this.getPersistentData().m_128471_("SecondForm")) {
            this.getPersistentData().m_128405_("HitCount", (this.getPersistentData().m_128441_("HitCount") ? this.getPersistentData().m_128451_("HitCount") : 0) + 1);
        }
        return super.m_7327_(pEntity);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        boolean playSound = false;
        if (!this.m_9236_().f_46443_) {
            if (!this.spawnEnderDragon) {
                this.spawnEnderDragon = true;
                this.spawnEnderDragon();
            }
            if (this.enderDragon == null && this.enderDragonUUID == null) {
                if (this.dragonSummonCooldown <= 0) {
                    this.spawnEnderDragon = false;
                } else {
                    --this.dragonSummonCooldown;
                }
            }
            if (this.enderDragon == null && this.enderDragonUUID != null) {
                EnderDragon dragon;
                Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(this.enderDragonUUID);
                this.enderDragon = entity instanceof EnderDragon ? (dragon = (EnderDragon)entity) : null;
            }
            if (this.enderDragon != null && this.enderDragon.m_21223_() <= 50.0f) {
                this.enderDragon.m_146870_();
                this.enderDragon = null;
                this.enderDragonUUID = null;
                if (this.m_9236_().m_7654_() != null) {
                    this.m_9236_().m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)("<" + this.getChatName() + ">  " + Component.m_237115_((String)"subtitles.reaper_herobrine_return_dragon").getString())), false);
                }
                this.dragonSummonCooldown = 3600;
            }
            if (this.enderDragon != null && this.enderDragon.m_6084_()) {
                this.enderDragon.m_287266_(BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()));
                this.enderDragon.m_31157_().m_31416_(EnderDragonPhase.f_31387_);
                this.enderDragon.m_287231_(null);
                LivingEntity target = this.m_5448_();
                if (target != null && target.m_6084_() && this.getPersistentData().m_128471_("SecondForm") && this.breathCooldown <= 0) {
                    this.shootThunderBreathAtTarget(target);
                    this.breathCooldown = 60 + this.m_217043_().m_188503_(20);
                }
            }
            if (this.breathCooldown > 0) {
                --this.breathCooldown;
            }
            if (this.getPersistentData().m_128471_("SecondForm")) {
                HerobrineWeaponEffectProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
                int cooldown = this.getCooldownTicks();
                if (cooldown > 0) {
                    this.setCooldownTicks(cooldown - 1);
                } else {
                    this.getPersistentData().m_128473_("SecondForm");
                }
            } else if (!this.getPersistentData().m_128471_("SecondForm") && this.getPersistentData().m_128451_("HitCount") >= this.nextStack) {
                this.getPersistentData().m_128379_("SecondForm", true);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 2));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 200, 2));
                this.setCooldownTicks(200);
                this.getPersistentData().m_128473_("HitCount");
                this.nextStack = new Random().nextInt(3, 6);
                playSound = true;
            }
        }
        if (playSound) {
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_5594_(null, new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("annoyingvillagers:second_form_release")), SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("annoyingvillagers:second_form_release")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            }
        }
    }

    private void shootThunderBreathAtTarget(LivingEntity target) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        EnderDragonPart head = this.enderDragon.f_31080_;
        Vec3 headPos = new Vec3(head.m_20185_(), head.m_20186_(), head.m_20189_());
        DragonBeamEntity beam = new DragonBeamEntity((EntityType<? extends DragonBeamEntity>)((EntityType)AnnoyingVillagersModEntities.DRAGON_BEAM.get()), (Level)serverLevel, this.enderDragon, target, headPos.f_82479_, headPos.f_82480_, headPos.f_82481_, 100, 2);
        serverLevel.m_7967_((Entity)beam);
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource damagesource, float f) {
        if (!this.getPersistentData().m_128471_("kick_x")) {
            ReaperHerobrineEntity livingentity;
            this.m_6858_(true);
            final ReaperHerobrineEntity entity = this;
            new DelayedTask(10){

                @Override
                public void run() {
                    entity.m_6858_(false);
                }
            };
            if (Math.random() <= 0.5 && this instanceof LivingEntity && !(livingentity = this).m_9236_().m_5776_()) {
                livingentity.m_7292_(new MobEffectInstance((MobEffect)AnnoyingVillagersModMobEffects.BLOCK.get(), 1, 1, false, false));
            }
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        if (damagesource.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        return super.m_6469_(damagesource, f);
    }

    @Override
    public void m_142687_(Entity.RemovalReason pReason) {
        if (this.enderDragon != null) {
            this.enderDragon.m_146870_();
        }
        super.m_142687_(pReason);
    }

    public void m_6667_(DamageSource damagesource) {
        super.m_6667_(damagesource);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel levelaccessor;
            ServerLevel serverlevel = levelaccessor = (ServerLevel)level;
            EliteHerobrineKnockedEntity eliteHerobrineKnockedEntity = new EliteHerobrineKnockedEntity((EntityType<EliteHerobrineKnockedEntity>)((EntityType)AnnoyingVillagersModEntities.ELITE_HEROBRINE_KNOCKED.get()), (Level)serverlevel);
            eliteHerobrineKnockedEntity.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), levelaccessor.m_213780_().m_188501_() * 360.0f, 0.0f);
            eliteHerobrineKnockedEntity.getPersistentData().m_128359_("FromElite", "EnderSlayerScythe");
            eliteHerobrineKnockedEntity.m_6518_((ServerLevelAccessor)serverlevel, levelaccessor.m_6436_(eliteHerobrineKnockedEntity.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            this.m_142687_(Entity.RemovalReason.KILLED);
            levelaccessor.m_7967_((Entity)eliteHerobrineKnockedEntity);
            if (this.getGregUUID() != null && (entity = levelaccessor.m_8791_(this.getGregUUID())) instanceof HerobrineGregEntity) {
                HerobrineGregEntity herobrineGregEntity = (HerobrineGregEntity)entity;
                if (entity.m_6084_()) {
                    herobrineGregEntity.requestProtect(eliteHerobrineKnockedEntity.m_20148_(), eliteHerobrineKnockedEntity);
                }
            }
        }
    }

    public void m_6075_() {
        super.m_6075_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 230.0);
        builder = builder.m_22268_(Attributes.f_22284_, 20.0);
        builder = builder.m_22268_(Attributes.f_22281_, 5.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        return builder;
    }
}

