/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.entity;

import com.pla.annoyingvillagers.clazz.HerobrineMob;
import com.pla.annoyingvillagers.entity.BlockProjectileEntity;
import com.pla.annoyingvillagers.entity.InfectedPlayerMobEntity;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModBlocks;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModEntities;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModItems;
import com.pla.annoyingvillagers.procedures.DarkHerobrineOnHurtProcedure;
import com.pla.annoyingvillagers.procedures.DarkHerobrineOnPlayerTouchProcedure;
import com.pla.annoyingvillagers.util.DelayedTask;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import se.gory_moon.player_mobs.utils.NameManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class ShadowHerobrineEntity
extends HerobrineMob {
    private boolean wasLanding = false;
    private boolean wasAiming = false;
    public BlockProjectileEntity darkObUp;
    public UUID darkObUpUUID;
    public BlockProjectileEntity darkObLeft;
    public UUID darkObLeftUUID;
    public BlockProjectileEntity darkObRight;
    public UUID darkObRightUUID;

    public ShadowHerobrineEntity(PlayMessages.SpawnEntity spawnentity, Level level) {
        this((EntityType<ShadowHerobrineEntity>)((EntityType)AnnoyingVillagersModEntities.SHADOW_HEROBRINE.get()), level);
    }

    public ShadowHerobrineEntity(EntityType<ShadowHerobrineEntity> entitytype, Level level) {
        super(entitytype, level);
        this.m_274367_(2.8f);
        this.f_21364_ = 60;
        this.m_21557_(false);
        this.m_6593_(this.m_5446_());
        this.m_20340_(true);
        this.m_21530_();
        this.setChatName(this.m_5446_().getString());
    }

    @Override
    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    public boolean m_6785_(double d0) {
        return false;
    }

    @Override
    public double m_6049_() {
        return -0.35;
    }

    @Override
    @NotNull
    public SoundEvent m_7975_(DamageSource damagesource) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    @Override
    @NotNull
    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource damagesource, float f) {
        if (!this.isHealing()) {
            DarkHerobrineOnHurtProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        return super.m_6469_(damagesource, f);
    }

    public void m_6667_(DamageSource damagesource) {
        Level level;
        super.m_6667_(damagesource);
        if (this.darkObUp != null) {
            this.darkObUp.m_146870_();
        }
        if (this.darkObRight != null) {
            this.darkObRight.m_146870_();
        }
        if (this.darkObLeft != null) {
            this.darkObLeft.m_146870_();
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            InfectedPlayerMobEntity corpse = new InfectedPlayerMobEntity((EntityType<? extends InfectedPlayerMobEntity>)((EntityType)AnnoyingVillagersModEntities.INFECTED_PLAYER_MOB.get()), (Level)serverLevel);
            corpse.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            String killedName = this.getPersistentData().m_128461_("killed_name");
            corpse.getPersistentData().m_128359_("possessed_by", "shadow_herobrine");
            if (killedName.isEmpty()) {
                killedName = String.valueOf(NameManager.INSTANCE.getRandomName());
            }
            corpse.setUsername(killedName);
            corpse.m_6593_((Component)Component.m_237113_((String)killedName));
            corpse.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            this.m_6842_(true);
            this.m_142687_(Entity.RemovalReason.KILLED);
            serverLevel.m_7967_((Entity)corpse);
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        if (this.getPersistentData().m_128441_("Shooting")) {
            tag.m_128405_("Shooting", this.getPersistentData().m_128451_("Shooting"));
        }
        if (this.darkObUpUUID != null) {
            tag.m_128362_("DarkObUpUUID", this.darkObUpUUID);
        }
        if (this.darkObLeftUUID != null) {
            tag.m_128362_("DarkObLeftUUID", this.darkObLeftUUID);
        }
        if (this.darkObRightUUID != null) {
            tag.m_128362_("DarkObRightUUID", this.darkObRightUUID);
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Shooting")) {
            this.getPersistentData().m_128405_("Shooting", tag.m_128451_("Shooting"));
        }
        if (tag.m_128403_("DarkObUpUUID")) {
            this.darkObUpUUID = tag.m_128342_("DarkObUpUUID");
        }
        if (tag.m_128403_("DarkObLeftUUID")) {
            this.darkObLeftUUID = tag.m_128342_("DarkObLeftUUID");
        }
        if (tag.m_128403_("DarkObRightUUID")) {
            this.darkObRightUUID = tag.m_128342_("DarkObRightUUID");
        }
    }

    public void m_6075_() {
        super.m_6075_();
    }

    public void m_6123_(Player player) {
        super.m_6123_(player);
        if (!this.isHealing()) {
            DarkHerobrineOnPlayerTouchProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        }
    }

    private Vec3 getUpBlockPos() {
        double upY = 2.0;
        Vec3 eye = this.m_20299_(1.0f);
        return eye.m_82520_(0.0, 2.0, 0.0);
    }

    private Vec3 getRightBlockPos() {
        double lateral = 2.0;
        double sideY = 0.0;
        Vec3 eye = this.m_20299_(1.0f);
        Vec3 look = this.m_20252_(1.0f);
        Vec3 horiz = new Vec3(look.f_82479_, 0.0, look.f_82481_);
        if (horiz.m_82556_() < 1.0E-6) {
            float yaw = this.m_146908_() * ((float)Math.PI / 180);
            horiz = new Vec3((double)(-Mth.m_14031_((float)yaw)), 0.0, (double)Mth.m_14089_((float)yaw));
        }
        Vec3 upAxis = new Vec3(0.0, 1.0, 0.0);
        Vec3 rightAxis = horiz.m_82537_(upAxis).m_82541_();
        return eye.m_82549_(rightAxis.m_82490_(2.0)).m_82520_(0.0, 0.0, 0.0);
    }

    private Vec3 getLeftBlockPos() {
        double lateral = 2.0;
        double sideY = 0.0;
        Vec3 eye = this.m_20299_(1.0f);
        Vec3 look = this.m_20252_(1.0f);
        Vec3 horiz = new Vec3(look.f_82479_, 0.0, look.f_82481_);
        if (horiz.m_82556_() < 1.0E-6) {
            float yaw = this.m_146908_() * ((float)Math.PI / 180);
            horiz = new Vec3((double)(-Mth.m_14031_((float)yaw)), 0.0, (double)Mth.m_14089_((float)yaw));
        }
        Vec3 upAxis = new Vec3(0.0, 1.0, 0.0);
        Vec3 rightAxis = horiz.m_82537_(upAxis).m_82541_();
        Vec3 leftAxis = rightAxis.m_82490_(-1.0);
        return eye.m_82549_(leftAxis.m_82490_(2.0)).m_82520_(0.0, 0.0, 0.0);
    }

    public void spawnDarkObEntities() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockState block = ((Block)AnnoyingVillagersModBlocks.DARKOB.get()).m_49966_();
            if (this.darkObUp == null) {
                BlockProjectileEntity darkObbyUp = new BlockProjectileEntity(this.m_9236_(), (LivingEntity)this, block);
                darkObbyUp.m_20242_(true);
                darkObbyUp.setNotReadyForShoot(true);
                darkObbyUp.m_20219_(this.getUpBlockPos());
                serverLevel.m_7967_((Entity)darkObbyUp);
                this.darkObUpUUID = darkObbyUp.m_20148_();
                this.darkObUp = darkObbyUp;
            }
            if (this.darkObRight == null) {
                BlockProjectileEntity darkObbyRight = new BlockProjectileEntity(this.m_9236_(), (LivingEntity)this, block);
                darkObbyRight.m_20242_(true);
                darkObbyRight.setNotReadyForShoot(true);
                darkObbyRight.m_20219_(this.getRightBlockPos());
                serverLevel.m_7967_((Entity)darkObbyRight);
                this.darkObRightUUID = darkObbyRight.m_20148_();
                this.darkObRight = darkObbyRight;
            }
            if (this.darkObLeft == null) {
                BlockProjectileEntity darkObbyLeft = new BlockProjectileEntity(this.m_9236_(), (LivingEntity)this, block);
                darkObbyLeft.m_20242_(true);
                darkObbyLeft.setNotReadyForShoot(true);
                darkObbyLeft.m_20219_(this.getLeftBlockPos());
                serverLevel.m_7967_((Entity)darkObbyLeft);
                this.darkObLeftUUID = darkObbyLeft.m_20148_();
                this.darkObLeft = darkObbyLeft;
            }
        }
    }

    private static void shootChain(Entity shooter, BlockState block, float velocity, int length) {
        Level level = shooter.m_9236_();
        if (level.f_46443_) {
            return;
        }
        double eyeY = shooter.m_20188_();
        Vec3 look = shooter.m_20154_().m_82541_();
        RandomSource rand = level.m_213780_();
        for (int i = 0; i < length; ++i) {
            BlockProjectileEntity proj = new BlockProjectileEntity(level, shooter instanceof LivingEntity ? (LivingEntity)shooter : null, block);
            Vec3 forward = look.m_82490_((double)i * 1.0);
            double sideX = (rand.m_188500_() - 0.5) * 2.0;
            double sideY = (rand.m_188500_() - 0.5) * 2.0;
            double sideZ = (rand.m_188500_() - 0.5) * 2.0;
            proj.m_6034_(shooter.m_20185_() + forward.f_82479_ + sideX, eyeY + forward.f_82480_ + sideY, shooter.m_20189_() + forward.f_82481_ + sideZ);
            proj.m_20256_(look.m_82490_((double)velocity));
            level.m_7967_((Entity)proj);
        }
    }

    private static String currentEfAnimIdOrNull(LivingEntity self) {
        try {
            LivingEntityPatch patch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)self, LivingEntityPatch.class);
            if (patch == null) {
                return null;
            }
            AnimationPlayer player = patch.getAnimator().getPlayerFor((DynamicAnimation)null);
            if (player == null) {
                return null;
            }
            DynamicAnimation anim = player.getAnimation();
            if (anim == null) {
                return null;
            }
            try {
                Method m = anim.getClass().getMethod("getLocation", new Class[0]);
                ResourceLocation rl = (ResourceLocation)m.invoke((Object)anim, new Object[0]);
                return rl != null ? rl.m_135815_().toLowerCase(Locale.ROOT) : null;
            }
            catch (Exception ignored) {
                return anim.toString().toLowerCase(Locale.ROOT);
            }
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static boolean isLandAnimId(String id) {
        if (id == null) {
            return false;
        }
        return id.contains("biped/living/landing") || id.endsWith("/landing") || id.contains("landing");
    }

    private static boolean isAiming(String id) {
        if (id == null) {
            return false;
        }
        return id.contains("biped/combat/fist_dash") || id.endsWith("/fist_dash") || id.contains("fist_dash");
    }

    private void shootOne(BlockProjectileEntity ob, Vec3 to, double speed, String position, ShadowHerobrineEntity shadowHerobrineEntity) {
        if (ob == null || !ob.m_6084_()) {
            return;
        }
        Vec3 dir = to.m_82546_(ob.m_20182_());
        if (dir.m_82556_() < 1.0E-6) {
            dir = this.m_20154_();
        }
        ob.m_20242_(false);
        Vec3 vel = dir.m_82541_().m_82490_(speed);
        ob.m_20256_(vel);
        ob.setNotReadyForShoot(false);
        if (position.equals("up")) {
            shadowHerobrineEntity.darkObUpUUID = null;
            shadowHerobrineEntity.darkObUp = null;
        } else if (position.equals("left")) {
            shadowHerobrineEntity.darkObLeftUUID = null;
            shadowHerobrineEntity.darkObLeft = null;
        } else if (position.equals("right")) {
            shadowHerobrineEntity.darkObRightUUID = null;
            shadowHerobrineEntity.darkObRight = null;
        }
    }

    public void shootDarkObsAtTarget(double speed, ShadowHerobrineEntity shadowHerobrineEntity) {
        if (shadowHerobrineEntity.m_9236_().f_46443_) {
            return;
        }
        LivingEntity target = shadowHerobrineEntity.m_5448_();
        Vec3 to = target != null && target.m_6084_() ? target.m_20299_(1.0f) : shadowHerobrineEntity.m_146892_().m_82549_(shadowHerobrineEntity.m_20154_().m_82490_(16.0));
        if (shadowHerobrineEntity.darkObUp != null) {
            this.shootOne(shadowHerobrineEntity.darkObUp, to, speed, "up", shadowHerobrineEntity);
        }
        if (shadowHerobrineEntity.darkObLeft != null) {
            this.shootOne(shadowHerobrineEntity.darkObLeft, to, speed, "left", shadowHerobrineEntity);
        }
        if (shadowHerobrineEntity.darkObRight != null) {
            this.shootOne(shadowHerobrineEntity.darkObRight, to, speed, "right", shadowHerobrineEntity);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            boolean aimingNow;
            BlockProjectileEntity blockProjectileEntity;
            Entity entity;
            String animId = ShadowHerobrineEntity.currentEfAnimIdOrNull((LivingEntity)this);
            boolean isLandingNow = ShadowHerobrineEntity.isLandAnimId(animId);
            if (isLandingNow && !this.wasLanding) {
                this.getPersistentData().m_128405_("Shooting", 15);
            }
            this.wasLanding = isLandingNow;
            int shooting = this.getPersistentData().m_128451_("Shooting");
            if (shooting > 0) {
                BlockState block = ((Block)AnnoyingVillagersModBlocks.SHADOW_OBSIDIAN_BLOCK.get()).m_49966_();
                this.m_20256_(Vec3.f_82478_);
                ShadowHerobrineEntity.shootChain((Entity)this, block, 2.5f, 5);
                this.getPersistentData().m_128405_("Shooting", shooting - 1);
            } else if (this.m_21205_().m_41720_().equals(AnnoyingVillagersModItems.HEROBRINE_ENDER_EYE.get())) {
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            }
            if (this.darkObUp == null && this.darkObUpUUID != null) {
                entity = ((ServerLevel)this.m_9236_()).m_8791_(this.darkObUpUUID);
                if (entity instanceof BlockProjectileEntity) {
                    this.darkObUp = blockProjectileEntity = (BlockProjectileEntity)entity;
                } else {
                    this.darkObUpUUID = null;
                }
            }
            if (this.darkObLeft == null && this.darkObLeftUUID != null) {
                entity = ((ServerLevel)this.m_9236_()).m_8791_(this.darkObLeftUUID);
                if (entity instanceof BlockProjectileEntity) {
                    this.darkObLeft = blockProjectileEntity = (BlockProjectileEntity)entity;
                } else {
                    this.darkObLeftUUID = null;
                }
            }
            if (this.darkObRight == null && this.darkObRightUUID != null) {
                entity = ((ServerLevel)this.m_9236_()).m_8791_(this.darkObRightUUID);
                if (entity instanceof BlockProjectileEntity) {
                    this.darkObRight = blockProjectileEntity = (BlockProjectileEntity)entity;
                } else {
                    this.darkObRightUUID = null;
                }
            }
            if (this.darkObUp != null) {
                this.darkObUp.m_20219_(this.getUpBlockPos());
            }
            if (this.darkObRight != null) {
                this.darkObRight.m_20219_(this.getRightBlockPos());
            }
            if (this.darkObLeft != null) {
                this.darkObLeft.m_20219_(this.getLeftBlockPos());
            }
            if ((aimingNow = ShadowHerobrineEntity.isAiming(animId)) && !this.wasAiming) {
                this.spawnDarkObEntities();
                final ShadowHerobrineEntity shadowHerobrineEntity = this;
                new DelayedTask(10){

                    @Override
                    public void run() {
                        if (shadowHerobrineEntity.m_6084_()) {
                            ShadowHerobrineEntity.this.shootDarkObsAtTarget(2.0, shadowHerobrineEntity);
                        }
                    }
                };
            }
            this.wasAiming = aimingNow;
        }
    }

    @Override
    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (this.darkObUp != null) {
            this.darkObUp.m_146870_();
        }
        if (this.darkObLeft != null) {
            this.darkObLeft.m_146870_();
        }
        if (this.darkObRight != null) {
            this.darkObRight.m_146870_();
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 120.0);
        builder = builder.m_22268_(Attributes.f_22284_, 25.0);
        builder = builder.m_22268_(Attributes.f_22281_, 4.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        return builder;
    }
}

