/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.entity;

import com.google.common.collect.Multimap;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModEntities;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModItems;
import com.pla.annoyingvillagers.procedures.HerobrineWeaponEffectProcedure;
import com.pla.annoyingvillagers.util.SnakeBladeHit;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class SnakeBladeEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> CREATOR_ID = SynchedEntityData.m_135353_(SnakeBladeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> FROM_ID = SynchedEntityData.m_135353_(SnakeBladeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TARGET_COUNT = SynchedEntityData.m_135353_(SnakeBladeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CURRENT_TARGET_ID = SynchedEntityData.m_135353_(SnakeBladeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> PROGRESS = SynchedEntityData.m_135353_(SnakeBladeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(SnakeBladeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> RETRACTING = SynchedEntityData.m_135353_(SnakeBladeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_BLADE = SynchedEntityData.m_135353_(SnakeBladeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ENCHANTED = SynchedEntityData.m_135353_(SnakeBladeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private List<Entity> previouslyTouched = new ArrayList<Entity>();
    private boolean hasChained = false;
    public float prevProgress = 0.0f;
    public static final float MAX_EXTEND_TIME = 5.0f;

    public SnakeBladeEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public SnakeBladeEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType)AnnoyingVillagersModEntities.SNAKE_BLADE.get(), world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CREATOR_ID, Optional.empty());
        this.f_19804_.m_135372_(FROM_ID, (Object)-1);
        this.f_19804_.m_135372_(TARGET_COUNT, (Object)0);
        this.f_19804_.m_135372_(CURRENT_TARGET_ID, (Object)-1);
        this.f_19804_.m_135372_(PROGRESS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(3.0f));
        this.f_19804_.m_135372_(RETRACTING, (Object)false);
        this.f_19804_.m_135372_(HAS_BLADE, (Object)true);
        this.f_19804_.m_135372_(ENCHANTED, (Object)false);
    }

    public void setEnchanted(boolean enchanted) {
        this.f_19804_.m_135381_(ENCHANTED, (Object)enchanted);
    }

    public boolean isEnchanted() {
        return (Boolean)this.f_19804_.m_135370_(ENCHANTED);
    }

    private float getBaseDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void m_8119_() {
        float progress;
        HerobrineWeaponEffectProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this);
        this.prevProgress = progress = this.getProgress();
        super.m_8119_();
        Entity creator = this.getCreatorEntity();
        Entity current = this.getToEntity();
        if (!this.isRetracting() && progress < 5.0f) {
            this.setProgress(progress + 1.0f);
        }
        if (this.isRetracting() && progress > 0.0f) {
            this.setProgress(progress - 1.0f);
        }
        if (this.isRetracting() && progress == 0.0f) {
            Entity from = this.getFromEntity();
            if (from instanceof SnakeBladeEntity) {
                SnakeBladeEntity snakeBladeFragment = (SnakeBladeEntity)from;
                snakeBladeFragment.setRetracting(true);
                this.updateLastFragment(snakeBladeFragment);
            } else {
                LivingEntity livingEntity;
                ItemStack held;
                this.updateLastFragment(null);
                if (creator instanceof LivingEntity && (held = (livingEntity = (LivingEntity)creator).m_21205_()).m_150930_((Item)AnnoyingVillagersModItems.DEMONIAC_VOLTAGE_REAVER.get())) {
                    held.m_41749_("SnakeAnimation");
                }
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (creator instanceof LivingEntity && current != null) {
            Entity entity;
            Vec3 target = new Vec3(current.m_20185_(), current.m_20227_((double)0.4f), current.m_20189_());
            Vec3 lerp = target.m_82546_(this.m_20182_());
            this.m_20256_(lerp.m_82490_(0.5));
            if (!this.m_9236_().f_46443_ && progress >= 5.0f && this.f_19797_ % 2 == 0 && (entity = this.getCreatorEntity()) instanceof LivingEntity && current != creator && current.m_6469_(this.m_9236_().m_269111_().m_269104_((Entity)this, (Entity)((LivingEntity)entity)), this.getBaseDamage())) {
                if (!this.m_9236_().m_5776_() && entity.m_20194_() != null) {
                    try {
                        this.m_20194_().m_129892_().m_82094_().execute("execute at @s run particle epicfight:hit_blunt ^ ^1.5 ^0.8 0.1 0.1 0.1 1 1", (Object)this.m_20203_().m_81324_().m_81325_(4));
                    }
                    catch (CommandSyntaxException commandSyntaxException) {
                        // empty catch block
                    }
                }
                if (!this.m_9236_().m_5776_()) {
                    this.m_9236_().m_5594_(null, new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("annoyingvillagers", "obsidian_hit")), SoundSource.BLOCKS, 1.0f, (float)(0.5 + Math.random() * 0.5));
                } else {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("annoyingvillagers", "obsidian_hit")), SoundSource.BLOCKS, 1.0f, (float)(0.5 + Math.random() * 0.5), false);
                }
                if (!current.m_9236_().m_5776_() && current.m_20194_() != null) {
                    try {
                        current.m_20194_().m_129892_().m_82094_().execute("indestructible @s play \"epicfight:biped/combat/hit_long\" 0 10", (Object)current.m_20203_().m_81324_().m_81325_(4));
                    }
                    catch (CommandSyntaxException commandSyntaxException) {
                        // empty catch block
                    }
                }
                if (current instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)current;
                    float strength = 3.0f;
                    double dx = this.m_20185_() - current.m_20185_();
                    double dz = this.m_20189_() - current.m_20189_();
                    livingEntity.m_147240_((double)strength, dx, dz);
                }
                if (new Random().nextBoolean() && !current.m_9236_().m_5776_() && current.m_20194_() != null) {
                    try {
                        current.m_20194_().m_129892_().m_82094_().execute("indestructible @s play \"epicfight:biped/combat/knockdown\" 0 10", (Object)current.m_20203_().m_81324_().m_81325_(4));
                    }
                    catch (CommandSyntaxException livingEntity) {
                        // empty catch block
                    }
                }
            }
        }
        Vec3 vector3d = this.m_20184_();
        if (!this.m_9236_().f_46443_ && !this.hasChained) {
            if (this.getTargetsHit() > 5) {
                this.setRetracting(true);
            } else if (creator instanceof LivingEntity && this.getProgress() >= 5.0f) {
                Entity closestValid = null;
                for (Entity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(12.0))) {
                    if (entity.equals((Object)creator) || this.previouslyTouched.contains(entity) || !this.isValidTarget((LivingEntity)creator, entity) || !this.hasLineOfSight(entity) || closestValid != null && !(this.m_20270_(entity) < this.m_20270_(closestValid))) continue;
                    closestValid = entity;
                }
                if (closestValid != null) {
                    this.createChain(closestValid);
                    this.hasChained = true;
                } else {
                    this.setRetracting(true);
                }
            }
        }
        double d0 = this.m_20185_() + vector3d.f_82479_;
        double d1 = this.m_20186_() + vector3d.f_82480_;
        double d2 = this.m_20189_() + vector3d.f_82481_;
        this.m_20256_(vector3d.m_82490_((double)0.99f));
        this.m_6034_(d0, d1, d2);
    }

    private boolean isValidTarget(LivingEntity creator, Entity entity) {
        if (!creator.m_7307_(entity) && !entity.m_7307_((Entity)creator) && entity instanceof Mob) {
            return true;
        }
        return creator.m_21214_() != null && creator.m_21214_().m_20148_().equals(entity.m_20148_()) || creator.m_21188_() != null && creator.m_21188_().m_20148_().equals(entity.m_20148_());
    }

    private double getDamageForItem(ItemStack itemStack) {
        Multimap map = itemStack.m_41638_(EquipmentSlot.MAINHAND);
        if (!map.isEmpty()) {
            double d = 0.0;
            for (AttributeModifier mod : map.get((Object)Attributes.f_22281_)) {
                d += mod.m_22218_();
            }
            return d;
        }
        return 0.0;
    }

    private boolean hasLineOfSight(Entity entity) {
        if (entity.m_9236_() != this.m_9236_()) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 vec31 = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        return this.m_9236_().m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    private void updateLastFragment(SnakeBladeEntity lastTendon) {
        Entity creator = this.getCreatorEntity();
        if (creator == null) {
            creator = this.m_9236_().m_46003_(this.getCreatorEntityUUID());
        }
        if (creator instanceof LivingEntity) {
            SnakeBladeHit.setLastFragment((LivingEntity)creator, lastTendon);
        }
    }

    private void createChain(Entity closestValid) {
        this.f_19804_.m_135381_(HAS_BLADE, (Object)false);
        SnakeBladeEntity child = (SnakeBladeEntity)((EntityType)AnnoyingVillagersModEntities.SNAKE_BLADE.get()).m_20615_(this.m_9236_());
        if (this.isEnchanted()) {
            child.setEnchanted(true);
        }
        child.previouslyTouched = new ArrayList<Entity>(this.previouslyTouched);
        child.previouslyTouched.add(closestValid);
        child.setCreatorEntityUUID(this.getCreatorEntityUUID());
        child.setFromEntityID(this.m_19879_());
        child.setToEntityID(closestValid.m_19879_());
        child.m_6034_(closestValid.m_20185_(), closestValid.m_20227_((double)0.4f), closestValid.m_20189_());
        child.setTargetsHit(this.getTargetsHit() + 1);
        this.updateLastFragment(child);
        this.m_9236_().m_7967_((Entity)child);
    }

    public UUID getCreatorEntityUUID() {
        return ((Optional)this.f_19804_.m_135370_(CREATOR_ID)).orElse(null);
    }

    public void setCreatorEntityUUID(UUID id) {
        this.f_19804_.m_135381_(CREATOR_ID, Optional.ofNullable(id));
    }

    public Entity getCreatorEntity() {
        UUID uuid = this.getCreatorEntityUUID();
        if (uuid != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(uuid);
        }
        return null;
    }

    public int getFromEntityID() {
        return (Integer)this.f_19804_.m_135370_(FROM_ID);
    }

    public void setFromEntityID(int id) {
        this.f_19804_.m_135381_(FROM_ID, (Object)id);
    }

    public Entity getFromEntity() {
        return this.getFromEntityID() == -1 ? null : this.m_9236_().m_6815_(this.getFromEntityID());
    }

    public int getToEntityID() {
        return (Integer)this.f_19804_.m_135370_(CURRENT_TARGET_ID);
    }

    public void setToEntityID(int id) {
        this.f_19804_.m_135381_(CURRENT_TARGET_ID, (Object)id);
    }

    public Entity getToEntity() {
        return this.getToEntityID() == -1 ? null : this.m_9236_().m_6815_(this.getToEntityID());
    }

    public int getTargetsHit() {
        return (Integer)this.f_19804_.m_135370_(TARGET_COUNT);
    }

    public void setTargetsHit(int i) {
        this.f_19804_.m_135381_(TARGET_COUNT, (Object)i);
    }

    public float getProgress() {
        return ((Float)this.f_19804_.m_135370_(PROGRESS)).floatValue();
    }

    public void setProgress(float progress) {
        this.f_19804_.m_135381_(PROGRESS, (Object)Float.valueOf(progress));
    }

    public boolean isRetracting() {
        return (Boolean)this.f_19804_.m_135370_(RETRACTING);
    }

    public void setRetracting(boolean retract) {
        this.f_19804_.m_135381_(RETRACTING, (Object)retract);
    }

    public boolean hasBlade() {
        return (Boolean)this.f_19804_.m_135370_(HAS_BLADE);
    }

    protected void m_7378_(CompoundTag tag) {
    }

    protected void m_7380_(CompoundTag tag) {
    }

    public boolean isCreator(Entity mob) {
        return this.getCreatorEntityUUID() != null && mob.m_20148_().equals(this.getCreatorEntityUUID());
    }
}

