/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.pathfinder.Node;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EnderDragon.class})
public abstract class EnderDragonMixin {
    @Shadow
    private BlockPos f_286933_;

    @Shadow
    public abstract BlockPos m_287165_();

    @Redirect(method={"findClosestNode"}, at=@At(value="NEW", target="net/minecraft/world/level/pathfinder/Node"))
    private Node redirectNode(int x, int y, int z) {
        EnderDragon dragon = (EnderDragon)this;
        if (!dragon.m_19880_().contains("av_dragon")) {
            return new Node(x, y, z);
        }
        BlockPos center = EndPodiumFeature.m_287210_((BlockPos)this.m_287165_());
        return new Node(x + center.m_123341_(), y, z + center.m_123343_());
    }

    @Redirect(method={"findClosestNode"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getHeightmapPos(Lnet/minecraft/world/level/levelgen/Heightmap$Types;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/BlockPos;"))
    private BlockPos redirectHeightmap(Level level, Heightmap.Types type, BlockPos originalPos) {
        EnderDragon dragon = (EnderDragon)this;
        if (!dragon.m_19880_().contains("av_dragon")) {
            return level.m_5452_(type, originalPos);
        }
        BlockPos center = EndPodiumFeature.m_287210_((BlockPos)this.m_287165_());
        return level.m_5452_(type, center.m_121955_((Vec3i)originalPos));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void saveFightOrigin(CompoundTag tag, CallbackInfo ci) {
        EnderDragon dragon = (EnderDragon)this;
        if (dragon.m_19880_().contains("av_dragon")) {
            tag.m_128405_("av_fight_origin_x", this.f_286933_.m_123341_());
            tag.m_128405_("av_fight_origin_y", this.f_286933_.m_123342_());
            tag.m_128405_("av_fight_origin_z", this.f_286933_.m_123343_());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void loadFightOrigin(CompoundTag tag, CallbackInfo ci) {
        EnderDragon dragon = (EnderDragon)this;
        if (dragon.m_19880_().contains("av_dragon") && tag.m_128441_("av_fight_origin_x")) {
            int x = tag.m_128451_("av_fight_origin_x");
            int y = tag.m_128451_("av_fight_origin_y");
            int z = tag.m_128451_("av_fight_origin_z");
            this.f_286933_ = new BlockPos(x, y, z);
        }
    }
}

