/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.mixin;

import com.nameless.indestructible.world.capability.Utils.CapabilityState;
import com.nameless.indestructible.world.capability.Utils.IAdvancedCapability;
import com.pla.annoyingvillagers.entity.AegisHerobrineEntity;
import com.pla.annoyingvillagers.item.EnderAegisItem;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageType;

@Mixin(value={CapabilityState.class}, remap=false)
public abstract class IndestructibleMixin {
    @Inject(method={"tryProcess"}, at={@At(value="HEAD")}, cancellable=true)
    private void aegisHerobrineOnGuard(DamageSource damageSource, float amount, CallbackInfoReturnable<AttackResult> cir) {
        CapabilityState self = (CapabilityState)this;
        Entity victim = self.getPatch().getOriginal();
        if (victim instanceof AegisHerobrineEntity) {
            IAdvancedCapability iac;
            AegisHerobrineEntity aegisHerobrineEntity = (AegisHerobrineEntity)victim;
            boolean guardSuccess = true;
            MobPatch animation = self.getPatch();
            if (animation instanceof IAdvancedCapability && (iac = (IAdvancedCapability)animation).isBlocking()) {
                boolean isFront = false;
                Vec3 sourceLocation = damageSource.m_7270_();
                if (sourceLocation != null) {
                    Vec3 viewVector = ((Mob)self.getPatch().getOriginal()).m_20252_(1.0f);
                    Vec3 toSourceLocation = sourceLocation.m_82546_(((Mob)self.getPatch().getOriginal()).m_20182_()).m_82541_();
                    if (toSourceLocation.m_82526_(viewVector) > 0.0) {
                        isFront = true;
                    }
                }
                if (iac.isBlockableSource(damageSource) && isFront) {
                    ItemStack itemStack;
                    LivingEntity livingEntity;
                    float impact;
                    if (damageSource instanceof EpicFightDamageSource) {
                        EpicFightDamageSource efDamageSource = (EpicFightDamageSource)damageSource;
                        impact = efDamageSource.getImpact();
                        if (efDamageSource.m_269533_(EpicFightDamageType.GUARD_PUNCTURE)) {
                            guardSuccess = false;
                        }
                    } else {
                        impact = amount / 3.0f;
                    }
                    float cost = self.maxParryTimes > 0 && self.parryCounter + 1 < self.maxParryTimes ? iac.getParryCostMultiply() : iac.getGuardCostMultiply();
                    float stamina = iac.getStamina() - impact * cost;
                    if (!(stamina >= 0.0f)) {
                        guardSuccess = false;
                    }
                    if (guardSuccess && victim instanceof LivingEntity && !(livingEntity = (LivingEntity)victim).m_9236_().m_5776_() && (itemStack = livingEntity.m_21205_()).m_41720_() instanceof EnderAegisItem) {
                        if (itemStack.m_41783_().m_128471_("SecondForm")) {
                            ((EnderAegisItem)itemStack.m_41720_()).shieldShoot(livingEntity.m_9236_(), (Entity)livingEntity);
                        } else {
                            livingEntity.getPersistentData().m_128405_("ParryCount", (livingEntity.getPersistentData().m_128441_("ParryCount") ? livingEntity.getPersistentData().m_128451_("ParryCount") : 0) + 1);
                        }
                    }
                }
            }
        }
    }
}

