/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.procedures;

import com.pla.annoyingvillagers.util.DelayedTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class BlueDemonDeathSkillProcedure {
    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event != null && event.getEntity() != null) {
            BlueDemonDeathSkillProcedure.execute((Event)event, (LevelAccessor)event.getEntity().m_9236_(), (Entity)event.getEntity(), event.getSource().m_7639_());
        }
    }

    public static void execute(LevelAccessor world, Entity entity, Entity sourceEntity) {
        BlueDemonDeathSkillProcedure.execute(null, world, entity, sourceEntity);
    }

    private static void execute(Event event, final LevelAccessor world, final Entity entity, final Entity sourceEntity) {
        if (entity == null || sourceEntity == null || world == null) {
            return;
        }
        if (!ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString().equals("annoyingvillagers:blue_demon")) {
            return;
        }
        new DelayedTask(90){

            @Override
            public void run() {
                Level level2;
                Level level;
                if (BlueDemonDeathSkillProcedure.isSpectator(sourceEntity) || BlueDemonDeathSkillProcedure.isCreative(sourceEntity)) {
                    Player player;
                    if (entity instanceof Player && !(player = (Player)entity).m_9236_().m_5776_()) {
                        player.m_5661_((Component)Component.m_237113_((String)"No target"), true);
                    }
                    return;
                }
                if (sourceEntity instanceof Player) {
                    Player player = (Player)sourceEntity;
                    player.m_36399_(6.0f);
                }
                if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                    level.m_254849_(null, sourceEntity.m_20185_(), sourceEntity.m_20186_(), sourceEntity.m_20189_(), 10.0f, Level.ExplosionInteraction.NONE);
                }
                BlueDemonDeathSkillProcedure.applyEffect(sourceEntity, MobEffects.f_19610_, 60, 2);
                BlueDemonDeathSkillProcedure.applyEffect(sourceEntity, MobEffects.f_19604_, 70, 2);
                BlueDemonDeathSkillProcedure.applyEffect(sourceEntity, MobEffects.f_19597_, 70, 2);
                if (world instanceof Level && !(level2 = (Level)world).m_5776_()) {
                    level2.m_254849_(null, sourceEntity.m_20185_(), sourceEntity.m_20186_(), sourceEntity.m_20189_(), 8.0f, Level.ExplosionInteraction.BLOCK);
                }
                for (int i = 0; i < 2; ++i) {
                    ServerLevel serverLevel;
                    LightningBolt bolt;
                    if (!(world instanceof ServerLevel) || (bolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)(serverLevel = (ServerLevel)world))) == null) continue;
                    bolt.m_20219_(Vec3.m_82539_((Vec3i)new BlockPos((int)sourceEntity.m_20185_(), (int)sourceEntity.m_20186_(), (int)sourceEntity.m_20189_())));
                    bolt.m_20874_(false);
                    serverLevel.m_7967_((Entity)bolt);
                }
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    ThrownTrident trident = new ThrownTrident(EntityType.f_20487_, (Level)serverLevel);
                    trident.m_7678_(sourceEntity.m_20185_(), sourceEntity.m_20186_() + 5.0, sourceEntity.m_20189_(), world.m_213780_().m_188501_() * 360.0f, 0.0f);
                    serverLevel.m_7967_((Entity)trident);
                }
            }
        };
    }

    private static boolean isSpectator(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            return sp.f_8941_.m_9290_() == GameType.SPECTATOR;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_5776_()) {
                PlayerInfo info = Minecraft.m_91087_().m_91403_().m_104949_(player.m_36316_().getId());
                return info != null && info.m_105325_() == GameType.SPECTATOR;
            }
        }
        return false;
    }

    private static boolean isCreative(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            return sp.f_8941_.m_9290_() == GameType.CREATIVE;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_5776_()) {
                PlayerInfo info = Minecraft.m_91087_().m_91403_().m_104949_(player.m_36316_().getId());
                return info != null && info.m_105325_() == GameType.CREATIVE;
            }
        }
        return false;
    }

    private static void applyEffect(Entity entity, MobEffect effect, int duration, int amplifier) {
        LivingEntity living;
        if (entity instanceof LivingEntity && !(living = (LivingEntity)entity).m_9236_().m_5776_()) {
            living.m_7292_(new MobEffectInstance(effect, duration, amplifier, false, false));
        }
    }
}

