/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.procedures;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FishingHookGrappleProcedure {
    private static final String KEY_LATCHED = "avLatched";
    private static final String KEY_AX = "avAX";
    private static final String KEY_AY = "avAY";
    private static final String KEY_AZ = "avAZ";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        boolean nearlyStopped;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        FishingHook hook = player.f_36083_;
        if (hook == null || !hook.m_6084_()) {
            return;
        }
        CompoundTag tag = hook.getPersistentData();
        if (tag.m_128471_(KEY_LATCHED)) {
            return;
        }
        boolean inWater = hook.m_9236_().m_6425_(hook.m_20183_()).m_205070_(FluidTags.f_13131_);
        if (inWater) {
            return;
        }
        boolean bl = nearlyStopped = hook.m_20184_().m_82556_() < 0.001;
        if (hook.m_20096_() || nearlyStopped) {
            Vec3 anchor = hook.m_20182_();
            tag.m_128379_(KEY_LATCHED, true);
            tag.m_128347_(KEY_AX, anchor.f_82479_);
            tag.m_128347_(KEY_AY, anchor.f_82480_);
            tag.m_128347_(KEY_AZ, anchor.f_82481_);
        }
    }

    private static boolean tryPlunge(Player player, boolean addCooldown) {
        Vec3 eye;
        FishingHook hook = player.f_36083_;
        if (hook == null || !hook.m_6084_()) {
            return false;
        }
        CompoundTag tag = hook.getPersistentData();
        if (!tag.m_128471_(KEY_LATCHED)) {
            return false;
        }
        if (addCooldown && player.m_36335_().m_41519_(Items.f_42523_)) {
            return false;
        }
        Vec3 anchor = new Vec3(tag.m_128459_(KEY_AX), tag.m_128459_(KEY_AY), tag.m_128459_(KEY_AZ));
        Vec3 dir = anchor.m_82546_(eye = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0));
        if (dir.m_82556_() < 1.0E-6) {
            return false;
        }
        dir = dir.m_82541_();
        boolean grounded = player.m_20096_();
        double maxY = grounded ? 1.0 : 0.7;
        dir = new Vec3(dir.f_82479_, Math.max(-maxY, Math.min(maxY, dir.f_82480_)), dir.f_82481_);
        Vec3 vel = player.m_20184_();
        if (grounded) {
            vel = vel.m_82520_(0.0, 0.42, 0.0);
        }
        if (!player.m_9236_().m_5776_()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 5, 1, false, false));
        }
        double power = grounded ? 4.1 : 3.1;
        vel = vel.m_82549_(dir.m_82490_(power));
        player.m_20256_(vel);
        player.f_19864_ = true;
        player.f_19789_ = 0.0f;
        if (addCooldown) {
            player.m_36335_().m_41524_(Items.f_42523_, 20);
        }
        tag.m_128379_(KEY_LATCHED, false);
        return true;
    }

    private static ItemStack getRodInHand(Player p, InteractionHand preferred) {
        ItemStack s = p.m_21120_(preferred);
        if (s.m_150930_(Items.f_42523_)) {
            return s;
        }
        return p.m_21205_().m_150930_(Items.f_42523_) ? p.m_21205_() : p.m_21206_();
    }

    private static void retrieveNow(Player player, InteractionHand hand) {
        FishingHook hook = player.f_36083_;
        if (hook == null || !hook.m_6084_()) {
            return;
        }
        ItemStack rod = FishingHookGrappleProcedure.getRodInHand(player, hand);
        if (!rod.m_150930_(Items.f_42523_)) {
            return;
        }
        int damage = hook.m_37156_(rod);
        if (damage > 0) {
            rod.m_41622_(damage, (LivingEntity)player, pl -> pl.m_21190_(hand));
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        boolean holdingRod;
        Player player = event.getEntity();
        if (player.m_9236_().m_5776_()) {
            return;
        }
        boolean bl = holdingRod = player.m_21205_().m_150930_(Items.f_42523_) || player.m_21206_().m_150930_(Items.f_42523_);
        if (!holdingRod || player.f_36083_ == null) {
            return;
        }
        if (FishingHookGrappleProcedure.tryPlunge(player, true)) {
            FishingHookGrappleProcedure.retrieveNow(player, event.getHand());
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        boolean holdingRod;
        Player player = event.getEntity();
        if (player.m_9236_().m_5776_()) {
            return;
        }
        boolean bl = holdingRod = player.m_21205_().m_150930_(Items.f_42523_) || player.m_21206_().m_150930_(Items.f_42523_);
        if (!holdingRod || player.f_36083_ == null) {
            return;
        }
        if (FishingHookGrappleProcedure.tryPlunge(player, true)) {
            FishingHookGrappleProcedure.retrieveNow(player, event.getHand());
            event.setUseItem(Event.Result.DENY);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        boolean holdingRod;
        Player player = event.getEntity();
        if (player.m_9236_().m_5776_()) {
            return;
        }
        boolean bl = holdingRod = player.m_21205_().m_150930_(Items.f_42523_) || player.m_21206_().m_150930_(Items.f_42523_);
        if (!holdingRod || player.f_36083_ == null) {
            return;
        }
        if (FishingHookGrappleProcedure.tryPlunge(player, true)) {
            FishingHookGrappleProcedure.retrieveNow(player, event.getHand());
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }
}

