/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.procedures;

import com.pla.annoyingvillagers.item.ObsidianSledgehammerItem;
import com.pla.annoyingvillagers.util.GroundSlamUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@Mod.EventBusSubscriber(modid="annoyingvillagers")
public final class GroundSlamHitProcedure {
    private static final Class<? extends Item> REQUIRED_WEAPON = ObsidianSledgehammerItem.class;
    private static final Vec3f TIP_LOCAL = new Vec3f(0.0f, 0.0f, -1.4f);
    private static final float EPS = 0.001f;
    private static final Map<String, float[]> HIT_TIMES = Map.of("torment_auto_4", new float[]{0.55f}, "torment_dash", new float[]{0.45f}, "torment_charged_attack_1", new float[]{1.3f}, "torment_charged_attack_3", new float[]{1.15f}, "torment_airslam", new float[]{0.55f}, "torment_berserk_dash", new float[]{0.5f, 0.85f, 1.4f});
    private static final Map<UUID, State> STATES = new Object2ObjectOpenHashMap();

    private GroundSlamHitProcedure() {
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase != TickEvent.Phase.END || e.player.m_9236_().m_5776_()) {
            return;
        }
        GroundSlamHitProcedure.tickFor((LivingEntity)e.player);
    }

    public static void tickFor(LivingEntity entity) {
        float hitT;
        if (!entity.m_6084_() || entity.m_9236_().m_5776_()) {
            STATES.remove(entity.m_20148_());
            return;
        }
        if (!REQUIRED_WEAPON.isInstance(entity.m_21205_().m_41720_())) {
            STATES.remove(entity.m_20148_());
            return;
        }
        LivingEntityPatch patch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, LivingEntityPatch.class);
        if (patch == null) {
            STATES.remove(entity.m_20148_());
            return;
        }
        AnimationPlayer animPlayer = patch.getAnimator().getPlayerFor((DynamicAnimation)null);
        if (animPlayer == null) {
            STATES.remove(entity.m_20148_());
            return;
        }
        DynamicAnimation anim = animPlayer.getAnimation();
        if (anim == null) {
            STATES.remove(entity.m_20148_());
            return;
        }
        String id = GroundSlamHitProcedure.animationId(anim);
        String key = GroundSlamHitProcedure.keyForKnown(id);
        if (key == null) {
            STATES.remove(entity.m_20148_());
            return;
        }
        State st = STATES.computeIfAbsent(entity.m_20148_(), k -> new State());
        if (!Objects.equals(st.animId, id)) {
            st.animId = id;
            st.nextIndex = 0;
            st.lastT = GroundSlamHitProcedure.getElapsedRaw(animPlayer);
        }
        float t = GroundSlamHitProcedure.getElapsedRaw(animPlayer);
        float[] hits = HIT_TIMES.get(key);
        if (hits != null && st.nextIndex < hits.length && (st.lastT < (hitT = hits[st.nextIndex]) && t >= hitT || Math.abs(t - hitT) <= 0.001f)) {
            GroundSlamHitProcedure.handleGroundHit(entity, patch);
            ++st.nextIndex;
        }
        st.lastT = t;
    }

    private static void handleGroundHit(LivingEntity who, LivingEntityPatch<?> patch) {
        ItemStack itemStack;
        Item item;
        Vec3 tip = GroundSlamUtil.jointWorldPoint(patch, TIP_LOCAL, Armatures.BIPED.toolR);
        BlockHitResult hit = GroundSlamUtil.raycastDown(who.m_9236_(), tip.m_82520_(0.0, 0.25, 0.0), patch, 6.0);
        if (hit == null) {
            return;
        }
        BlockPos bp = hit.m_82425_();
        if (!who.m_9236_().m_5776_() && (item = (itemStack = who.m_21205_()).m_41720_()) instanceof ObsidianSledgehammerItem) {
            ObsidianSledgehammerItem obsidianSledgehammerItem = (ObsidianSledgehammerItem)item;
            if (itemStack.m_41783_().m_128441_("SecondForm")) {
                obsidianSledgehammerItem.circleHit((Entity)who, bp);
            }
        }
    }

    private static String animationId(DynamicAnimation anim) {
        try {
            ResourceLocation rl = (ResourceLocation)anim.getClass().getMethod("getLocation", new Class[0]).invoke((Object)anim, new Object[0]);
            if (rl != null) {
                return rl.m_135815_().toLowerCase(Locale.ROOT);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return anim.toString().toLowerCase(Locale.ROOT);
    }

    private static String keyForKnown(String id) {
        for (String key : HIT_TIMES.keySet()) {
            if (!id.contains(key)) continue;
            return key;
        }
        return null;
    }

    private static float getElapsedRaw(Object animPlayer) {
        try {
            return ((Float)animPlayer.getClass().getMethod("getElapsedTime", new Class[0]).invoke(animPlayer, new Object[0])).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    private static final class State {
        String animId = "";
        int nextIndex = 0;
        float lastT = 0.0f;

        private State() {
        }
    }
}

