/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.procedures;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.annoyingvillagers.clazz.HerobrineMob;
import com.pla.annoyingvillagers.entity.ShadowHerobrineEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class HerobrinePortalProcedure {
    public static final int SHINK_TIME_START = 40;
    public static final String NBT_RISING = "rising";
    public static final String NBT_TARGET_Y = "rise_target_y";
    public static final String NBT_SPEED = "rise_speed";
    public static final String NBT_TICKS = "rise_ticks";
    public static final String NBT_MAX_TICKS = "rise_max_ticks";
    public static final String NBT_SINKING = "sinking";
    public static final String NBT_SINK_TARGET_Y = "sink_target_y";
    public static final String NBT_SINK_SPEED = "sink_speed";
    public static final String NBT_SINK_TICKS = "sink_ticks";
    public static final String NBT_SINK_MAX_TICKS = "sink_max_ticks";

    public static void spawnHerobrine(LivingEntity livingEntity) {
        Level level = livingEntity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (livingEntity instanceof HerobrineMob) {
                HerobrineMob herobrineMob = (HerobrineMob)livingEntity;
                if (herobrineMob.getGregUUID() == null) {
                    try {
                        herobrineMob.m_20194_().m_129892_().m_82094_().execute("playsound annoyingvillagers:portal_natural neutral @a ~ ~ ~", (Object)herobrineMob.m_20203_().m_81324_().m_81325_(4));
                    }
                    catch (CommandSyntaxException commandSyntaxException) {
                        // empty catch block
                    }
                }
                if (herobrineMob instanceof ShadowHerobrineEntity) {
                    ShadowHerobrineEntity shadowHerobrineEntity = (ShadowHerobrineEntity)herobrineMob;
                    shadowHerobrineEntity.spawnDarkObEntities();
                }
            }
            HerobrinePortalProcedure.spawnRising(serverLevel, livingEntity, livingEntity.m_20185_(), livingEntity.m_20189_(), 0.03);
        }
    }

    public static Vec3 finalSurfacePos(Entity entity) {
        ServerLevel serverLevel = (ServerLevel)entity.m_9236_();
        BlockPos top = serverLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BlockPos.m_274561_((double)entity.m_20185_(), (double)0.0, (double)entity.m_20189_()));
        return new Vec3((double)top.m_123341_() + 0.5, (double)top.m_123342_() + 0.02, (double)top.m_123343_() + 0.5);
    }

    public static <T extends LivingEntity> T spawnRising(ServerLevel level, T entity, double x, double z, double speedPerTick) {
        BlockPos top = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos((int)x, 0, (int)z));
        double groundY = top.m_123342_();
        double startY = groundY - 2.0;
        entity.m_7678_(x, startY, z, entity.m_146908_(), entity.m_146909_());
        entity.f_19794_ = true;
        entity.m_20242_(true);
        entity.m_20331_(true);
        CompoundTag tag = entity.getPersistentData();
        tag.m_128379_(NBT_RISING, true);
        tag.m_128347_(NBT_TARGET_Y, groundY + 0.02);
        tag.m_128347_(NBT_SPEED, Math.max(0.01, speedPerTick));
        tag.m_128405_(NBT_TICKS, 0);
        tag.m_128405_(NBT_MAX_TICKS, 100);
        level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12404_, SoundSource.HOSTILE, 0.6f, 0.8f + level.f_46441_.m_188501_() * 0.2f);
        return entity;
    }

    public static <T extends LivingEntity> T sinkIntoGround(ServerLevel level, T entity, double speedPerTick) {
        BlockPos top = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, entity.m_20183_());
        double groundY = top.m_123342_();
        double targetY = groundY - 1.2;
        entity.f_19794_ = true;
        entity.m_20242_(true);
        entity.m_20331_(true);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_21557_(true);
        }
        CompoundTag tag = entity.getPersistentData();
        tag.m_128379_(NBT_SINKING, true);
        tag.m_128347_(NBT_SINK_TARGET_Y, targetY);
        tag.m_128347_(NBT_SINK_SPEED, Math.max(0.01, speedPerTick));
        tag.m_128405_(NBT_SINK_TICKS, 0);
        tag.m_128405_(NBT_SINK_MAX_TICKS, 100);
        level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12404_, SoundSource.HOSTILE, 0.5f, 1.2f + level.f_46441_.m_188501_() * 0.2f);
        return entity;
    }
}

