/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.procedures;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.annoyingvillagers.clazz.PathfinderMobInventory;
import com.pla.annoyingvillagers.entity.PlayerNpcEntity;
import com.pla.annoyingvillagers.util.AnimationSheduler;
import com.pla.annoyingvillagers.util.BurnItemScheduler;
import com.pla.annoyingvillagers.util.IdleAnimation;
import com.pla.annoyingvillagers.util.TaskScheduler;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCapability;

@Mod.EventBusSubscriber
public class IdleHandlerProcedure {
    static Random RANDOM = new Random();

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity != null && !entity.m_9236_().m_5776_()) {
            if (entity instanceof PathfinderMobInventory) {
                IdleHandlerProcedure.scheduleIdleActionDecision((Mob)event.getEntity());
            } else if (entity instanceof Zombie || entity instanceof AbstractSkeleton) {
                LivingEntity livingEntity = entity;
                if (IdleHandlerProcedure.canPlayAnimation(livingEntity.m_21205_())) {
                    IdleHandlerProcedure.performIdleAction((Entity)entity, IdleAction.PLAY_ANIMATION);
                }
            } else if (entity instanceof PlayerNpcEntity) {
                IdleHandlerProcedure.scheduleIdleActionDecision((Mob)event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity hurtEntity = event.getEntity();
        if (hurtEntity.m_9236_().m_5776_()) {
            return;
        }
        IdleHandlerProcedure.resetItem((Entity)hurtEntity);
    }

    private static void resetItem(Entity entity) {
        if (entity.getPersistentData().m_128441_("av_idle_burn_backup_main_hand")) {
            CompoundTag fullTag = null;
            try {
                fullTag = TagParser.m_129359_((String)entity.getPersistentData().m_128461_("av_idle_burn_backup_main_hand"));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            String id = fullTag.m_128461_("id");
            String nbtPart = fullTag.m_128441_("tag") ? fullTag.m_128469_("tag").toString() : "";
            String cmd = "item replace entity @s weapon.mainhand with " + id;
            if (!nbtPart.isEmpty()) {
                cmd = cmd + nbtPart;
            }
            try {
                entity.m_20194_().m_129892_().m_82094_().execute(cmd, (Object)entity.m_20203_().m_81324_().m_81325_(4));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            entity.getPersistentData().m_128473_("av_idle_burn_backup_main_hand");
        }
    }

    public static IdleAction getRandomIdleAction() {
        return RANDOM.nextFloat() < 0.25f ? IdleAction.BURN_ITEM : IdleAction.PLAY_ANIMATION;
    }

    private static void scheduleIdleActionDecision(Mob mob) {
        if (mob.m_20159_()) {
            return;
        }
        if (!IdleHandlerProcedure.canPlayAnimation(mob.m_21205_())) {
            IdleHandlerProcedure.performIdleAction((Entity)mob, IdleAction.BURN_ITEM);
        } else {
            CompoundTag data = mob.getPersistentData();
            if (!data.m_128441_("av_idle_action")) {
                IdleAction action = IdleHandlerProcedure.getRandomIdleAction();
                data.m_128359_("av_idle_action", action.toString());
                IdleHandlerProcedure.performIdleAction((Entity)mob, action);
            } else {
                IdleHandlerProcedure.performIdleAction((Entity)mob, IdleAction.valueOf(data.m_128461_("av_idle_action")));
            }
        }
    }

    public static boolean canPlayAnimation(ItemStack stack) {
        CapabilityItem cap = EpicFightCapabilities.getItemStackCapability((ItemStack)stack);
        if (cap instanceof WeaponCapability) {
            WeaponCapability weaponCap = (WeaponCapability)cap;
            return weaponCap.getWeaponCategory() == CapabilityItem.WeaponCategories.SWORD || weaponCap.getWeaponCategory() == CapabilityItem.WeaponCategories.AXE || weaponCap.getWeaponCategory() == CapabilityItem.WeaponCategories.FIST || weaponCap.getWeaponCategory() == CapabilityItem.WeaponCategories.RANGED || weaponCap.getWeaponCategory() == CapabilityItem.WeaponCategories.HOE || weaponCap.getWeaponCategory() == CapabilityItem.WeaponCategories.TRIDENT;
        }
        return false;
    }

    private static void performIdleAction(Entity entity, IdleAction action) {
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (mob.m_213877_() || mob.m_21224_()) {
            return;
        }
        CompoundTag data = mob.getPersistentData();
        if (mob.m_5448_() != null) {
            if (data.m_128441_("av_idle_action")) {
                data.m_128473_("av_idle_action");
            }
            if (data.m_128441_("av_idle_animation_playing")) {
                data.m_128473_("av_idle_animation_playing");
                mob.m_21557_(false);
            }
            IdleHandlerProcedure.resetItem((Entity)mob);
            return;
        }
        switch (action) {
            case BURN_ITEM: {
                List nearbyItems = mob.m_9236_().m_45976_(ItemEntity.class, mob.m_20191_().m_82400_(2.0));
                if (nearbyItems.isEmpty() || data.m_128441_("av_idle_burn_backup_main_hand")) break;
                ItemStack held = mob.m_21205_();
                if (!held.m_41619_() && held.m_41720_() != Items.f_42409_) {
                    CompoundTag tag = new CompoundTag();
                    held.m_41739_(tag);
                    data.m_128359_("av_idle_burn_backup_main_hand", tag.toString());
                }
                TaskScheduler.schedule(() -> {
                    try {
                        new BurnItemScheduler(mob).run();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }, 10);
                break;
            }
            case PLAY_ANIMATION: {
                IdleAnimation idleAnimation;
                if (data.m_128441_("av_idle_animation_playing")) break;
                data.m_128359_("av_idle_animation_playing", "playing");
                mob.m_21557_(true);
                if (mob instanceof PlayerNpcEntity) {
                    idleAnimation = IdleAnimation.values()[RANDOM.nextInt(IdleAnimation.values().length)];
                } else {
                    IdleAnimation[] subset = new IdleAnimation[]{IdleAnimation.SIT, IdleAnimation.LAY};
                    idleAnimation = subset[new Random().nextInt(subset.length)];
                }
                TaskScheduler.schedule(() -> {
                    try {
                        new AnimationSheduler(mob).run(idleAnimation, false, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }, 20);
            }
        }
    }

    public static enum IdleAction {
        BURN_ITEM,
        PLAY_ANIMATION;

    }
}

