/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.procedures;

import com.pla.annoyingvillagers.clazz.HerobrineMob;
import com.pla.annoyingvillagers.entity.HerobrineGregEntity;
import com.pla.annoyingvillagers.entity.LowHerobrineCloneEntity;
import com.pla.annoyingvillagers.entity.LowShadowHerobrineCloneEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="annoyingvillagers", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RiseFromGroundHandler {
    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        CompoundTag tag = entity.getPersistentData();
        if (tag.m_128471_("rising")) {
            double targetY = tag.m_128459_("rise_target_y");
            double speed = tag.m_128459_("rise_speed");
            int ticks = tag.m_128451_("rise_ticks");
            int max = tag.m_128451_("rise_max_ticks");
            double ny = entity.m_20186_() + speed;
            if (ny >= targetY || ticks > max) {
                entity.m_6034_(entity.m_20185_(), targetY, entity.m_20189_());
                RiseFromGroundHandler.finishRise(entity);
            } else {
                entity.m_6034_(entity.m_20185_(), ny, entity.m_20189_());
                tag.m_128405_("rise_ticks", ticks + 1);
            }
            return;
        }
        if (tag.m_128471_("sinking")) {
            double speed = tag.m_128459_("sink_speed");
            int ticks = tag.m_128451_("sink_ticks");
            entity.m_6034_(entity.m_20185_(), entity.m_20186_() - speed, entity.m_20189_());
            tag.m_128405_("sink_ticks", ticks + 1);
        }
    }

    private static void finishRise(LivingEntity entity) {
        CompoundTag tag = entity.getPersistentData();
        entity.f_19794_ = false;
        entity.m_20242_(false);
        entity.m_20331_(false);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_21557_(false);
        }
        tag.m_128473_("rising");
        tag.m_128473_("rise_target_y");
        tag.m_128473_("rise_speed");
        tag.m_128473_("rise_ticks");
        tag.m_128473_("rise_max_ticks");
        if (entity instanceof HerobrineMob) {
            HerobrineGregEntity herobrineGregEntity;
            Entity greg;
            HerobrineMob herobrineMob = (HerobrineMob)entity;
            if (herobrineMob.getGregUUID() != null && (greg = ((ServerLevel)herobrineMob.m_9236_()).m_8791_(herobrineMob.getGregUUID())) instanceof HerobrineGregEntity && (herobrineGregEntity = (HerobrineGregEntity)greg).m_6084_() && herobrineGregEntity.isSummoning()) {
                herobrineGregEntity.setSummoning(false);
                herobrineGregEntity.m_21557_(false);
            }
            herobrineMob.setInitialSpawn(false);
        }
        if (entity instanceof LowHerobrineCloneEntity) {
            LowHerobrineCloneEntity lowHerobrineCloneEntity = (LowHerobrineCloneEntity)entity;
            lowHerobrineCloneEntity.setInitialSpawn(false);
        }
        if (entity instanceof LowShadowHerobrineCloneEntity) {
            LowShadowHerobrineCloneEntity lowShadowHerobrineCloneEntity = (LowShadowHerobrineCloneEntity)entity;
            lowShadowHerobrineCloneEntity.setInitialSpawn(false);
        }
    }
}

