/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.util;

import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public abstract class DelayedTask {
    private int ticks = 0;
    private final int waitTicks;
    private boolean done = false;
    private boolean pendingUnregister = false;
    private boolean unregistered = false;

    public DelayedTask(int waitTicks) {
        this.waitTicks = waitTicks;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (this.pendingUnregister && !this.unregistered) {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server != null) {
                    server.execute(() -> {
                        if (!this.unregistered) {
                            MinecraftForge.EVENT_BUS.unregister((Object)this);
                            this.unregistered = true;
                        }
                    });
                } else {
                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                    this.unregistered = true;
                }
                this.pendingUnregister = false;
            }
            return;
        }
        if (this.done) {
            return;
        }
        if (++this.ticks >= this.waitTicks) {
            this.done = true;
            try {
                this.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.pendingUnregister = true;
        }
    }

    public abstract void run();
}

