/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.util;

import com.pla.annoyingvillagers.capabilities.SnakeBladeCapability;
import com.pla.annoyingvillagers.entity.SnakeBladeEntity;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModCapabilities;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModEntities;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModItems;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class SnakeBladeHit {
    public static boolean process(ItemStack stack, LivingEntity playerIn) {
        if (stack.m_150930_((Item)AnnoyingVillagersModItems.DEMONIAC_VOLTAGE_REAVER.get())) {
            Level worldIn = playerIn.m_9236_();
            Entity closestValid = null;
            Vec3 playerEyes = playerIn.m_20299_(1.0f);
            BlockHitResult hitresult = worldIn.m_45547_(new ClipContext(playerEyes, playerEyes.m_82549_(playerIn.m_20154_().m_82490_(16.0)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)playerIn));
            if (hitresult instanceof EntityHitResult) {
                Entity entity = ((EntityHitResult)hitresult).m_82443_();
                if (!entity.equals((Object)playerIn) && !playerIn.m_7307_(entity) && !entity.m_7307_((Entity)playerIn) && (entity instanceof Mob || entity instanceof Player) && playerIn.m_142582_(entity)) {
                    closestValid = entity;
                }
            } else {
                for (Entity entity : worldIn.m_45976_(LivingEntity.class, playerIn.m_20191_().m_82400_(16.0))) {
                    if (entity.equals((Object)playerIn) || playerIn.m_7307_(entity) || entity.m_7307_((Entity)playerIn) || !(entity instanceof Mob) && !(entity instanceof Player) || !playerIn.m_142582_(entity) || closestValid != null && !(playerIn.m_20270_(entity) < playerIn.m_20270_(closestValid))) continue;
                    closestValid = entity;
                }
            }
            return SnakeBladeHit.launchSnakeBladeAt(playerIn, closestValid, stack);
        }
        return false;
    }

    public static boolean launchSnakeBladeAt(LivingEntity playerIn, Entity closestValid, ItemStack stack) {
        Level worldIn = playerIn.m_9236_();
        SnakeBladeCapability.ISnakeBladeCapability snakeBladeCapability = AnnoyingVillagersModCapabilities.getCapability((Entity)playerIn, AnnoyingVillagersModCapabilities.SNAKE_BLADE_CAPABILITY);
        if (snakeBladeCapability != null && SnakeBladeHit.canLaunchTentacles(worldIn, playerIn)) {
            SnakeBladeHit.retractFarFragments(worldIn, playerIn);
            if (!worldIn.f_46443_ && closestValid != null) {
                SnakeBladeEntity segment = (SnakeBladeEntity)((EntityType)AnnoyingVillagersModEntities.SNAKE_BLADE.get()).m_20615_(worldIn);
                if (segment != null && stack.m_41790_()) {
                    segment.setEnchanted(true);
                }
                segment.m_20359_((Entity)playerIn);
                worldIn.m_7967_((Entity)segment);
                segment.setCreatorEntityUUID(playerIn.m_20148_());
                segment.setFromEntityID(playerIn.m_19879_());
                segment.setToEntityID(closestValid.m_19879_());
                segment.m_20359_((Entity)playerIn);
                segment.setProgress(0.0f);
                SnakeBladeHit.setLastFragment(playerIn, segment);
                return true;
            }
        }
        return false;
    }

    public static void setLastFragment(LivingEntity entity, SnakeBladeEntity tendon) {
        SnakeBladeCapability.ISnakeBladeCapability TentacleCapability = AnnoyingVillagersModCapabilities.getCapability((Entity)entity, AnnoyingVillagersModCapabilities.SNAKE_BLADE_CAPABILITY);
        if (TentacleCapability != null) {
            TentacleCapability.setHasSnakeBlade(tendon != null);
        }
    }

    public static void retractFarFragments(Level level, LivingEntity livingEntity) {
        SnakeBladeEntity last = SnakeBladeHit.getLastFragment(livingEntity);
        if (last != null) {
            last.m_142687_(Entity.RemovalReason.DISCARDED);
            SnakeBladeHit.setLastFragment(livingEntity, null);
        }
    }

    public static boolean canLaunchTentacles(Level level, LivingEntity livingEntity) {
        SnakeBladeEntity last = SnakeBladeHit.getLastFragment(livingEntity);
        if (last != null) {
            return last.m_213877_();
        }
        return true;
    }

    public static SnakeBladeEntity getLastFragment(LivingEntity livingEntity) {
        SnakeBladeCapability.ISnakeBladeCapability snakeBladeCapability = AnnoyingVillagersModCapabilities.getCapability((Entity)livingEntity, AnnoyingVillagersModCapabilities.SNAKE_BLADE_CAPABILITY);
        if (snakeBladeCapability != null) {
            UUID uuid = snakeBladeCapability.getLastSnakeBladeUUID();
            int id = snakeBladeCapability.getLastSnakeBladeID();
            if (!livingEntity.m_9236_().f_46443_) {
                if (uuid != null) {
                    Entity entity = livingEntity.m_9236_().m_6815_(id);
                    if (entity == null || !entity.m_6084_() || !(entity instanceof SnakeBladeEntity)) {
                        return null;
                    }
                    return (SnakeBladeEntity)entity;
                }
            } else if (id != -1) {
                Entity entity = livingEntity.m_9236_().m_6815_(id);
                if (entity == null || !entity.m_6084_() || !(entity instanceof SnakeBladeEntity)) {
                    return null;
                }
                return (SnakeBladeEntity)entity;
            }
            return null;
        }
        return null;
    }

    public static Vec3 getToolTipPos(Entity ent, float partialTicks, float handToTip) {
        LivingEntityPatch patch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)ent, LivingEntityPatch.class);
        if (patch == null) {
            return null;
        }
        OpenMatrix4f joint = patch.getArmature().getBindedTransformFor(patch.getAnimator().getPose(partialTicks), Armatures.BIPED.toolR);
        OpenMatrix4f localOffset = new OpenMatrix4f().translate(new Vec3f(0.0f, 0.0f, -handToTip));
        OpenMatrix4f.mul((OpenMatrix4f)joint, (OpenMatrix4f)localOffset, (OpenMatrix4f)joint);
        float yawRad = (float)(-Math.toRadians(((LivingEntity)ent).f_20884_ + 180.0f));
        OpenMatrix4f worldYaw = new OpenMatrix4f().rotate(yawRad, new Vec3f(0.0f, 1.0f, 0.0f));
        OpenMatrix4f.mul((OpenMatrix4f)worldYaw, (OpenMatrix4f)joint, (OpenMatrix4f)joint);
        return new Vec3((double)joint.m30 + ent.m_20185_(), (double)joint.m31 + (ent.m_20186_() + (double)(ent.m_20206_() / 1.8f) - 1.0), (double)joint.m32 + ent.m_20189_());
    }
}

