/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TaskScheduler {
    private static final List<ScheduledTask> tasks = new LinkedList<ScheduledTask>();
    private static final List<ScheduledTask> pendingTasks = new LinkedList<ScheduledTask>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(Runnable task, int delayTicks) {
        List<ScheduledTask> list = pendingTasks;
        synchronized (list) {
            pendingTasks.add(new ScheduledTask(task, delayTicks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        List<ScheduledTask> list = pendingTasks;
        synchronized (list) {
            tasks.addAll(pendingTasks);
            pendingTasks.clear();
        }
        Iterator<ScheduledTask> iterator = tasks.iterator();
        while (iterator.hasNext()) {
            ScheduledTask task = iterator.next();
            --task.ticksRemaining;
            if (task.ticksRemaining > 0) continue;
            try {
                task.task.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            iterator.remove();
        }
    }

    private static class ScheduledTask {
        Runnable task;
        int ticksRemaining;

        ScheduledTask(Runnable task, int ticks) {
            this.task = task;
            this.ticksRemaining = ticks;
        }
    }
}

