/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.animations.types;

import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.property.MoveCoordFunctions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.JointMask;
import yesman.epicfight.api.client.animation.property.JointMaskEntry;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.datastruct.TypeFlexibleHashMap;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.gamerule.EpicFightGamerules;

public class ExecuteAttackAnimation
extends AttackAnimation {
    void init() {
        if (!this.properties.containsKey(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED)) {
            float mfloat = Float.parseFloat(String.format(Locale.US, "%.2f", Float.valueOf(1.0f / this.getTotalTime())));
            this.addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, Float.valueOf(mfloat));
        }
        if (FMLEnvironment.dist == Dist.CLIENT) {
            HashSet<JointMask> jointMaskSet = new HashSet<JointMask>();
            jointMaskSet.add(JointMask.of((String)"Root", (JointMask.BindModifier)JointMask.KEEP_CHILD_LOCROT));
            jointMaskSet.add(JointMask.of((String)"Torso"));
            jointMaskSet.add(JointMask.of((String)"Chest"));
            jointMaskSet.add(JointMask.of((String)"Head"));
            jointMaskSet.add(JointMask.of((String)"Shoulder_R"));
            jointMaskSet.add(JointMask.of((String)"Arm_R"));
            jointMaskSet.add(JointMask.of((String)"Hand_R"));
            jointMaskSet.add(JointMask.of((String)"Elbow_R"));
            jointMaskSet.add(JointMask.of((String)"Tool_R"));
            jointMaskSet.add(JointMask.of((String)"Shoulder_L"));
            jointMaskSet.add(JointMask.of((String)"Arm_L"));
            jointMaskSet.add(JointMask.of((String)"Hand_L"));
            jointMaskSet.add(JointMask.of((String)"Elbow_L"));
            jointMaskSet.add(JointMask.of((String)"Tool_L"));
            jointMaskSet.add(JointMask.of((String)"Thigh_R"));
            jointMaskSet.add(JointMask.of((String)"Leg_R"));
            jointMaskSet.add(JointMask.of((String)"Knee_R"));
            jointMaskSet.add(JointMask.of((String)"Thigh_L"));
            jointMaskSet.add(JointMask.of((String)"Leg_L"));
            jointMaskSet.add(JointMask.of((String)"Knee_L"));
            JointMaskEntry jointMaskEntry = JointMaskEntry.builder().defaultMask(JointMask.JointMaskSet.of(jointMaskSet)).create();
            this.addProperty(ClientAnimationProperties.JOINT_MASK, jointMaskEntry);
        }
    }

    public ExecuteAttackAnimation(float f, float f1, float f2, float f3, @Nullable Collider collider, Joint joint, String s, Armature armature) {
        this(f, f1, f1, f2, f3, collider, joint, s, armature);
    }

    public ExecuteAttackAnimation(float f, float f1, float f2, float f3, float f4, @Nullable Collider collider, Joint joint, String s, Armature armature) {
        this(f, s, armature, new AttackAnimation.Phase(0.0f, f1, f2, f3, f4, Float.MAX_VALUE, joint, collider));
    }

    public ExecuteAttackAnimation(float f, float f1, float f2, float f3, InteractionHand interactionhand, @Nullable Collider collider, Joint joint, String s, Armature armature) {
        this(f, s, armature, new AttackAnimation.Phase(0.0f, f1, f1, f2, f3, Float.MAX_VALUE, interactionhand, joint, collider));
    }

    public ExecuteAttackAnimation(float f, String s, Armature armature, boolean flag, AttackAnimation.Phase ... aphase) {
        super(f, s, armature, aphase);
        this.init();
    }

    public ExecuteAttackAnimation(float f, String s, Armature armature, AttackAnimation.Phase ... aphase) {
        super(f, s, armature, aphase);
        this.init();
        this.newTimePair(0.0f, Float.MAX_VALUE);
        this.addStateRemoveOld(EntityState.TURNING_LOCKED, false);
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN, MoveCoordFunctions.TRACE_LOC_TARGET);
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, (dynamicanimation, livingentitypatch, transformsheet) -> {
            LivingEntity livingentity = livingentitypatch.getTarget();
            if (!dynamicanimation.getRealAnimation().getProperty((AnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE).orElse(false).booleanValue() && livingentity != null) {
                TransformSheet transformsheet1 = ((TransformSheet)dynamicanimation.getTransfroms().get("Root")).copyAll();
                Keyframe[] akeyframe = transformsheet1.getKeyframes();
                int b0 = 0;
                int i = transformsheet1.getKeyframes().length - 1;
                Vec3f vec3f = akeyframe[i].transform().translation();
                Vec3 vec3 = ((LivingEntity)livingentitypatch.getOriginal()).m_146892_();
                Vec3 vec31 = livingentity.m_20182_();
                float f1 = Math.max((float)vec31.m_82546_(vec3).m_165924_() * 1.75f - (livingentity.m_20205_() + ((LivingEntity)livingentitypatch.getOriginal()).m_20205_()) * 0.75f, 0.0f);
                Vec3f vec3f1 = new Vec3f(vec3f.x, 0.0f, -f1);
                float f2 = Math.min(vec3f1.length() / vec3f.length(), 2.0f);
                for (int j = b0; j <= i; ++j) {
                    Vec3f vec3f2 = akeyframe[j].transform().translation();
                    vec3f2.z *= f2;
                }
                transformsheet.readFrom(transformsheet1);
            } else {
                transformsheet.readFrom((TransformSheet)dynamicanimation.getTransfroms().get("Root"));
            }
        });
    }

    public void end(LivingEntityPatch<?> livingentitypatch, DynamicAnimation dynamicanimation, boolean flag) {
        super.end(livingentitypatch, dynamicanimation, flag);
        boolean flag1 = ((GameRules.BooleanValue)((LivingEntity)livingentitypatch.getOriginal()).m_9236_().m_46469_().m_46170_(EpicFightGamerules.STIFF_COMBO_ATTACKS)).m_46223_();
        if (!flag && !dynamicanimation.isMainFrameAnimation() && livingentitypatch.isLogicalClient() && !flag1) {
            float f = 0.05f * this.getPlaySpeed(livingentitypatch, dynamicanimation);
            livingentitypatch.getClientAnimator().baseLayer.copyLayerTo(livingentitypatch.getClientAnimator().baseLayer.getLayer(Layer.Priority.HIGHEST), f);
        }
    }

    public TypeFlexibleHashMap<EntityState.StateFactor<?>> getStatesMap(LivingEntityPatch<?> livingentitypatch, float f) {
        TypeFlexibleHashMap typeflexiblehashmap = super.getStatesMap(livingentitypatch, f);
        if (!((GameRules.BooleanValue)((LivingEntity)livingentitypatch.getOriginal()).m_9236_().m_46469_().m_46170_(EpicFightGamerules.STIFF_COMBO_ATTACKS)).m_46223_()) {
            typeflexiblehashmap.put((Object)EntityState.MOVEMENT_LOCKED, Optional.of(false));
        }
        return typeflexiblehashmap;
    }

    public Vec3 getCoordVector(LivingEntityPatch<?> livingentitypatch, DynamicAnimation dynamicanimation) {
        Vec3 vec3 = super.getCoordVector(livingentitypatch, dynamicanimation);
        if (livingentitypatch.shouldBlockMoving() && this.getProperty((AnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE).orElse(false).booleanValue()) {
            vec3 = vec3.m_82490_(0.0);
        }
        return vec3;
    }

    public boolean isBasicAttackAnimation() {
        return true;
    }

    public float applyAntiStunLock(Entity entity, float f, EpicFightDamageSource epicfightdamagesource, AttackAnimation.Phase phase, String s, String s1) {
        int b0;
        int i;
        boolean flag = false;
        if (entity.m_9236_().m_8055_(new BlockPos(new Vec3i((int)entity.m_20185_(), (int)entity.m_20186_() - 1, (int)entity.m_20189_()))).m_60795_() && epicfightdamagesource.getStunType() != StunType.FALL) {
            s2 = String.valueOf(this.getId());
            s3 = s2 + "-" + String.valueOf(phase.contact);
            if (s.split(":").length > 3) {
                if (String.valueOf(this.getId()).equals(s.split(":")[3].split("-")[0]) && !String.valueOf(phase.contact).equals(s.split(":")[3].split("-")[1])) {
                    f = Float.valueOf(s.split(":")[1]).floatValue() * 0.98f;
                    flag = true;
                } else {
                    f = Float.valueOf(s.split(":")[1]).floatValue() * 0.9f;
                    flag = false;
                }
            }
            for (i = 3; i < s.split(":").length && i < 7; ++i) {
                if (!s.split(":")[i].equals(s3)) continue;
                f *= 0.6f;
            }
        } else {
            s2 = String.valueOf(this.getId());
            s3 = s2 + "-" + String.valueOf(phase.contact);
            if (s.split(":").length > 3) {
                if (String.valueOf(this.getId()).equals(s.split(":")[3].split("-")[0]) && !String.valueOf(phase.contact).equals(s.split(":")[3].split("-")[1])) {
                    f = Float.valueOf(s.split(":")[1]).floatValue() * 0.98f;
                    flag = true;
                } else {
                    f = Float.valueOf(s.split(":")[1]).floatValue() * 0.8f;
                    flag = false;
                }
            }
            for (i = 3; i < s.split(":").length && i < 5; ++i) {
                if (!s.split(":")[i].equals(s3)) continue;
                f *= 0.6f;
            }
        }
        entity.m_20137_(s);
        boolean flag1 = true;
        if (flag) {
            s1 = "anti_stunlock:" + f + ":" + entity.f_19797_;
            b0 = 6;
        } else {
            s1 = "anti_stunlock:" + f + ":" + entity.f_19797_ + ":" + this.getId() + "-" + phase.contact;
            b0 = 5;
        }
        for (i = 3; i < s.split(":").length && i < b0; ++i) {
            s1 = ((String)s1).concat(":" + s.split(":")[i]);
        }
        entity.m_20049_((String)s1);
        return f;
    }
}

