/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.animations.types;

import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.JointMask;
import yesman.epicfight.api.client.animation.property.JointMaskEntry;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.datastruct.TypeFlexibleHashMap;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.gamerule.EpicFightGamerules;

public class HeavyAttackAnimation
extends AttackAnimation {
    void init() {
        if (!this.properties.containsKey(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED)) {
            float mfloat = Float.parseFloat(String.format(Locale.US, "%.2f", Float.valueOf(1.0f / this.getTotalTime())));
            this.addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, Float.valueOf(mfloat));
        }
        if (FMLEnvironment.dist == Dist.CLIENT) {
            HashSet<JointMask> jointMaskSet = new HashSet<JointMask>();
            jointMaskSet.add(JointMask.of((String)"Root", (JointMask.BindModifier)JointMask.KEEP_CHILD_LOCROT));
            jointMaskSet.add(JointMask.of((String)"Torso"));
            jointMaskSet.add(JointMask.of((String)"Chest"));
            jointMaskSet.add(JointMask.of((String)"Head"));
            jointMaskSet.add(JointMask.of((String)"Shoulder_R"));
            jointMaskSet.add(JointMask.of((String)"Arm_R"));
            jointMaskSet.add(JointMask.of((String)"Hand_R"));
            jointMaskSet.add(JointMask.of((String)"Elbow_R"));
            jointMaskSet.add(JointMask.of((String)"Tool_R"));
            jointMaskSet.add(JointMask.of((String)"Shoulder_L"));
            jointMaskSet.add(JointMask.of((String)"Arm_L"));
            jointMaskSet.add(JointMask.of((String)"Hand_L"));
            jointMaskSet.add(JointMask.of((String)"Elbow_L"));
            jointMaskSet.add(JointMask.of((String)"Tool_L"));
            jointMaskSet.add(JointMask.of((String)"Thigh_R"));
            jointMaskSet.add(JointMask.of((String)"Leg_R"));
            jointMaskSet.add(JointMask.of((String)"Knee_R"));
            jointMaskSet.add(JointMask.of((String)"Thigh_L"));
            jointMaskSet.add(JointMask.of((String)"Leg_L"));
            jointMaskSet.add(JointMask.of((String)"Knee_L"));
            JointMaskEntry jointMaskEntry = JointMaskEntry.builder().defaultMask(JointMask.JointMaskSet.of(jointMaskSet)).create();
            this.addProperty(ClientAnimationProperties.JOINT_MASK, jointMaskEntry);
        }
    }

    public HeavyAttackAnimation(float f, float f1, float f2, float f3, @Nullable Collider collider, Joint joint, String s, Armature armature) {
        this(f, f1, f1, f2, f3, collider, joint, s, armature);
    }

    public HeavyAttackAnimation(float f, float f1, float f2, float f3, float f4, @Nullable Collider collider, Joint joint, String s, Armature armature) {
        super(f, f1, f2, f3, f4, collider, joint, s, armature);
        this.init();
        this.addProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, true);
        this.addProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL, false);
        this.addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, Animations.ReusableSources.COMBO_ATTACK_DIRECTION_MODIFIER);
    }

    public HeavyAttackAnimation(float f, float f1, float f2, float f3, InteractionHand interactionhand, @Nullable Collider collider, Joint joint, String s, Armature armature) {
        super(f, f1, f1, f2, f3, interactionhand, collider, joint, s, armature);
        this.init();
        this.addProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, true);
        this.addProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL, false);
        this.addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, Animations.ReusableSources.COMBO_ATTACK_DIRECTION_MODIFIER);
    }

    public HeavyAttackAnimation(float f, String s, Armature armature, AttackAnimation.Phase ... aphase) {
        super(f, s, armature, aphase);
        this.init();
        this.addProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, true);
        this.addProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL, false);
        this.addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, Animations.ReusableSources.COMBO_ATTACK_DIRECTION_MODIFIER);
    }

    protected void bindPhaseState(AttackAnimation.Phase phase) {
        float f = phase.preDelay;
        if (f == 0.0f) {
            f += 0.01f;
        }
        this.stateSpectrumBlueprint.newTimePair(phase.start, f).addState(EntityState.PHASE_LEVEL, (Object)1).newTimePair(phase.start, phase.contact + 0.01f).addState(EntityState.CAN_SKILL_EXECUTION, (Object)false).newTimePair(phase.start, phase.recovery).addState(EntityState.MOVEMENT_LOCKED, (Object)true).addState(EntityState.UPDATE_LIVING_MOTION, (Object)false).addState(EntityState.CAN_BASIC_ATTACK, (Object)false).newTimePair(phase.start, phase.end).addState(EntityState.INACTION, (Object)true).newTimePair(f, phase.contact + 0.01f).addState(EntityState.ATTACKING, (Object)true).addState(EntityState.PHASE_LEVEL, (Object)2).newTimePair(phase.contact + 0.01f, phase.end).addState(EntityState.PHASE_LEVEL, (Object)3).addState(EntityState.TURNING_LOCKED, (Object)true);
    }

    public void end(LivingEntityPatch<?> livingentitypatch, DynamicAnimation dynamicanimation, boolean flag) {
        super.end(livingentitypatch, dynamicanimation, flag);
        boolean flag1 = ((GameRules.BooleanValue)((LivingEntity)livingentitypatch.getOriginal()).m_9236_().m_46469_().m_46170_(EpicFightGamerules.STIFF_COMBO_ATTACKS)).m_46223_();
        if (!flag && !dynamicanimation.isMainFrameAnimation() && livingentitypatch.isLogicalClient() && !flag1) {
            float f = 0.05f * this.getPlaySpeed(livingentitypatch, dynamicanimation);
            livingentitypatch.getClientAnimator().baseLayer.copyLayerTo(livingentitypatch.getClientAnimator().baseLayer.getLayer(Layer.Priority.HIGHEST), f);
        }
    }

    public TypeFlexibleHashMap<EntityState.StateFactor<?>> getStatesMap(LivingEntityPatch<?> livingentitypatch, float f) {
        TypeFlexibleHashMap typeflexiblehashmap = super.getStatesMap(livingentitypatch, f);
        if (!((GameRules.BooleanValue)((LivingEntity)livingentitypatch.getOriginal()).m_9236_().m_46469_().m_46170_(EpicFightGamerules.STIFF_COMBO_ATTACKS)).m_46223_()) {
            typeflexiblehashmap.put((Object)EntityState.MOVEMENT_LOCKED, Optional.of(false));
            typeflexiblehashmap.put((Object)EntityState.UPDATE_LIVING_MOTION, Optional.of(true));
        }
        return typeflexiblehashmap;
    }

    protected Vec3 getCoordVector(LivingEntityPatch<?> livingentitypatch, DynamicAnimation dynamicanimation) {
        Vec3 vec3 = super.getCoordVector(livingentitypatch, dynamicanimation);
        if (livingentitypatch.shouldBlockMoving() && this.getProperty((AnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE).orElse(false).booleanValue()) {
            vec3 = vec3.m_82490_(0.0);
        }
        return vec3;
    }

    public boolean isBasicAttackAnimation() {
        return true;
    }

    public boolean shouldPlayerMove(LocalPlayerPatch localplayerpatch) {
        return !localplayerpatch.isLogicalClient() || ((GameRules.BooleanValue)((LocalPlayer)localplayerpatch.getOriginal()).m_9236_().m_46469_().m_46170_(EpicFightGamerules.STIFF_COMBO_ATTACKS)).m_46223_() || ((LocalPlayer)localplayerpatch.getOriginal()).f_108618_.f_108567_ == 0.0f && ((LocalPlayer)localplayerpatch.getOriginal()).f_108618_.f_108566_ == 0.0f;
    }
}

