/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.compat.efdg.animation;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.property.MoveCoordFunctions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.JointMask;
import yesman.epicfight.api.client.animation.property.JointMaskEntry;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.api.utils.datastruct.TypeFlexibleHashMap;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.HurtableEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.DealtDamageEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.gamerule.EpicFightGamerules;

public class BasicMultipleAttackAnimation
extends AttackAnimation {
    void init() {
        if (!this.properties.containsKey(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED)) {
            float f = Float.parseFloat(String.format(Locale.US, "%.2f", Float.valueOf(1.0f / this.getTotalTime())));
            this.addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, Float.valueOf(f));
        }
        if (FMLEnvironment.dist == Dist.CLIENT) {
            HashSet<JointMask> jointMaskSet = new HashSet<JointMask>();
            jointMaskSet.add(JointMask.of((String)"Root", (JointMask.BindModifier)JointMask.KEEP_CHILD_LOCROT));
            jointMaskSet.add(JointMask.of((String)"Torso"));
            jointMaskSet.add(JointMask.of((String)"Chest"));
            jointMaskSet.add(JointMask.of((String)"Head"));
            jointMaskSet.add(JointMask.of((String)"Shoulder_R"));
            jointMaskSet.add(JointMask.of((String)"Arm_R"));
            jointMaskSet.add(JointMask.of((String)"Hand_R"));
            jointMaskSet.add(JointMask.of((String)"Elbow_R"));
            jointMaskSet.add(JointMask.of((String)"Tool_R"));
            jointMaskSet.add(JointMask.of((String)"Shoulder_L"));
            jointMaskSet.add(JointMask.of((String)"Arm_L"));
            jointMaskSet.add(JointMask.of((String)"Hand_L"));
            jointMaskSet.add(JointMask.of((String)"Elbow_L"));
            jointMaskSet.add(JointMask.of((String)"Tool_L"));
            jointMaskSet.add(JointMask.of((String)"Thigh_R"));
            jointMaskSet.add(JointMask.of((String)"Leg_R"));
            jointMaskSet.add(JointMask.of((String)"Knee_R"));
            jointMaskSet.add(JointMask.of((String)"Thigh_L"));
            jointMaskSet.add(JointMask.of((String)"Leg_L"));
            jointMaskSet.add(JointMask.of((String)"Knee_L"));
            JointMaskEntry jointMaskEntry = JointMaskEntry.builder().defaultMask(JointMask.JointMaskSet.of(jointMaskSet)).create();
            this.addProperty(ClientAnimationProperties.JOINT_MASK, jointMaskEntry);
        }
    }

    public BasicMultipleAttackAnimation(float f, float f1, float f2, float f3, @Nullable Collider collider, Joint joint, String s, Armature armature) {
        this(f, f1, f1, f2, f3, collider, joint, s, armature);
    }

    public BasicMultipleAttackAnimation(float f, float f1, float f2, float f3, float f4, @Nullable Collider collider, Joint joint, String s, Armature armature) {
        this(f, s, armature, new AttackAnimation.Phase(0.0f, f1, f2, f3, f4, Float.MAX_VALUE, joint, collider));
    }

    public BasicMultipleAttackAnimation(float f, float f1, float f2, float f3, InteractionHand interactionhand, @Nullable Collider collider, Joint joint, String s, Armature armature) {
        this(f, s, armature, new AttackAnimation.Phase(0.0f, f1, f1, f2, f3, Float.MAX_VALUE, interactionhand, joint, collider));
    }

    public BasicMultipleAttackAnimation(float f, String s, Armature armature, boolean flag, AttackAnimation.Phase ... aphase) {
        super(f, s, armature, aphase);
        this.init();
    }

    public BasicMultipleAttackAnimation(float f, String s, Armature armature, AttackAnimation.Phase ... aphase) {
        super(f, s, armature, aphase);
        this.init();
        this.newTimePair(0.0f, Float.MAX_VALUE);
        this.addStateRemoveOld(EntityState.TURNING_LOCKED, false);
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN, MoveCoordFunctions.TRACE_LOC_TARGET);
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, (dynamicanimation, livingentitypatch, transformsheet) -> {
            LivingEntity livingentity = livingentitypatch.getTarget();
            if (!dynamicanimation.getRealAnimation().getProperty((AnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE).orElse(false).booleanValue() && livingentity != null) {
                TransformSheet transformsheet1 = ((TransformSheet)dynamicanimation.getTransfroms().get("Root")).copyAll();
                Keyframe[] akeyframe = transformsheet1.getKeyframes();
                int b0 = 0;
                int i = transformsheet1.getKeyframes().length - 1;
                Vec3f vec3f = akeyframe[i].transform().translation();
                Vec3 vec3 = ((LivingEntity)livingentitypatch.getOriginal()).m_146892_();
                Vec3 vec31 = livingentity.m_20182_();
                float f1 = Math.max((float)vec31.m_82546_(vec3).m_165924_() * 1.75f - (livingentity.m_20205_() + ((LivingEntity)livingentitypatch.getOriginal()).m_20205_()) * 0.75f, 0.0f);
                Vec3f vec3f1 = new Vec3f(vec3f.x, 0.0f, -f1);
                float f2 = Math.min(vec3f1.length() / vec3f.length(), 2.0f);
                for (int j = b0; j <= i; ++j) {
                    Vec3f vec3f2 = akeyframe[j].transform().translation();
                    vec3f2.z *= f2;
                }
                transformsheet.readFrom(transformsheet1);
            } else {
                transformsheet.readFrom((TransformSheet)dynamicanimation.getTransfroms().get("Root"));
            }
        });
    }

    protected void hurtCollidingEntities(LivingEntityPatch<?> livingentitypatch, float f, float f1, EntityState entitystate, EntityState entitystate1, AttackAnimation.Phase phase) {
        LivingEntity livingentity = (LivingEntity)livingentitypatch.getOriginal();
        livingentitypatch.getArmature().getRootJoint().initOriginTransform(new OpenMatrix4f());
        float f2 = entitystate.attacking() ? f : phase.preDelay;
        float f3 = entitystate1.attacking() ? f1 : phase.contact;
        List list = this.getPhaseByTime(f1).getCollidingEntities(livingentitypatch, (AttackAnimation)this, f2, f3, this.getPlaySpeed(livingentitypatch, (DynamicAnimation)this));
        if (list.size() > 0) {
            HitEntityList hitentitylist = new HitEntityList(livingentitypatch, list, phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_PRIORITY).orElse(HitEntityList.Priority.DISTANCE));
            int i = this.getMaxStrikes(livingentitypatch, phase);
            while (livingentitypatch.getCurrenltyHurtEntities().size() < i && hitentitylist.next()) {
                Entity entity = hitentitylist.getEntity();
                LivingEntity livingentity1 = this.getTrueEntity(entity);
                if (livingentity1 == null || !livingentity1.m_6084_() || livingentitypatch.getCurrenltyAttackedEntities().contains(livingentity1) || livingentitypatch.isTeammate(entity) || !(entity instanceof LivingEntity) && !(entity instanceof PartEntity) || !livingentity.m_142582_(entity)) continue;
                HurtableEntityPatch hurtableentitypatch = (HurtableEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, HurtableEntityPatch.class);
                if (hurtableentitypatch == null) break;
                EpicFightDamageSource epicfightdamagesource = this.getEpicFightDamageSource(livingentitypatch, entity, phase);
                float f4 = 1.0f;
                if (hurtableentitypatch != null) {
                    if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).isPresent()) {
                        if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.NONE) {
                            if (livingentity1 instanceof Player) {
                                epicfightdamagesource.setStunType(StunType.LONG);
                                epicfightdamagesource.setImpact(epicfightdamagesource.getImpact() * 5.0f);
                            } else {
                                epicfightdamagesource.setStunType(StunType.NONE);
                            }
                        } else if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.HOLD && ((LivingEntity)hurtableentitypatch.getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                            epicfightdamagesource.setStunType(StunType.NONE);
                        } else if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.FALL && ((LivingEntity)hurtableentitypatch.getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                            epicfightdamagesource.setStunType(StunType.NONE);
                        } else {
                            epicfightdamagesource = this.getEpicFightDamageSource(livingentitypatch, entity, phase);
                        }
                    } else {
                        epicfightdamagesource = this.getEpicFightDamageSource(livingentitypatch, entity, phase);
                    }
                    String s = "anti_stunlock:" + f4 + ":" + entity.f_19797_ + ":" + this.getId() + "-" + phase.contact;
                    if (hurtableentitypatch.isStunned()) {
                        for (String s1 : entity.m_19880_()) {
                            if (!s1.contains("anti_stunlock:")) continue;
                            f4 = this.applyAntiStunLock(entity, f4, epicfightdamagesource, phase, s1, s);
                            break;
                        }
                    } else {
                        boolean flag = true;
                        for (String s2 : entity.m_19880_()) {
                            if (!s2.contains("anti_stunlock:")) continue;
                            if ((float)entity.f_19797_ - Float.valueOf(s2.split(":")[2]).floatValue() > 20.0f) {
                                f4 = 1.0f;
                                break;
                            }
                            f4 = this.applyAntiStunLock(entity, f4, epicfightdamagesource, phase, s2, s);
                            flag = false;
                            break;
                        }
                        if (flag) {
                            int j = 0;
                            while (j < entity.m_19880_().size()) {
                                if (((String)entity.m_19880_().toArray()[j]).contains("anti_stunlock:")) {
                                    entity.m_19880_().remove(entity.m_19880_().toArray()[j]);
                                    continue;
                                }
                                ++j;
                            }
                            entity.m_20049_(s);
                        }
                    }
                    float f5 = entity instanceof Player ? 0.3f : 0.2f;
                    if (f4 < f5) {
                        for (String s1 : entity.m_19880_()) {
                            if (!s1.contains("anti_stunlock:")) continue;
                            entity.m_20137_(s1);
                            break;
                        }
                        epicfightdamagesource.setStunType(StunType.KNOCKDOWN);
                    }
                    epicfightdamagesource.setImpact(epicfightdamagesource.getImpact() * f4);
                }
                int k = entity.f_19802_;
                entity.f_19802_ = 0;
                AttackResult attackresult = livingentitypatch.attack(epicfightdamagesource, entity, phase.hand);
                entity.f_19802_ = k;
                if (attackresult.resultType.dealtDamage()) {
                    if (livingentitypatch instanceof ServerPlayerPatch) {
                        ServerPlayerPatch serverplayerpatch = (ServerPlayerPatch)livingentitypatch;
                        LivingDamageEvent damageEvent = new LivingDamageEvent(livingentity1, (DamageSource)epicfightdamagesource, attackresult.damage);
                        serverplayerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_DAMAGE, (PlayerEvent)new DealtDamageEvent.Damage(serverplayerpatch, livingentity1, epicfightdamagesource, damageEvent));
                    }
                    if (epicfightdamagesource.getStunType() == StunType.KNOCKDOWN) {
                        ((LivingEntity)hurtableentitypatch.getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 60, 0, true, false, false));
                    }
                    entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.getHitSound(livingentitypatch, phase), entity.m_5720_(), 1.0f, 1.0f);
                    this.spawnHitParticle((ServerLevel)entity.m_9236_(), livingentitypatch, entity, phase);
                    if (hurtableentitypatch != null && phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).isPresent() && !((LivingEntity)hurtableentitypatch.getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                        if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.NONE && !(livingentity1 instanceof Player)) {
                            float f5 = (float)((double)(epicfightdamagesource.getImpact() * f4 * 0.2f) * (1.0 - livingentity1.m_21133_(Attributes.f_22278_)));
                            if (((LivingEntity)hurtableentitypatch.getOriginal()).m_6084_()) {
                                hurtableentitypatch.applyStun(f4 > 0.3f ? StunType.LONG : StunType.KNOCKDOWN, f5);
                                float f6 = epicfightdamagesource.getImpact() / f4 * 0.25f;
                                double d0 = livingentity.m_20185_() - entity.m_20185_();
                                double d1 = livingentity.m_20189_() - entity.m_20189_();
                                while (d0 * d0 + d1 * d1 < 1.0E-4) {
                                    d0 = (Math.random() - Math.random()) * 0.01;
                                    d1 = (Math.random() - Math.random()) * 0.01;
                                }
                                if (!(livingentity1 instanceof Player)) {
                                    f6 = (float)((double)f6 * (1.0 - livingentity1.m_21133_(Attributes.f_22278_)));
                                }
                                if ((double)f6 > 0.0) {
                                    entity.f_19812_ = true;
                                    Vec3 vec3 = entity.m_20184_();
                                    Vec3 vec31 = new Vec3(d0, 0.0, d1).m_82541_().m_82490_((double)f6);
                                    entity.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, entity.m_20096_() ? Math.min(0.4, vec3.f_82480_ / 2.0) : vec3.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
                                }
                            }
                        }
                        if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.FALL) {
                            float f5 = (float)((double)(epicfightdamagesource.getImpact() * 0.4f) * (1.0 - livingentity1.m_21133_(Attributes.f_22278_)));
                            if (((LivingEntity)hurtableentitypatch.getOriginal()).m_6084_()) {
                                hurtableentitypatch.applyStun(f4 > 0.3f ? StunType.SHORT : StunType.KNOCKDOWN, f5);
                                double d2 = epicfightdamagesource.getImpact() / f4 * 0.25f;
                                double d3 = livingentity.m_20185_() - entity.m_20185_();
                                double d4 = livingentity.m_20186_() - 8.0 - entity.m_20186_();
                                double d5 = livingentity.m_20189_() - entity.m_20189_();
                                while (d3 * d3 + d5 * d5 < 1.0E-4) {
                                    d3 = (Math.random() - Math.random()) * 0.01;
                                    d5 = (Math.random() - Math.random()) * 0.01;
                                }
                                if (!(livingentity1 instanceof Player)) {
                                    d2 *= 1.0 - livingentity1.m_21133_(Attributes.f_22278_);
                                }
                                if (d2 > 0.0) {
                                    entity.f_19812_ = true;
                                    Vec3 vec32 = livingentity.m_20184_();
                                    Vec3 vec33 = new Vec3(d3, d4, d5).m_82541_().m_82490_(d2);
                                    entity.m_20334_(vec32.f_82479_ / 2.0 - vec33.f_82479_, vec32.f_82480_ / 2.0 - vec33.f_82480_, vec32.f_82481_ / 2.0 - vec33.f_82481_);
                                }
                                if (livingentity1 instanceof Player) {
                                    livingentity1.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 5, (int)(d2 * 4.0 * 6.0), true, false, false));
                                }
                            }
                        }
                    }
                }
                livingentitypatch.getCurrenltyAttackedEntities().add(livingentity1);
                if (!attackresult.resultType.shouldCount()) continue;
                livingentitypatch.getCurrenltyHurtEntities().add(livingentity1);
            }
        }
    }

    public void end(LivingEntityPatch<?> livingentitypatch, DynamicAnimation dynamicanimation, boolean flag) {
        super.end(livingentitypatch, dynamicanimation, flag);
        boolean flag1 = ((GameRules.BooleanValue)((LivingEntity)livingentitypatch.getOriginal()).m_9236_().m_46469_().m_46170_(EpicFightGamerules.STIFF_COMBO_ATTACKS)).m_46223_();
        if (!flag && !dynamicanimation.isMainFrameAnimation() && livingentitypatch.isLogicalClient() && !flag1) {
            float f = 0.05f * this.getPlaySpeed(livingentitypatch, dynamicanimation);
            livingentitypatch.getClientAnimator().baseLayer.copyLayerTo(livingentitypatch.getClientAnimator().baseLayer.getLayer(Layer.Priority.HIGHEST), f);
        }
    }

    public TypeFlexibleHashMap<EntityState.StateFactor<?>> getStatesMap(LivingEntityPatch<?> livingentitypatch, float f) {
        TypeFlexibleHashMap typeflexiblehashmap = super.getStatesMap(livingentitypatch, f);
        if (!((GameRules.BooleanValue)((LivingEntity)livingentitypatch.getOriginal()).m_9236_().m_46469_().m_46170_(EpicFightGamerules.STIFF_COMBO_ATTACKS)).m_46223_()) {
            typeflexiblehashmap.put((Object)EntityState.MOVEMENT_LOCKED, Optional.of(false));
        }
        return typeflexiblehashmap;
    }

    public Vec3 getCoordVector(LivingEntityPatch<?> livingentitypatch, DynamicAnimation dynamicanimation) {
        Vec3 vec3 = super.getCoordVector(livingentitypatch, dynamicanimation);
        if (livingentitypatch.shouldBlockMoving() && this.getProperty((AnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE).orElse(false).booleanValue()) {
            vec3 = vec3.m_82490_(0.0);
        }
        return vec3;
    }

    public boolean isBasicAttackAnimation() {
        return true;
    }

    public float applyAntiStunLock(Entity entity, float f, EpicFightDamageSource epicfightdamagesource, AttackAnimation.Phase phase, String s, String s1) {
        int b0;
        int i;
        boolean flag = false;
        if (entity.m_9236_().m_8055_(new BlockPos(new Vec3i((int)entity.m_20185_(), (int)entity.m_20186_() - 1, (int)entity.m_20189_()))).m_60795_() && epicfightdamagesource.getStunType() != StunType.FALL) {
            s2 = String.valueOf(this.getId());
            s3 = s2 + "-" + String.valueOf(phase.contact);
            if (s.split(":").length > 3) {
                if (String.valueOf(this.getId()).equals(s.split(":")[3].split("-")[0]) && !String.valueOf(phase.contact).equals(s.split(":")[3].split("-")[1])) {
                    f = Float.valueOf(s.split(":")[1]).floatValue() * 0.98f;
                    flag = true;
                } else {
                    f = Float.valueOf(s.split(":")[1]).floatValue() * 0.9f;
                    flag = false;
                }
            }
            for (i = 3; i < s.split(":").length && i < 7; ++i) {
                if (!s.split(":")[i].equals(s3)) continue;
                f *= 0.6f;
            }
        } else {
            s2 = String.valueOf(this.getId());
            s3 = s2 + "-" + String.valueOf(phase.contact);
            if (s.split(":").length > 3) {
                if (String.valueOf(this.getId()).equals(s.split(":")[3].split("-")[0]) && !String.valueOf(phase.contact).equals(s.split(":")[3].split("-")[1])) {
                    f = Float.valueOf(s.split(":")[1]).floatValue() * 0.98f;
                    flag = true;
                } else {
                    f = Float.valueOf(s.split(":")[1]).floatValue() * 0.8f;
                    flag = false;
                }
            }
            for (i = 3; i < s.split(":").length && i < 5; ++i) {
                if (!s.split(":")[i].equals(s3)) continue;
                f *= 0.6f;
            }
        }
        entity.m_20137_(s);
        boolean flag1 = true;
        if (flag) {
            s1 = "anti_stunlock:" + f + ":" + entity.f_19797_;
            b0 = 6;
        } else {
            s1 = "anti_stunlock:" + f + ":" + entity.f_19797_ + ":" + this.getId() + "-" + phase.contact;
            b0 = 5;
        }
        for (i = 3; i < s.split(":").length && i < b0; ++i) {
            s1 = ((String)s1).concat(":" + s.split(":")[i]);
        }
        entity.m_20049_((String)s1);
        return f;
    }
}

