/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.annoyingvillagers.AnnoyingVillagers;
import com.pla.annoyingvillagers.config.AnnoyingVillagersConfig;
import com.pla.annoyingvillagers.entity.AlexDeadEntity;
import com.pla.annoyingvillagers.entity.JevEntity;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModEntities;
import com.pla.annoyingvillagers.procedures.AlexOnDeathProcedure;
import com.pla.annoyingvillagers.procedures.AlexOnHurtProcedure;
import com.pla.annoyingvillagers.procedures.AlexOnSpawnProcedure;
import com.pla.annoyingvillagers.procedures.AlexOnTickProcedure;
import com.pla.annoyingvillagers.util.CommonGoals;
import com.pla.annoyingvillagers.util.PathfinderMobInventory;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class AlexEntity
extends PathfinderMobInventory {
    private JevEntity jevToProtect;
    private UUID jevUUID;
    private boolean jevDeathMessageSent = false;
    private boolean spawnJev = false;

    public void setProtectingJev(JevEntity jev) {
        this.jevToProtect = jev;
    }

    public void setJevUUID(UUID jevUUID) {
        this.jevUUID = jevUUID;
    }

    public AlexEntity(PlayMessages.SpawnEntity spawnentity, Level level) {
        this((EntityType<AlexEntity>)((EntityType)AnnoyingVillagersModEntities.ALEX.get()), level);
    }

    public AlexEntity(EntityType<AlexEntity> entitytype, Level level) {
        super(entitytype, level);
        this.m_274367_(2.8f);
        this.f_21364_ = 60;
        this.m_21557_(false);
        this.m_6593_((Component)Component.m_237113_((String)"Alex"));
        this.m_20340_(true);
        this.m_21530_();
        ItemStack sword = new ItemStack((ItemLike)Items.f_42388_);
        sword.m_41663_(Enchantments.f_44977_, 5);
        sword.m_41663_(Enchantments.f_44981_, 2);
        sword.m_41663_(Enchantments.f_44980_, 2);
        sword.m_41663_(Enchantments.f_44986_, 5);
        this.m_8061_(EquipmentSlot.MAINHAND, sword);
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42584_));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, target -> this.jevToProtect != null && this.jevToProtect.m_6084_() && target != null && target.m_21214_() == this.jevToProtect));
        CommonGoals.registerGoalForNeutralNpc(this);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.jevUUID != null) {
            tag.m_128362_("JevUUID", this.jevUUID);
        }
        tag.m_128379_("JevDeathMessageSent", this.jevDeathMessageSent);
        tag.m_128379_("SpawnJev", this.spawnJev);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("JevUUID")) {
            this.jevUUID = tag.m_128342_("JevUUID");
        }
        this.jevDeathMessageSent = tag.m_128471_("JevDeathMessageSent");
        this.spawnJev = tag.m_128471_("SpawnJev");
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double d0) {
        return false;
    }

    public double m_6049_() {
        return -0.35;
    }

    public SoundEvent m_7975_(DamageSource damagesource) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean m_6469_(DamageSource damagesource, float f) {
        AlexOnHurtProcedure.execute((LevelAccessor)this.m_9236_(), (Entity)this, damagesource.m_7639_());
        if (damagesource.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268526_)) {
            return false;
        }
        return super.m_6469_(damagesource, f);
    }

    public void m_6667_(DamageSource damagesource) {
        super.m_6667_(damagesource);
        AlexOnDeathProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel levelaccessor = (ServerLevel)level;
            if (((Boolean)AnnoyingVillagersConfig.PHYSIC_MOD_COMPAT.get()).booleanValue()) {
                ServerLevel serverlevel = levelaccessor;
                AlexDeadEntity alexdeadentity = new AlexDeadEntity((EntityType<AlexDeadEntity>)((EntityType)AnnoyingVillagersModEntities.ALEX_DEAD.get()), (Level)serverlevel);
                alexdeadentity.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), levelaccessor.m_213780_().m_188501_() * 360.0f, 0.0f);
                if (alexdeadentity instanceof Mob) {
                    AlexDeadEntity mob = alexdeadentity;
                    mob.m_6518_((ServerLevelAccessor)serverlevel, levelaccessor.m_6436_(alexdeadentity.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                }
                this.m_142687_(Entity.RemovalReason.KILLED);
                levelaccessor.m_7967_((Entity)alexdeadentity);
                try {
                    alexdeadentity.m_20194_().m_129892_().m_82094_().execute("kill @s", (Object)alexdeadentity.m_20203_().m_81324_().m_81325_(4));
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
    }

    private void spawnJev() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel levelaccessor;
            ServerLevel serverlevel = levelaccessor = (ServerLevel)level;
            JevEntity jevEntity = new JevEntity((EntityType<JevEntity>)((EntityType)AnnoyingVillagersModEntities.JEV.get()), (Level)serverlevel);
            jevEntity.m_7678_(this.m_20185_() + Mth.m_216263_((RandomSource)AnnoyingVillagers.randomSource, (double)1.0, (double)10.0), this.m_20186_() + Mth.m_216263_((RandomSource)AnnoyingVillagers.randomSource, (double)1.0, (double)10.0), this.m_20189_() + Mth.m_216263_((RandomSource)AnnoyingVillagers.randomSource, (double)1.0, (double)10.0), levelaccessor.m_213780_().m_188501_() * 360.0f, 0.0f);
            jevEntity.setFollowTarget(this);
            jevEntity.setFollowTargetUUID(this.m_20148_());
            jevEntity.m_6518_((ServerLevelAccessor)levelaccessor, levelaccessor.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            levelaccessor.m_7967_((Entity)jevEntity);
            this.setJevUUID(jevEntity.m_20148_());
            this.setProtectingJev(jevEntity);
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverlevelaccessor, DifficultyInstance difficultyinstance, MobSpawnType mobspawntype, @Nullable SpawnGroupData spawngroupdata, @Nullable CompoundTag compoundtag) {
        SpawnGroupData spawngroupdata1 = super.m_6518_(serverlevelaccessor, difficultyinstance, mobspawntype, spawngroupdata, compoundtag);
        AlexOnSpawnProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        return spawngroupdata1;
    }

    public void m_5993_(Entity entity, int i, DamageSource damagesource) {
        super.m_5993_(entity, i, damagesource);
        if (entity != null && Math.random() < 0.2 && !entity.m_9236_().m_5776_() && entity.m_20194_() != null) {
            try {
                entity.m_20194_().m_129892_().m_82094_().execute("tellraw @a {\"text\":\"<Alex> Hah, a loser beneath me\"}", (Object)entity.m_20203_().m_81324_().m_81325_(4));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
    }

    public void m_6075_() {
        super.m_6075_();
        AlexOnTickProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            JevEntity jev;
            if (!this.spawnJev) {
                this.spawnJev = true;
                this.spawnJev();
            }
            if (this.jevToProtect == null && this.jevUUID != null) {
                Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(this.jevUUID);
                if (entity instanceof JevEntity) {
                    this.jevToProtect = jev = (JevEntity)entity;
                } else {
                    this.jevUUID = null;
                }
            }
            if (this.jevToProtect != null && !this.jevToProtect.m_6084_()) {
                if (!this.jevDeathMessageSent) {
                    this.jevDeathMessageSent = true;
                    jev = this.m_9236_();
                    if (jev instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)jev;
                        String[] JEV_DEATH_LINES = new String[]{"Jev...? Jev!? No... please no...", "Not you too, Jev...", "They killed him... They actually killed Jev...", "I told you to stay back, Jev...", "You idiot... you weren't supposed to die...", "Damn it, Jev... you were all I had left...", "Rest now, Jev... I'll handle this.", "Heh... even in death, you're still loyal, Jev...", "They\u2019ll pay for this... I swear it, Jev"};
                        String message = JEV_DEATH_LINES[this.m_9236_().m_213780_().m_188503_(JEV_DEATH_LINES.length)];
                        serverLevel.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)("<Alex> " + message)), false);
                    }
                }
                this.jevToProtect = null;
                this.jevUUID = null;
            }
        }
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)AnnoyingVillagersModEntities.ALEX.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entitytype, serverlevelaccessor, mobspawntype, blockpos, random) -> serverlevelaccessor.m_45524_(blockpos, 0) > 8);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 50.0);
        builder = builder.m_22268_(Attributes.f_22284_, 20.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        builder = builder.m_22268_(Attributes.f_22278_, 5.0);
        return builder;
    }
}

