/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.annoyingvillagers.config.AnnoyingVillagersConfig;
import com.pla.annoyingvillagers.entity.SteveDeadEntity;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModEntities;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModItems;
import com.pla.annoyingvillagers.procedures.AngrySteveOnDeathProcedure;
import com.pla.annoyingvillagers.procedures.AngrySteveOnHurtProcedure;
import com.pla.annoyingvillagers.procedures.AngrySteveOnKillProcedure;
import com.pla.annoyingvillagers.procedures.AngrySteveOnSpawnProcedure;
import com.pla.annoyingvillagers.procedures.AngrySteveOnTickProcedure;
import com.pla.annoyingvillagers.util.CommonGoals;
import com.pla.annoyingvillagers.util.PathfinderMobInventory;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class AngrySteveEntity
extends PathfinderMobInventory {
    public AngrySteveEntity(PlayMessages.SpawnEntity spawnentity, Level level) {
        this((EntityType<AngrySteveEntity>)((EntityType)AnnoyingVillagersModEntities.ANGRY_STEVE.get()), level);
    }

    public AngrySteveEntity(EntityType<AngrySteveEntity> entitytype, Level level) {
        super(entitytype, level);
        this.m_274367_(3.0f);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_6593_((Component)Component.m_237113_((String)"Steve"));
        this.m_20340_(true);
        this.m_21530_();
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)AnnoyingVillagersModItems.LEGENDARY_SWORD_MOB.get()));
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42584_));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        CommonGoals.registerGoalForCrazyNpc(this);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double d0) {
        return false;
    }

    public double m_6049_() {
        return -0.35;
    }

    public SoundEvent m_7975_(DamageSource damagesource) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean m_6469_(DamageSource damagesource, float f) {
        AngrySteveOnHurtProcedure.execute((LevelAccessor)this.m_9236_(), (Entity)this, damagesource.m_7639_());
        if (damagesource.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268714_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        return super.m_6469_(damagesource, f);
    }

    public void m_6667_(DamageSource damagesource) {
        super.m_6667_(damagesource);
        AngrySteveOnDeathProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        double posX = this.m_20185_();
        double posY = this.m_20186_();
        double posZ = this.m_20189_();
        Level levelAccessor = this.m_9236_();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel levelaccessor = (ServerLevel)levelAccessor;
            if (((Boolean)AnnoyingVillagersConfig.PHYSIC_MOD_COMPAT.get()).booleanValue()) {
                ServerLevel serverlevel = levelaccessor;
                SteveDeadEntity steveDeadEntity = new SteveDeadEntity((EntityType<SteveDeadEntity>)((EntityType)AnnoyingVillagersModEntities.STEVE_DEAD.get()), (Level)serverlevel);
                steveDeadEntity.m_7678_(posX, posY, posZ, levelaccessor.m_213780_().m_188501_() * 360.0f, 0.0f);
                if (steveDeadEntity instanceof Mob) {
                    SteveDeadEntity mob = steveDeadEntity;
                    mob.m_6518_((ServerLevelAccessor)serverlevel, levelaccessor.m_6436_(steveDeadEntity.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                }
                this.m_142687_(Entity.RemovalReason.KILLED);
                levelaccessor.m_7967_((Entity)steveDeadEntity);
                try {
                    steveDeadEntity.m_20194_().m_129892_().m_82094_().execute("kill @s", (Object)steveDeadEntity.m_20203_().m_81324_().m_81325_(4));
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverlevelaccessor, DifficultyInstance difficultyinstance, MobSpawnType mobspawntype, @Nullable SpawnGroupData spawngroupdata, @Nullable CompoundTag compoundtag) {
        SpawnGroupData spawngroupdata1 = super.m_6518_(serverlevelaccessor, difficultyinstance, mobspawntype, spawngroupdata, compoundtag);
        AngrySteveOnSpawnProcedure.execute((LevelAccessor)serverlevelaccessor, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        return spawngroupdata1;
    }

    public void m_5993_(Entity entity, int i, DamageSource damagesource) {
        super.m_5993_(entity, i, damagesource);
        AngrySteveOnKillProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public void m_6075_() {
        super.m_6075_();
        AngrySteveOnTickProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.26);
        builder = builder.m_22268_(Attributes.f_22276_, 120.0);
        builder = builder.m_22268_(Attributes.f_22284_, 30.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 256.0);
        return builder;
    }
}

