/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.annoyingvillagers.AnnoyingVillagers;
import com.pla.annoyingvillagers.config.AnnoyingVillagersConfig;
import com.pla.annoyingvillagers.entity.BbqEntity;
import com.pla.annoyingvillagers.entity.BlueDemonDeadEntity;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModEntities;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModItems;
import com.pla.annoyingvillagers.procedures.BlueDemon2OnEntityDeathProcedure;
import com.pla.annoyingvillagers.procedures.BlueDemon2OnEntityInitialSpawnProcedure;
import com.pla.annoyingvillagers.procedures.BlueDemon2OnEntityUpdateProcedure;
import com.pla.annoyingvillagers.procedures.BlueDemon2ParryingProcedure;
import com.pla.annoyingvillagers.procedures.BlueDemonOnEntityKillOtherEntityProcedure;
import com.pla.annoyingvillagers.util.CommonGoals;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class BlueDemon2Entity
extends Monster {
    private BbqEntity bbqEntityToProtect;
    private UUID bbqUUID;
    private boolean spawnBbq = false;

    public void setProtectingBbq(BbqEntity bbqEntity) {
        this.bbqEntityToProtect = bbqEntity;
    }

    public void setBbqUUID(UUID bbqUUID) {
        this.bbqUUID = bbqUUID;
    }

    public BlueDemon2Entity(PlayMessages.SpawnEntity spawnentity, Level level) {
        this((EntityType<BlueDemon2Entity>)((EntityType)AnnoyingVillagersModEntities.BLUE_DEMON_2.get()), level);
    }

    public BlueDemon2Entity(EntityType<BlueDemon2Entity> entitytype, Level level) {
        super(entitytype, level);
        this.m_274367_(3.0f);
        this.f_21364_ = 400;
        this.m_21557_(false);
        this.m_6593_((Component)Component.m_237113_((String)"\u00a7bBlue Demon\u00a7r"));
        this.m_20340_(true);
        this.m_21530_();
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42713_));
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42584_));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)AnnoyingVillagersModItems.BLUE_DEMON_CHESTPLATE.get()));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, target -> this.bbqEntityToProtect != null && this.bbqEntityToProtect.m_6084_() && target != null && target.m_21214_() == this.bbqEntityToProtect));
        CommonGoals.registerGoalForBlueDemonNpc(this);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6785_(double d0) {
        return false;
    }

    public double m_6049_() {
        return -0.35;
    }

    public SoundEvent m_7975_(DamageSource damagesource) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft", "entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft", "entity.generic.death"));
    }

    public boolean m_6469_(DamageSource damagesource, float f) {
        BlueDemon2ParryingProcedure.execute((Entity)this);
        if (damagesource.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268714_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        return super.m_6469_(damagesource, f);
    }

    public boolean m_7301_(MobEffectInstance effect) {
        if (effect.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        return super.m_7301_(effect);
    }

    public void m_6667_(DamageSource damagesource) {
        super.m_6667_(damagesource);
        BlueDemon2OnEntityDeathProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        double posX = this.m_20185_();
        double posY = this.m_20186_();
        double posZ = this.m_20189_();
        Level levelAccessor = this.m_9236_();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel levelaccessor = (ServerLevel)levelAccessor;
            if (((Boolean)AnnoyingVillagersConfig.PHYSIC_MOD_COMPAT.get()).booleanValue()) {
                ServerLevel serverlevel = levelaccessor;
                BlueDemonDeadEntity deadEntity = new BlueDemonDeadEntity((EntityType<BlueDemonDeadEntity>)((EntityType)AnnoyingVillagersModEntities.BLUE_DEMON_DEAD.get()), (Level)serverlevel);
                deadEntity.m_7678_(posX, posY, posZ, levelaccessor.m_213780_().m_188501_() * 360.0f, 0.0f);
                if (deadEntity instanceof Mob) {
                    BlueDemonDeadEntity mob = deadEntity;
                    mob.m_6518_((ServerLevelAccessor)serverlevel, levelaccessor.m_6436_(deadEntity.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                }
                this.m_142687_(Entity.RemovalReason.KILLED);
                levelaccessor.m_7967_((Entity)deadEntity);
                try {
                    deadEntity.m_20194_().m_129892_().m_82094_().execute("kill @s", (Object)deadEntity.m_20203_().m_81324_().m_81325_(4));
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverlevelaccessor, DifficultyInstance difficultyinstance, MobSpawnType mobspawntype, @Nullable SpawnGroupData spawngroupdata, @Nullable CompoundTag compoundtag) {
        SpawnGroupData spawngroupdata1 = super.m_6518_(serverlevelaccessor, difficultyinstance, mobspawntype, spawngroupdata, compoundtag);
        BlueDemon2OnEntityInitialSpawnProcedure.execute((LevelAccessor)this.m_9236_(), (Entity)this);
        return spawngroupdata1;
    }

    public void m_5993_(Entity entity, int i, DamageSource damagesource) {
        super.m_5993_(entity, i, damagesource);
        BlueDemonOnEntityKillOtherEntityProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), entity);
    }

    public void m_6075_() {
        super.m_6075_();
        BlueDemon2OnEntityUpdateProcedure.execute((LevelAccessor)this.m_9236_(), (int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_(), (Entity)this);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.bbqUUID != null) {
            tag.m_128362_("BbqUUID", this.bbqUUID);
        }
        tag.m_128379_("SpawnBbq", this.spawnBbq);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("BbqUUID")) {
            this.bbqUUID = tag.m_128342_("BbqUUID");
        }
        this.spawnBbq = tag.m_128471_("SpawnBbq");
    }

    private void spawnBbq() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel levelaccessor;
            ServerLevel serverlevel = levelaccessor = (ServerLevel)level;
            BbqEntity bbqEntity = new BbqEntity((EntityType<BbqEntity>)((EntityType)AnnoyingVillagersModEntities.BBQ.get()), (Level)serverlevel);
            bbqEntity.m_7678_(this.m_20185_() + Mth.m_216263_((RandomSource)AnnoyingVillagers.randomSource, (double)1.0, (double)10.0), this.m_20186_() + Mth.m_216263_((RandomSource)AnnoyingVillagers.randomSource, (double)1.0, (double)10.0), this.m_20189_() + Mth.m_216263_((RandomSource)AnnoyingVillagers.randomSource, (double)1.0, (double)10.0), levelaccessor.m_213780_().m_188501_() * 360.0f, 0.0f);
            bbqEntity.setFollowTarget((Entity)this);
            bbqEntity.setFollowTargetUUID(this.m_20148_());
            bbqEntity.m_6518_((ServerLevelAccessor)levelaccessor, levelaccessor.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            levelaccessor.m_7967_((Entity)bbqEntity);
            this.setProtectingBbq(bbqEntity);
            this.setBbqUUID(bbqEntity.m_20148_());
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (!this.spawnBbq) {
                this.spawnBbq = true;
                this.spawnBbq();
            }
            if (this.bbqEntityToProtect == null && this.bbqUUID != null) {
                Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(this.bbqUUID);
                if (entity instanceof BbqEntity) {
                    BbqEntity bbqEntity;
                    this.bbqEntityToProtect = bbqEntity = (BbqEntity)entity;
                } else {
                    this.bbqUUID = null;
                }
            }
            if (this.bbqEntityToProtect != null && !this.bbqEntityToProtect.m_6084_()) {
                this.bbqEntityToProtect = null;
                this.bbqUUID = null;
            }
        }
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.4);
        builder = builder.m_22268_(Attributes.f_22276_, 40.0);
        builder = builder.m_22268_(Attributes.f_22284_, 1.0);
        builder = builder.m_22268_(Attributes.f_22281_, 7.0);
        builder = builder.m_22268_(Attributes.f_22277_, 126.0);
        return builder;
    }
}

