/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.mixin;

import com.pla.annoyingvillagers.compat.player_mobs.ModCapabilities;
import com.pla.annoyingvillagers.config.AnnoyingVillagersConfig;
import com.pla.annoyingvillagers.util.DelayedTask;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.items.ItemStackHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import se.gory_moon.player_mobs.entity.PlayerMobEntity;

@Mixin(value={PlayerMobEntity.class}, remap=true)
public class PlayerMobMixinRemapTrue {
    @Inject(method={"isBaby"}, at={@At(value="HEAD")}, cancellable=true)
    private void forceIsNotBaby(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)false);
    }

    @Inject(method={"setBaby"}, at={@At(value="HEAD")}, cancellable=true)
    private void blockSetBaby(boolean isChild, CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="RETURN")})
    private void teleportToSurfaceIfUnderground(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag, CallbackInfoReturnable<SpawnGroupData> cir) {
        ServerLevel level;
        PlayerMobEntity self = (PlayerMobEntity)this;
        if (reason == MobSpawnType.SPAWN_EGG) {
            return;
        }
        float spawnRate = ((Double)AnnoyingVillagersConfig.PLAYER_NPC_SPAWN_RATE.get()).floatValue();
        if (world instanceof ServerLevel && (level = (ServerLevel)world).m_46461_()) {
            int surfaceY;
            BlockPos pos;
            int currentY;
            float roll = world.m_213780_().m_188501_();
            if (roll < 1.0f - spawnRate) {
                self.m_146870_();
            } else if (roll < 1.0f - spawnRate + spawnRate / 2.0f && (currentY = (pos = self.m_20183_()).m_123342_()) < (surfaceY = world.m_5452_(Heightmap.Types.WORLD_SURFACE, pos).m_123342_()) - 5) {
                BlockPos surfacePos = new BlockPos(pos.m_123341_(), surfaceY, pos.m_123343_());
                if (!world.m_6018_().m_8055_(surfacePos).m_60713_(Blocks.f_49990_)) {
                    self.m_6034_((double)surfacePos.m_123341_() + 0.5, (double)surfacePos.m_123342_(), (double)surfacePos.m_123343_() + 0.5);
                } else {
                    int radius = 30;
                    block0: for (int dx = -30; dx <= 30; ++dx) {
                        for (int dz = -30; dz <= 30; ++dz) {
                            BlockPos candidateXZ = pos.m_7918_(dx, 0, dz);
                            int candidateY = world.m_5452_(Heightmap.Types.WORLD_SURFACE, candidateXZ).m_123342_();
                            BlockPos candidateSurface = new BlockPos(candidateXZ.m_123341_(), candidateY, candidateXZ.m_123343_());
                            if (world.m_6018_().m_8055_(candidateSurface).m_60713_(Blocks.f_49990_)) continue;
                            self.m_6034_((double)candidateSurface.m_123341_() + 0.5, (double)candidateSurface.m_123342_(), (double)candidateSurface.m_123343_() + 0.5);
                            continue block0;
                        }
                    }
                }
            }
        } else if (world.m_213780_().m_188501_() < 1.0f - spawnRate) {
            self.m_146870_();
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addInventorySaveData(CompoundTag compound, CallbackInfo ci) {
        PlayerMobEntity self = (PlayerMobEntity)this;
        self.getCapability(ModCapabilities.PLAYER_MOB_INVENTORY).ifPresent(cap -> compound.m_128365_("CustomInventory", (Tag)cap.getInventory().serializeNBT()));
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readInventorySaveData(CompoundTag compound, CallbackInfo ci) {
        PlayerMobEntity self = (PlayerMobEntity)this;
        self.getCapability(ModCapabilities.PLAYER_MOB_INVENTORY).ifPresent(cap -> cap.getInventory().deserializeNBT(compound.m_128469_("CustomInventory")));
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tickingInventory(CallbackInfo ci) {
        final PlayerMobEntity self = (PlayerMobEntity)this;
        if (!self.m_9236_().f_46443_ && self.f_19797_ % 20 == 0) {
            if (!self.m_6084_() || self.m_213877_() || self.m_9236_() == null) {
                return;
            }
            List items = self.m_9236_().m_45976_(ItemEntity.class, self.m_20191_().m_82400_(2.0));
            for (ItemEntity item : items) {
                if (item.m_32063_() || item.m_213877_()) continue;
                final ItemEntity itemEntity = item;
                if (!self.m_6084_() || self.m_213877_() || self.m_9236_() == null) {
                    return;
                }
                self.getCapability(ModCapabilities.PLAYER_MOB_INVENTORY).ifPresent(cap -> {
                    ItemStackHandler inv = cap.getInventory();
                    ItemStack stack = itemEntity.m_32055_();
                    ItemStack remaining = stack.m_41777_();
                    for (int i = 0; i < inv.getSlots() && !(remaining = inv.insertItem(i, remaining, false)).m_41619_(); ++i) {
                    }
                    if (remaining.m_41619_()) {
                        itemEntity.m_20334_((self.m_20185_() - itemEntity.m_20185_()) * 0.25, (self.m_20186_() + 1.0 - itemEntity.m_20186_()) * 0.25, (self.m_20189_() - itemEntity.m_20189_()) * 0.25);
                        itemEntity.m_32010_(0);
                        new DelayedTask(5){

                            @Override
                            public void run() {
                                if (!self.m_6084_() || self.m_213877_() || self.m_9236_() == null) {
                                    return;
                                }
                                itemEntity.m_146870_();
                                self.m_9236_().m_5594_(null, self.m_20183_(), SoundEvents.f_12019_, SoundSource.HOSTILE, 0.2f, 1.0f);
                            }
                        };
                    } else {
                        if (self.m_21223_() <= 0.0f) {
                            return;
                        }
                        itemEntity.m_32045_(remaining);
                    }
                });
            }
        }
    }
}

