/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCapability;

public class EquipmentDataLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new Gson();
    private static final Random RANDOM = new Random();
    private static final Map<String, List<String>> EQUIP_ITEMS = new HashMap<String, List<String>>();
    private static final Logger LOGGER = LogManager.getLogger();

    public EquipmentDataLoader() {
        super(GSON, "mobs_equipment");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiler) {
        EQUIP_ITEMS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation fileId = entry.getKey();
            JsonObject root = GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"equipment");
            String modId = fileId.m_135815_().replace(".json", "");
            if (!ModList.get().isLoaded(modId)) continue;
            for (String slot : List.of("MAINHAND", "OFFHAND", "HEAD", "CHEST", "LEGS", "FEET")) {
                if (!root.has(slot)) continue;
                JsonArray array = root.getAsJsonArray(slot);
                List items = EQUIP_ITEMS.computeIfAbsent(slot, k -> new ArrayList());
                for (JsonElement el : array) {
                    String itemName = el.getAsString();
                    items.add(modId + ":" + itemName);
                }
            }
        }
    }

    public static boolean canTwoHand(ItemStack stack) {
        CapabilityItem cap = EpicFightCapabilities.getItemStackCapability((ItemStack)stack);
        if (cap instanceof WeaponCapability) {
            WeaponCapability weaponCap = (WeaponCapability)cap;
            return weaponCap.getWeaponCategory() == CapabilityItem.WeaponCategories.GREATSWORD || weaponCap.getWeaponCategory() == CapabilityItem.WeaponCategories.AXE || weaponCap.getWeaponCategory() == CapabilityItem.WeaponCategories.TACHI || weaponCap.getWeaponCategory() == CapabilityItem.WeaponCategories.SWORD || weaponCap.getWeaponCategory() == CapabilityItem.WeaponCategories.FIST || weaponCap.getWeaponCategory() == CapabilityItem.WeaponCategories.DAGGER;
        }
        return false;
    }

    public static int getRandomDamage(ItemStack itemStack) {
        int maxDamage = itemStack.m_41776_();
        int min = maxDamage / 3;
        int max = maxDamage * 3 / 4;
        int damage = RANDOM.nextInt(max - min + 1) + min;
        return damage;
    }

    public static List<String> getEquipCommands(float equipChanceArmor, Entity entity) {
        ArrayList<String> cmds = new ArrayList<String>();
        String oneHandWeaponInMainHand = null;
        for (String slot : List.of("MAINHAND", "OFFHAND", "HEAD", "CHEST", "LEGS", "FEET")) {
            String itemId;
            boolean alwaysEquip;
            List pool = EQUIP_ITEMS.getOrDefault(slot, List.of());
            if (pool.isEmpty()) continue;
            boolean bl = alwaysEquip = slot.equals("MAINHAND") || slot.equals("OFFHAND");
            if (!alwaysEquip && RANDOM.nextFloat() > equipChanceArmor) continue;
            if (slot.equals("OFFHAND") && oneHandWeaponInMainHand != null) {
                Random random = new Random();
                if (!(random.nextFloat() < 0.25f)) continue;
                itemId = oneHandWeaponInMainHand;
            } else {
                itemId = (String)pool.get(RANDOM.nextInt(pool.size()));
            }
            String[] parts = itemId.split(":", 2);
            String namespace = parts[0];
            String path = parts[1];
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(namespace, path));
            if (item == null) continue;
            int damage = 0;
            if (item.m_41465_()) {
                damage = EquipmentDataLoader.getRandomDamage(new ItemStack((ItemLike)item));
            }
            cmds.add(String.format("item replace entity @s %s with %s{Damage:%d}", EquipmentDataLoader.mapSlot(slot), itemId, damage));
            ItemStack itemStack = new ItemStack((ItemLike)item);
            if (!slot.equals("MAINHAND") || !EquipmentDataLoader.canTwoHand(itemStack)) continue;
            oneHandWeaponInMainHand = itemId;
        }
        return cmds;
    }

    public static Optional<String> getRandomSpecificSlot(String slot) {
        String path;
        List pool = EQUIP_ITEMS.getOrDefault(slot, List.of());
        if (pool.isEmpty()) {
            return Optional.empty();
        }
        String itemId = (String)pool.get(RANDOM.nextInt(pool.size()));
        String[] parts = itemId.split(":", 2);
        String namespace = parts[0];
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(namespace, path = parts[1]));
        if (item == null) {
            return Optional.empty();
        }
        int damage = 0;
        if (item.m_41465_()) {
            int maxDamage = new ItemStack((ItemLike)item).m_41776_();
            int min = maxDamage / 3;
            int max = maxDamage * 3 / 4;
            damage = RANDOM.nextInt(max - min + 1) + min;
        }
        String command = String.format("item replace entity @s %s with %s{Damage:%d}", EquipmentDataLoader.mapSlot(slot), itemId, damage);
        return Optional.of(command);
    }

    private static String mapSlot(String slot) {
        return switch (slot) {
            case "MAINHAND" -> "weapon.mainhand";
            case "OFFHAND" -> "weapon.offhand";
            case "HEAD" -> "armor.head";
            case "CHEST" -> "armor.chest";
            case "LEGS" -> "armor.legs";
            case "FEET" -> "armor.feet";
            default -> slot.toLowerCase();
        };
    }
}

