/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.bungee.listener;

import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_L_String;
import gg.mineads.monitor.shared.MineAdsMonitorPlugin;
import gg.mineads.monitor.shared.event.TypeUtil;
import gg.mineads.monitor.shared.event.generated.EventType;
import gg.mineads.monitor.shared.event.generated.LuckPermsData;
import gg.mineads.monitor.shared.event.generated.MineAdsEvent;
import gg.mineads.monitor.shared.event.generated.PlayerChatData;
import gg.mineads.monitor.shared.event.generated.PlayerCommandData;
import gg.mineads.monitor.shared.event.generated.PlayerJoinData;
import gg.mineads.monitor.shared.event.generated.PlayerLeaveData;
import gg.mineads.monitor.shared.permission.LuckPermsUtil;
import gg.mineads.monitor.shared.scheduler.MineAdsScheduler;
import gg.mineads.monitor.shared.session.PlayerSessionManager;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Logger;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class PlayerListener
implements Listener {
    @Generated
    private static final Logger log = Logger.getLogger(PlayerListener.class.getName());
    private final MineAdsScheduler scheduler;
    private final MineAdsMonitorPlugin plugin;

    public PlayerListener(MineAdsScheduler scheduler, MineAdsMonitorPlugin plugin) {
        this.scheduler = scheduler;
        this.plugin = plugin;
    }

    @EventHandler(priority=64)
    public void onPostLogin(PostLoginEvent event) {
        if (!this.isEventEnabled(EventType.JOIN)) {
            if (this.plugin.getConfig().isDebug()) {
                log.info("[DEBUG] Player join event ignored - JOIN events disabled");
            }
            return;
        }
        ProxiedPlayer player = event.getPlayer();
        UUID sessionId = PlayerSessionManager.createSession(player.getUniqueId());
        this.scheduler.runAsync(() -> {
            String virtualHost;
            String clientBrand;
            String locale;
            int protocolVersion;
            String host;
            LuckPermsData luckPermsData = LuckPermsUtil.getLuckPermsData(this.plugin.getConfig(), player.getUniqueId());
            if (this.plugin.getConfig().isDebug()) {
                log.info(gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String.formatted("[DEBUG] Player joined: %s (%s), session: %s, groups: %s", player.getName(), player.getUniqueId(), sessionId, luckPermsData != null ? luckPermsData.getGroupsList() : null));
            }
            if (this.plugin.isOutdated() && player.hasPermission("mineadsmonitor.admin")) {
                TextComponent updateMessage = new TextComponent("[MineAdsMonitor] A new version is available! Download it at: https://modrinth.com/project/mineads-monitor");
                updateMessage.setColor(ChatColor.YELLOW);
                player.sendMessage((BaseComponent)updateMessage);
            }
            PlayerJoinData.Builder builder = PlayerJoinData.newBuilder().setSessionId(sessionId.toString()).setUuid(player.getUniqueId().toString()).setUsername(player.getName()).setOnlineMode(player.getPendingConnection().isOnlineMode());
            if (luckPermsData != null) {
                builder.setLuckpermsData(luckPermsData);
            }
            if ((host = TypeUtil.getIPString(player.getSocketAddress())) != null) {
                builder.setHost(host);
            }
            if ((protocolVersion = player.getPendingConnection().getVersion()) != -1) {
                builder.setProtocolVersion(protocolVersion);
            }
            if ((locale = Objects.toString(player.getLocale(), null)) != null && !J_L_String.isBlank(locale)) {
                builder.setLocale(locale);
            }
            if ((clientBrand = player.getClientBrand()) != null && !J_L_String.isBlank(clientBrand)) {
                builder.setClientBrand(clientBrand);
            }
            if ((virtualHost = TypeUtil.getHostString(player.getPendingConnection().getVirtualHost())) != null && !J_L_String.isBlank(virtualHost)) {
                builder.setVirtualHost(virtualHost);
            }
            PlayerJoinData data = builder.build();
            MineAdsEvent protoEvent = TypeUtil.createJoinEvent(data);
            this.plugin.getBatchProcessor().addEvent(protoEvent);
        });
    }

    @EventHandler(priority=64)
    public void onPlayerDisconnect(PlayerDisconnectEvent event) {
        if (!this.isEventEnabled(EventType.LEAVE)) {
            if (this.plugin.getConfig().isDebug()) {
                log.info("[DEBUG] Player quit event ignored - LEAVE events disabled");
            }
            return;
        }
        ProxiedPlayer player = event.getPlayer();
        UUID sessionId = PlayerSessionManager.removeSession(player.getUniqueId());
        this.scheduler.runAsync(() -> {
            if (sessionId != null) {
                if (this.plugin.getConfig().isDebug()) {
                    log.info(gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String.formatted("[DEBUG] Player quit: %s (%s), session: %s", player.getName(), player.getUniqueId(), sessionId));
                }
                PlayerLeaveData data = PlayerLeaveData.newBuilder().setSessionId(sessionId.toString()).build();
                MineAdsEvent protoEvent = TypeUtil.createLeaveEvent(data);
                this.plugin.getBatchProcessor().addEvent(protoEvent);
            } else if (this.plugin.getConfig().isDebug()) {
                log.info(gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String.formatted("[DEBUG] Player quit: %s - no active session found", player.getName()));
            }
        });
    }

    @EventHandler(priority=64)
    public void onChat(ChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Connection connection = event.getSender();
        if (!(connection instanceof ProxiedPlayer)) {
            return;
        }
        ProxiedPlayer player = (ProxiedPlayer)connection;
        UUID sessionId = PlayerSessionManager.getSessionId(player.getUniqueId());
        if (sessionId == null) {
            if (this.plugin.getConfig().isDebug()) {
                log.info(gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String.formatted("[DEBUG] Chat event ignored: %s - no active session", player.getName()));
            }
            return;
        }
        boolean isCommand = event.isCommand() || event.isProxyCommand();
        boolean isChatEnabled = this.isEventEnabled(EventType.CHAT);
        boolean isCommandEnabled = this.isEventEnabled(EventType.COMMAND);
        this.scheduler.runAsync(() -> {
            if (isCommand) {
                if (isCommandEnabled) {
                    if (this.plugin.getConfig().isDebug()) {
                        String command = PlayerListener.jvmdowngrader$concat$lambda$onChat$2$1(event.getMessage().substring(0, Math.min(50, event.getMessage().length())), event.getMessage().length() > 50 ? "..." : "");
                        log.info(gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String.formatted("[DEBUG] Player command: %s - %s", player.getName(), command));
                    }
                    PlayerCommandData.Builder dataBuilder = TypeUtil.createCommandDataBuilder(sessionId.toString(), event.getMessage(), true, this.plugin.getConfig().getDefaultMaxCommandArgs(), this.plugin.getConfig().getCommandArgLimits());
                    PlayerCommandData data = dataBuilder.build();
                    MineAdsEvent protoEvent = TypeUtil.createCommandEvent(data);
                    this.plugin.getBatchProcessor().addEvent(protoEvent);
                } else if (this.plugin.getConfig().isDebug()) {
                    log.info("[DEBUG] Player command event ignored - COMMAND events disabled");
                }
            } else if (isChatEnabled) {
                if (this.plugin.getConfig().isDebug()) {
                    String message = PlayerListener.jvmdowngrader$concat$lambda$onChat$2$1(event.getMessage().substring(0, Math.min(50, event.getMessage().length())), event.getMessage().length() > 50 ? "..." : "");
                    log.info(gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String.formatted("[DEBUG] Player chat: %s - %s", player.getName(), message));
                }
                PlayerChatData.Builder dataBuilder = PlayerChatData.newBuilder().setSessionId(sessionId.toString());
                if (!this.plugin.getConfig().isDisableChatContent()) {
                    dataBuilder.setMessage(event.getMessage());
                }
                PlayerChatData data = dataBuilder.build();
                MineAdsEvent protoEvent = TypeUtil.createChatEvent(data);
                this.plugin.getBatchProcessor().addEvent(protoEvent);
            } else if (this.plugin.getConfig().isDebug()) {
                log.info("[DEBUG] Player chat event ignored - CHAT events disabled");
            }
        });
    }

    private boolean isEventEnabled(EventType eventType) {
        return this.plugin.getConfig().getEnabledEvents().contains(eventType);
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$onChat$2$1(String string, String string2) {
        return string + string2;
    }
}

