/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.configlib;

import gg.mineads.monitor.shadow.configlib.Comment;
import gg.mineads.monitor.shadow.configlib.CommentNode;
import gg.mineads.monitor.shadow.configlib.ConfigurationElement;
import gg.mineads.monitor.shadow.configlib.ConfigurationElements;
import gg.mineads.monitor.shadow.configlib.ConfigurationProperties;
import gg.mineads.monitor.shadow.configlib.FieldExtractors;
import gg.mineads.monitor.shadow.configlib.FieldFilter;
import gg.mineads.monitor.shadow.configlib.NameFormatter;
import gg.mineads.monitor.shadow.configlib.Reflect;
import gg.mineads.monitor.shadow.configlib.Validator;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.RecordComponents;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Class;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={State.class})
final class CommentNodeExtractor {
    private final FieldFilter fieldFilter;
    private final NameFormatter nameFormatter;
    private final boolean outputNull;

    CommentNodeExtractor(ConfigurationProperties properties) {
        this.fieldFilter = Validator.requireNonNull(properties.getFieldFilter(), "field filter");
        this.nameFormatter = Validator.requireNonNull(properties.getNameFormatter(), "name formatter");
        this.outputNull = properties.outputNulls();
    }

    public Queue<CommentNode> extractCommentNodes(Object elementHolder) {
        Validator.requireConfigurationType(elementHolder.getClass());
        ArrayDeque<CommentNode> result = new ArrayDeque<CommentNode>();
        ArrayDeque<String> elementNameStack = new ArrayDeque<String>(J_U_List.of(""));
        ArrayDeque<State> stateStack = new ArrayDeque<State>(J_U_List.of(this.stateFromObject(elementHolder)));
        while (!stateStack.isEmpty()) {
            State state = stateStack.removeLast();
            elementNameStack.removeLast();
            while (state.jvmdowngrader$nest$gg_mineads_monitor_shadow_configlib_CommentNodeExtractor$State$get$iterator().hasNext()) {
                ConfigurationElement element = (ConfigurationElement)state.jvmdowngrader$nest$gg_mineads_monitor_shadow_configlib_CommentNodeExtractor$State$get$iterator().next();
                Object elementValue = element.value(state.jvmdowngrader$nest$gg_mineads_monitor_shadow_configlib_CommentNodeExtractor$State$get$elementHolder());
                if (elementValue == null && !this.outputNull) continue;
                String elementName = element.name();
                Optional<CommentNode> commentNode = this.createNodeIfCommentPresent((AnnotatedElement)element.element(), elementName, (Deque<String>)elementNameStack);
                commentNode.ifPresent(result::add);
                Class<?> elementType = element.type();
                if (elementValue == null || !Reflect.isConfigurationType(elementType)) continue;
                stateStack.addLast(state);
                elementNameStack.addLast(this.nameFormatter.format(elementName));
                state = this.stateFromObject(elementValue);
            }
        }
        return result;
    }

    private State stateFromObject(Object elementHolder) {
        Class<?> type = elementHolder.getClass();
        Iterator<J_L_Record> iter = J_L_Class.isRecord(type) ? this.recordComponentElements(elementHolder) : this.fieldElements(elementHolder);
        return new State(iter, elementHolder);
    }

    private Optional<CommentNode> createNodeIfCommentPresent(AnnotatedElement element, String elementName, Deque<String> elementNameStack) {
        if (element.isAnnotationPresent(Comment.class)) {
            List<String> comments = J_U_S_Stream.toList(Arrays.stream(element.getAnnotation(Comment.class).value()).flatMap(s -> Arrays.stream(s.split("\n", -1))));
            String formattedName = this.nameFormatter.format(elementName);
            ArrayList<String> elementNames = new ArrayList<String>(elementNameStack);
            elementNames.add(formattedName);
            CommentNode result = new CommentNode(comments, elementNames);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private Iterator<ConfigurationElements.FieldElement> fieldElements(Object configuration) {
        return FieldExtractors.CONFIGURATION.extract(configuration.getClass()).filter(this.fieldFilter).map(ConfigurationElements.FieldElement::new).iterator();
    }

    private Iterator<ConfigurationElements.RecordComponentElement> recordComponentElements(Object record) {
        return Arrays.stream(J_L_Class.getRecordComponents(record.getClass())).map(ConfigurationElements.RecordComponentElement::new).iterator();
    }

    @RecordComponents(value={@RecordComponents.Value(name="iterator", type=Iterator.class), @RecordComponents.Value(name="elementHolder", type=Object.class)})
    @NestHost(value=CommentNodeExtractor.class)
    private static final class State
    extends J_L_Record {
        private final Iterator<? extends ConfigurationElement<?>> iterator;
        private final Object elementHolder;

        State(Iterator<? extends ConfigurationElement<?>> iterator, Object elementHolder) {
            this.iterator = iterator;
            this.elementHolder = elementHolder;
        }

        @Override
        public final String toString() {
            return State.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return State.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return State.jvmdowngrader$equals$equals(this, o);
        }

        public Iterator<? extends ConfigurationElement<?>> iterator() {
            return this.iterator;
        }

        public Object elementHolder() {
            return this.elementHolder;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(State state) {
            State state2 = state;
            return "CommentNodeExtractor$State[" + "iterator=" + state.iterator + ", " + "elementHolder=" + state.elementHolder + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(State state) {
            Object[] objectArray = new Object[]{state.iterator, state.elementHolder};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(State state, Object object) {
            if (state == object) {
                return true;
            }
            if (object != null && object instanceof State) {
                State state2 = (State)object;
                if (Objects.equals(state.iterator, state2.iterator) && Objects.equals(state.elementHolder, state2.elementHolder)) {
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ Iterator jvmdowngrader$nest$gg_mineads_monitor_shadow_configlib_CommentNodeExtractor$State$get$iterator() {
            return this.iterator;
        }

        public /* synthetic */ void jvmdowngrader$nest$gg_mineads_monitor_shadow_configlib_CommentNodeExtractor$State$set$iterator(Iterator iterator) {
            this.iterator = iterator;
        }

        public /* synthetic */ Object jvmdowngrader$nest$gg_mineads_monitor_shadow_configlib_CommentNodeExtractor$State$get$elementHolder() {
            return this.elementHolder;
        }

        public /* synthetic */ void jvmdowngrader$nest$gg_mineads_monitor_shadow_configlib_CommentNodeExtractor$State$set$elementHolder(Object object) {
            this.elementHolder = object;
        }
    }
}

