/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.configlib;

import gg.mineads.monitor.shadow.configlib.ConfigurationException;
import gg.mineads.monitor.shadow.configlib.ConfigurationProperties;
import gg.mineads.monitor.shadow.configlib.Environment;
import gg.mineads.monitor.shadow.configlib.Serializer;
import gg.mineads.monitor.shadow.configlib.TypeSerializer;
import gg.mineads.monitor.shadow.configlib.Validator;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={EnvironmentVariablePreprocessor.class})
final class RootSerializer<T>
implements Serializer<T, Map<?, ?>> {
    private final TypeSerializer<T, ?> serializer;
    private final ConfigurationProperties properties;
    private final Environment environment;

    RootSerializer(Class<T> type, ConfigurationProperties properties, Environment environment) {
        Validator.requireConfigurationType(type);
        this.properties = Validator.requireNonNull(properties, "configuration properties");
        this.environment = Validator.requireNonNull(environment, "environment");
        this.serializer = TypeSerializer.newSerializerFor(type, properties);
    }

    @Override
    public Map<?, ?> serialize(T rootConfiguration) {
        return this.serializer.serialize((Object)rootConfiguration);
    }

    @Override
    public T deserialize(Map<?, ?> serializedConfiguration) {
        EnvironmentVariablePreprocessor envVarPreprocessor = new EnvironmentVariablePreprocessor(this.environment, this.properties.getEnvVarResolutionConfiguration());
        envVarPreprocessor.preprocess(serializedConfiguration);
        return (T)this.serializer.deserialize(serializedConfiguration);
    }

    T newDefaultInstance() {
        return this.serializer.newDefaultInstance();
    }

    @NestHost(value=RootSerializer.class)
    private static final class EnvironmentVariablePreprocessor {
        private final Environment environment;
        private final ConfigurationProperties.EnvVarResolutionConfiguration envVarConfig;

        EnvironmentVariablePreprocessor(Environment environment, ConfigurationProperties.EnvVarResolutionConfiguration envVarConfig) {
            this.environment = environment;
            this.envVarConfig = envVarConfig;
        }

        public void preprocess(Map<?, ?> serializedConfig) {
            if (!this.envVarConfig.resolveEnvVars()) {
                return;
            }
            Map<Object, Object> map = serializedConfig;
            String initialPrefix = this.envVarConfig.prefix();
            this.preprocessEnvVarMap(initialPrefix, map);
        }

        private void preprocessEnvVarMap(String prefix, Map<Object, Object> map) {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                Object key = entry.getKey();
                if (key == null) continue;
                Object val = entry.getValue();
                String envVar = prefix.isEmpty() ? key.toString() : EnvironmentVariablePreprocessor.jvmdowngrader$concat$preprocessEnvVarMap$1(prefix, String.valueOf(key));
                envVar = this.envVarConfig.caseSensitive() ? envVar : envVar.toUpperCase();
                String envVarVal = this.environment.getValue(envVar);
                this.preprocessRecursively(val, envVar, envVarVal, entry::setValue);
            }
        }

        private void preprocessEnvVarList(String prefix, List<Object> list) {
            int i = 0;
            while (i < list.size()) {
                Object val = list.get(i);
                String envVar = prefix.isEmpty() ? String.valueOf(i) : EnvironmentVariablePreprocessor.jvmdowngrader$concat$preprocessEnvVarList$1(prefix, i);
                envVar = this.envVarConfig.caseSensitive() ? envVar : envVar.toUpperCase();
                String envVarVal = this.environment.getValue(envVar);
                int index = i++;
                this.preprocessRecursively(val, envVar, envVarVal, o -> list.set(index, o));
            }
        }

        private void preprocessRecursively(Object value, String envVar, String envVarVal, Consumer<Object> updater) {
            if (value instanceof Map) {
                Map map = (Map)value;
                EnvironmentVariablePreprocessor.requireEnvVarNull(envVar, envVarVal, "map");
                Map r = map;
                this.preprocessEnvVarMap(envVar, r);
            } else if (value instanceof List) {
                List list = (List)value;
                EnvironmentVariablePreprocessor.requireEnvVarNull(envVar, envVarVal, "list");
                List l = list;
                this.preprocessEnvVarList(envVar, l);
            } else if (value instanceof Set) {
                EnvironmentVariablePreprocessor.requireEnvVarNull(envVar, envVarVal, "set");
            } else if (envVarVal != null) {
                Object updatedValue = EnvironmentVariablePreprocessor.tryConvertEnvVarValueToTypeOfCurrentValue(envVar, envVarVal, value);
                updater.accept(updatedValue);
            }
        }

        private static void requireEnvVarNull(String envVar, String envVarVal, String collectionType) {
            if (envVarVal == null) {
                return;
            }
            String msg = J_L_String.formatted("Environment variables cannot be used to replace collections, but environment variable '%s' with value '%s' tries to replace a %s.", envVar, envVarVal, collectionType);
            throw new ConfigurationException(msg);
        }

        private static Object tryConvertEnvVarValueToTypeOfCurrentValue(String envVar, String envVarValue, Object currentValue) {
            if (currentValue == null) {
                String msg = J_L_String.formatted("Value '%s' of environment variable '%s' cannot be converted because the value that is supposed to be replaced is null.", envVarValue, envVar);
                throw new ConfigurationException(msg);
            }
            if (currentValue instanceof String) {
                return envVarValue;
            }
            try {
                if (currentValue instanceof Boolean) {
                    return EnvironmentVariablePreprocessor.parseBoolean(envVarValue);
                }
                if (currentValue instanceof Long) {
                    return Long.valueOf(envVarValue);
                }
                if (currentValue instanceof Double) {
                    return Double.valueOf(envVarValue);
                }
            }
            catch (RuntimeException e) {
                String simpleName = currentValue.getClass().getSimpleName();
                String msg = J_L_String.formatted("Value '%s' of environment variable '%s' cannot be converted to type '%s'. The value the environment variable is supposed to replace is '%s'.", envVarValue, envVar, simpleName, currentValue);
                throw new ConfigurationException(msg, e);
            }
            String msg = J_L_String.formatted("Unexpected value '%s' of type '%s'", currentValue, currentValue.getClass());
            throw new ConfigurationException(msg);
        }

        private static Boolean parseBoolean(String val) {
            if ("true".equalsIgnoreCase(val) || "false".equalsIgnoreCase(val)) {
                return Boolean.valueOf(val);
            }
            String msg = EnvironmentVariablePreprocessor.jvmdowngrader$concat$parseBoolean$1(val);
            throw new RuntimeException(msg);
        }

        private static /* synthetic */ String jvmdowngrader$concat$preprocessEnvVarMap$1(String string, String string2) {
            return string + "_" + string2;
        }

        private static /* synthetic */ String jvmdowngrader$concat$preprocessEnvVarList$1(String string, int n) {
            return string + "_" + n;
        }

        private static /* synthetic */ String jvmdowngrader$concat$parseBoolean$1(String string) {
            return "The string '" + string + "' is not a valid boolean value. Only the values 'true' and 'false' (ignoring their case) are supported.";
        }
    }
}

