/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.configlib;

import gg.mineads.monitor.shadow.configlib.CommentNode;
import gg.mineads.monitor.shadow.configlib.CommentNodeExtractor;
import gg.mineads.monitor.shadow.configlib.ConfigurationException;
import gg.mineads.monitor.shadow.configlib.Environment;
import gg.mineads.monitor.shadow.configlib.FileConfigurationStore;
import gg.mineads.monitor.shadow.configlib.IOStreamConfigurationStore;
import gg.mineads.monitor.shadow.configlib.RootSerializer;
import gg.mineads.monitor.shadow.configlib.Validator;
import gg.mineads.monitor.shadow.configlib.YamlConfigurationProperties;
import gg.mineads.monitor.shadow.configlib.YamlWriter;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j10.stub.java_base.J_U_Map;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import gg.mineads.monitor.shadow.snakeyaml.engine.v2.api.ConstructNode;
import gg.mineads.monitor.shadow.snakeyaml.engine.v2.api.Dump;
import gg.mineads.monitor.shadow.snakeyaml.engine.v2.api.DumpSettings;
import gg.mineads.monitor.shadow.snakeyaml.engine.v2.api.Load;
import gg.mineads.monitor.shadow.snakeyaml.engine.v2.api.LoadSettings;
import gg.mineads.monitor.shadow.snakeyaml.engine.v2.common.FlowStyle;
import gg.mineads.monitor.shadow.snakeyaml.engine.v2.constructor.ConstructScalar;
import gg.mineads.monitor.shadow.snakeyaml.engine.v2.constructor.ConstructYamlNull;
import gg.mineads.monitor.shadow.snakeyaml.engine.v2.constructor.StandardConstructor;
import gg.mineads.monitor.shadow.snakeyaml.engine.v2.constructor.json.ConstructYamlJsonBool;
import gg.mineads.monitor.shadow.snakeyaml.engine.v2.constructor.json.ConstructYamlJsonFloat;
import gg.mineads.monitor.shadow.snakeyaml.engine.v2.exceptions.YamlEngineException;
import gg.mineads.monitor.shadow.snakeyaml.engine.v2.nodes.Node;
import gg.mineads.monitor.shadow.snakeyaml.engine.v2.nodes.Tag;
import gg.mineads.monitor.shadow.snakeyaml.engine.v2.representer.StandardRepresenter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Queue;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={YamlConfigurationConstructor.class, YamlConfigurationConstructor.YamlConfigurationConstructYamlJsonInt.class, YamlConfigurationRepresenter.class})
public final class YamlConfigurationStore<T>
implements FileConfigurationStore<T>,
IOStreamConfigurationStore<T> {
    private static final Dump YAML_DUMPER = YamlConfigurationStore.newYamlDumper();
    private static final Load YAML_LOADER = YamlConfigurationStore.newYamlLoader();
    private final YamlConfigurationProperties properties;
    private final RootSerializer<T> serializer;
    private final CommentNodeExtractor extractor;

    public YamlConfigurationStore(Class<T> configurationType, YamlConfigurationProperties properties) {
        this(configurationType, properties, new Environment.SystemEnvironment());
    }

    YamlConfigurationStore(Class<T> configurationType, YamlConfigurationProperties properties, Environment environment) {
        Validator.requireNonNull(configurationType, "configuration type");
        this.properties = Validator.requireNonNull(properties, "properties");
        this.serializer = new RootSerializer<T>(configurationType, properties, environment);
        this.extractor = new CommentNodeExtractor(properties);
    }

    @Override
    public void write(T configuration, OutputStream outputStream) {
        Validator.requireNonNull(configuration, "configuration");
        Validator.requireNonNull(outputStream, "output stream");
        Queue<CommentNode> extractedCommentNodes = this.extractor.extractCommentNodes(configuration);
        YamlWriter yamlFileWriter = new YamlWriter(outputStream, this.properties);
        String dumpedYaml = this.tryDump(configuration);
        yamlFileWriter.writeYaml(dumpedYaml, extractedCommentNodes);
    }

    @Override
    public void save(T configuration, Path configurationFile) {
        Validator.requireNonNull(configuration, "configuration");
        Validator.requireNonNull(configurationFile, "configuration file");
        this.tryCreateParentDirectories(configurationFile);
        Queue<CommentNode> extractedCommentNodes = this.extractor.extractCommentNodes(configuration);
        YamlWriter yamlFileWriter = new YamlWriter(configurationFile, this.properties);
        String dumpedYaml = this.tryDump(configuration);
        yamlFileWriter.writeYaml(dumpedYaml, extractedCommentNodes);
    }

    void tryCreateParentDirectories(Path configurationFile) {
        Path parent = configurationFile.getParent();
        if (this.properties.createParentDirectories() && parent != null && !Files.exists(parent, new LinkOption[0])) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String tryDump(T configuration) {
        Object serializedConfiguration = this.serializer.serialize((Object)configuration);
        try {
            return YAML_DUMPER.dumpToString(serializedConfiguration);
        }
        catch (YamlEngineException e) {
            String msg = "The given configuration could not be converted into YAML. \nDo all custom serializers produce valid target types?";
            throw new ConfigurationException(msg, e);
        }
    }

    @Override
    public T read(InputStream inputStream) {
        Validator.requireNonNull(inputStream, "input stream");
        try {
            Object yaml = YAML_LOADER.loadFromInputStream(inputStream);
            Map<?, ?> conf = this.requireYamlMapForRead(yaml);
            return this.serializer.deserialize(conf);
        }
        catch (YamlEngineException e) {
            String msg = "The input stream does not contain valid YAML.";
            throw new ConfigurationException(msg, e);
        }
    }

    private Map<?, ?> requireYamlMapForRead(Object yaml) {
        if (yaml == null) {
            String msg = "The input stream is empty or only contains null.";
            throw new ConfigurationException(msg);
        }
        if (!(yaml instanceof Map)) {
            String msg = YamlConfigurationStore.jvmdowngrader$concat$requireYamlMapForRead$1(String.valueOf(yaml.getClass()));
            throw new ConfigurationException(msg);
        }
        Map map = (Map)yaml;
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T load(Path configurationFile) {
        Validator.requireNonNull(configurationFile, "configuration file");
        try (BufferedReader reader = Files.newBufferedReader(configurationFile, this.properties.getCharset());){
            Object yaml2 = YAML_LOADER.loadFromReader(reader);
            Map<?, ?> conf = this.requireYamlMapForLoad(yaml2, configurationFile);
            T t = this.serializer.deserialize(conf);
            return t;
        }
        catch (YamlEngineException e) {
            String msg = "The configuration file at %s does not contain valid YAML.";
            throw new ConfigurationException(J_L_String.formatted(msg, configurationFile), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<?, ?> requireYamlMapForLoad(Object yaml, Path configurationFile) {
        if (yaml == null) {
            String msg = "The configuration file at %s is empty or only contains null.";
            throw new ConfigurationException(J_L_String.formatted(msg, configurationFile));
        }
        if (!(yaml instanceof Map)) {
            String msg = YamlConfigurationStore.jvmdowngrader$concat$requireYamlMapForLoad$1(String.valueOf(yaml.getClass()));
            throw new ConfigurationException(J_L_String.formatted(msg, configurationFile));
        }
        Map map = (Map)yaml;
        return map;
    }

    @Override
    public T update(Path configurationFile) {
        Validator.requireNonNull(configurationFile, "configuration file");
        if (Files.exists(configurationFile, new LinkOption[0])) {
            T configuration = this.load(configurationFile);
            this.save(configuration, configurationFile);
            return configuration;
        }
        T defaultConfiguration = this.serializer.newDefaultInstance();
        this.save(defaultConfiguration, configurationFile);
        return this.load(configurationFile);
    }

    static Dump newYamlDumper() {
        DumpSettings settings = DumpSettings.builder().setDefaultFlowStyle(FlowStyle.BLOCK).setIndent(2).build();
        return new Dump(settings, new YamlConfigurationRepresenter(settings));
    }

    static Load newYamlLoader() {
        LoadSettings settings = LoadSettings.builder().build();
        return new Load(settings, new YamlConfigurationConstructor(settings));
    }

    private static /* synthetic */ String jvmdowngrader$concat$requireYamlMapForRead$1(String string) {
        return "The contents of the input stream do not represent a configuration. A valid configuration contains a YAML map but instead a '" + string + "' was found.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$requireYamlMapForLoad$1(String string) {
        return "The contents of the YAML file at %s do not represent a configuration. A valid configuration file contains a YAML map but instead a '" + string + "' was found.";
    }

    @NestHost(value=YamlConfigurationStore.class)
    static final class YamlConfigurationRepresenter
    extends StandardRepresenter {
        public YamlConfigurationRepresenter(DumpSettings settings) {
            super(settings);
        }

        @Override
        protected Node representSequence(Tag tag, Iterable<?> sequence, FlowStyle flowStyle) {
            Node node = super.representSequence(tag, sequence, flowStyle);
            this.representedObjects.clear();
            return node;
        }

        @Override
        protected Node representMapping(Tag tag, Map<?, ?> mapping, FlowStyle flowStyle) {
            Node node = super.representMapping(tag, mapping, flowStyle);
            this.representedObjects.clear();
            return node;
        }
    }

    @NestHost(value=YamlConfigurationStore.class)
    static final class YamlConfigurationConstructor
    extends StandardConstructor {
        private final Map<Tag, ConstructNode> tagCtors;

        public YamlConfigurationConstructor(LoadSettings settings) {
            super(settings);
            this.tagConstructors.clear();
            this.tagConstructors.put(Tag.NULL, new ConstructYamlNull());
            this.tagConstructors.put(Tag.BOOL, new ConstructYamlJsonBool());
            this.tagConstructors.put(Tag.STR, new StandardConstructor.ConstructYamlStr(this));
            this.tagConstructors.put(Tag.SEQ, new StandardConstructor.ConstructYamlSeq(this));
            this.tagConstructors.put(Tag.MAP, new StandardConstructor.ConstructYamlMap(this));
            this.tagConstructors.put(Tag.INT, new YamlConfigurationConstructYamlJsonInt());
            this.tagConstructors.put(Tag.FLOAT, new ConstructYamlJsonFloat());
            this.tagCtors = J_U_Map.copyOf(this.tagConstructors);
        }

        Map<Tag, ConstructNode> getTagCtors() {
            return this.tagCtors;
        }

        @NestHost(value=YamlConfigurationStore.class)
        static final class YamlConfigurationConstructYamlJsonInt
        extends ConstructScalar {
            YamlConfigurationConstructYamlJsonInt() {
            }

            @Override
            public Object construct(Node node) {
                String value = this.constructScalar(node);
                return Long.valueOf(value);
            }
        }
    }
}

