/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.incendo.cloud.bungee;

import gg.mineads.monitor.shadow.geantyref.GenericTypeReflector;
import gg.mineads.monitor.shadow.incendo.cloud.Command;
import gg.mineads.monitor.shadow.incendo.cloud.bungee.BungeeCommandManager;
import gg.mineads.monitor.shadow.incendo.cloud.component.CommandComponent;
import gg.mineads.monitor.shadow.incendo.cloud.internal.CommandNode;
import gg.mineads.monitor.shadow.incendo.cloud.permission.Permission;
import gg.mineads.monitor.shadow.incendo.cloud.suggestion.Suggestion;
import gg.mineads.monitor.shadow.incendo.cloud.suggestion.Suggestions;
import gg.mineads.monitor.shadow.incendo.cloud.util.StringUtils;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.plugin.TabExecutor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BungeeCommand<C>
extends net.md_5.bungee.api.plugin.Command
implements TabExecutor {
    private final BungeeCommandManager<C> manager;
    private final CommandComponent<C> command;

    BungeeCommand(@NonNull Command<C> cloudCommand, @NonNull CommandComponent<C> command, @NonNull BungeeCommandManager<C> manager) {
        super(command.name(), cloudCommand.commandPermission().toString(), command.alternativeAliases().toArray(new String[0]));
        this.command = command;
        this.manager = manager;
    }

    public void execute(CommandSender commandSender, String[] strings) {
        StringBuilder builder = new StringBuilder(this.command.name());
        for (String string : strings) {
            builder.append(" ").append(string);
        }
        C sender = this.manager.senderMapper().map(commandSender);
        this.manager.commandExecutor().executeCommand(sender, builder.toString());
    }

    public boolean hasPermission(CommandSender sender) {
        CommandNode<C> node = this.namedNode();
        if (node == null) {
            return false;
        }
        Map accessMap = node.nodeMeta().getOrDefault(CommandNode.META_KEY_ACCESS, Collections.emptyMap());
        C cloudSender = this.manager.senderMapper().map(sender);
        for (Map.Entry entry : accessMap.entrySet()) {
            if (!GenericTypeReflector.isSuperType((Type)entry.getKey(), cloudSender.getClass()) || !this.manager.testPermission(cloudSender, (Permission)entry.getValue()).allowed()) continue;
            return true;
        }
        return false;
    }

    private @Nullable CommandNode<C> namedNode() {
        return this.manager.commandTree().getNamedNode(this.command.name());
    }

    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        StringBuilder builder = new StringBuilder(this.command.name());
        for (String string : args) {
            builder.append(" ").append(string);
        }
        Suggestions result = this.manager.suggestionFactory().suggestImmediately(this.manager.senderMapper().map(sender), builder.toString());
        return result.list().stream().map(Suggestion::suggestion).map(suggestion -> StringUtils.trimBeforeLastSpace(suggestion, result.commandInput())).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

