/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_net_http;

import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpClient;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpHeaders;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpRequest;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_C_Flow;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.net.ssl.SSLSession;
import xyz.wagyourtail.jvmdg.version.Adapter;

@Adapter(value="Ljava/net/http/HttpResponse;")
public interface J_N_H_HttpResponse<T> {
    public int statusCode();

    public J_N_H_HttpRequest request();

    public Optional<J_N_H_HttpResponse<T>> previousResponse();

    public J_N_H_HttpHeaders headers();

    public T body();

    public Optional<SSLSession> sslSession();

    public URI uri();

    public J_N_H_HttpClient.Version version();

    @Adapter(value="Ljava/net/http/HttpResponse$BodySubscribers;")
    public static class BodySubscribers {
        public static BodySubscriber<String> ofString(final Charset charset) {
            final CompletableFuture result = new CompletableFuture();
            return new BodySubscriber<String>(){
                final StringBuilder builder = new StringBuilder();

                @Override
                public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                    item.forEach(b -> this.builder.append(new String(b.array(), b.arrayOffset() + b.position(), b.remaining(), charset)));
                }

                @Override
                public void onError(Throwable throwable) {
                    result.completeExceptionally(throwable);
                }

                @Override
                public void onComplete() {
                    result.complete(this.builder.toString());
                }

                @Override
                public CompletionStage<String> getBody() {
                    return result;
                }
            };
        }

        public static BodySubscriber<InputStream> ofInputStream() {
            final LinkedBlockingDeque deq = new LinkedBlockingDeque();
            final AtomicBoolean completed = new AtomicBoolean(false);
            final AtomicReference<Object> exception = new AtomicReference<Object>(null);
            InputStream is = new InputStream(){
                ByteBuffer current;

                @Override
                public int read() throws IOException {
                    Throwable t = (Throwable)exception.get();
                    if (t != null) {
                        if (completed.get()) {
                            throw new IOException("closed");
                        }
                        completed.set(true);
                        if (t instanceof IOException) {
                            throw (IOException)t;
                        }
                        throw new IOException(t);
                    }
                    if (this.current == null) {
                        if (completed.get() && deq.isEmpty()) {
                            return -1;
                        }
                        try {
                            this.current = (ByteBuffer)deq.take();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new IOException("Interrupted while waiting for data", e);
                        }
                    }
                    if (!this.current.hasRemaining()) {
                        this.current = null;
                        return this.read();
                    }
                    return this.current.get() & 0xFF;
                }
            };
            final CompletableFuture<7> result = CompletableFuture.completedFuture(is);
            return new BodySubscriber<InputStream>(){

                @Override
                public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                    for (ByteBuffer b : item) {
                        deq.offer(b);
                    }
                }

                @Override
                public void onError(Throwable throwable) {
                    exception.set(throwable);
                }

                @Override
                public void onComplete() {
                    completed.set(true);
                    deq.add(ByteBuffer.allocate(0));
                }

                @Override
                public CompletionStage<InputStream> getBody() {
                    return result;
                }
            };
        }

        public static BodySubscriber<Void> discarding() {
            final CompletableFuture result = new CompletableFuture();
            return new BodySubscriber<Void>(){

                @Override
                public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                }

                @Override
                public void onError(Throwable throwable) {
                    result.completeExceptionally(throwable);
                }

                @Override
                public void onComplete() {
                    result.complete(null);
                }

                @Override
                public CompletionStage<Void> getBody() {
                    return result;
                }
            };
        }
    }

    @Adapter(value="Ljava/net/http/HttpResponse$BodyHandlers;")
    public static class BodyHandlers {
        private static Charset charsetFrom(J_N_H_HttpHeaders headers) {
            return StandardCharsets.UTF_8;
        }

        public static BodyHandler<Void> discarding() {
            return info -> BodySubscribers.discarding();
        }

        public static BodyHandler<InputStream> ofInputStream() {
            return info -> BodySubscribers.ofInputStream();
        }

        public static BodyHandler<String> ofString() {
            return info -> BodySubscribers.ofString(BodyHandlers.charsetFrom(info.headers()));
        }
    }

    @Adapter(value="Ljava/net/http/HttpResponse$PushPromiseHandler;")
    public static interface PushPromiseHandler<T> {
        public void applyPushPromise(J_N_H_HttpRequest var1, J_N_H_HttpRequest var2, Function<BodyHandler<T>, CompletableFuture<J_N_H_HttpResponse<T>>> var3);
    }

    @Adapter(value="Ljava/net/http/HttpResponse$BodyHandler;")
    public static interface BodyHandler<T> {
        public BodySubscriber<T> apply(ResponseInfo var1);
    }

    @Adapter(value="Ljava/net/http/HttpResponse$ResponseInfo;")
    public static interface ResponseInfo {
        public int statusCode();

        public J_N_H_HttpHeaders headers();

        public J_N_H_HttpClient.Version version();
    }

    @Adapter(value="Ljava/net/http/HttpResponse$BodySubscriber;")
    public static interface BodySubscriber<T>
    extends J_U_C_Flow.Subscriber<List<ByteBuffer>> {
        public CompletionStage<T> getBody();
    }
}

