/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.kyori.adventure.platform.bungeecord;

import gg.mineads.monitor.shadow.annotations.jetbrains.Nullable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

final class BungeeReflection {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    private BungeeReflection() {
    }

    public static boolean hasMethod(@Nullable Class<?> holderClass, String methodName, Class<?> ... parameters) {
        if (holderClass == null) {
            return false;
        }
        for (Class<?> parameter : parameters) {
            if (parameter != null) continue;
            return false;
        }
        try {
            holderClass.getMethod(methodName, parameters);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public static MethodHandle findMethod(@Nullable Class<?> holderClass, String methodName, Class<?> returnType, Class<?> ... parameters) {
        if (holderClass == null || returnType == null) {
            return null;
        }
        for (Class<?> parameter : parameters) {
            if (parameter != null) continue;
            return null;
        }
        try {
            return LOOKUP.findVirtual(holderClass, methodName, MethodType.methodType(returnType, parameters));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            return null;
        }
    }
}

