/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.kyori.adventure.text.serializer.bungeecord;

import gg.mineads.monitor.shadow.annotations.jetbrains.NotNull;
import gg.mineads.monitor.shadow.gson.Gson;
import gg.mineads.monitor.shadow.gson.GsonBuilder;
import gg.mineads.monitor.shadow.gson.stream.JsonWriter;
import gg.mineads.monitor.shadow.kyori.adventure.text.Component;
import gg.mineads.monitor.shadow.kyori.adventure.text.serializer.ComponentSerializer;
import gg.mineads.monitor.shadow.kyori.adventure.text.serializer.bungeecord.GsonInjections;
import gg.mineads.monitor.shadow.kyori.adventure.text.serializer.bungeecord.SelfSerializable;
import gg.mineads.monitor.shadow.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import gg.mineads.monitor.shadow.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Objects;
import net.md_5.bungee.api.chat.BaseComponent;

public final class BungeeComponentSerializer
implements ComponentSerializer<Component, Component, BaseComponent[]> {
    private static boolean SUPPORTED = true;
    private static final BungeeComponentSerializer MODERN;
    private static final BungeeComponentSerializer PRE_1_16;
    private final GsonComponentSerializer serializer;
    private final LegacyComponentSerializer legacySerializer;

    public static boolean isNative() {
        return SUPPORTED;
    }

    public static BungeeComponentSerializer get() {
        return MODERN;
    }

    public static BungeeComponentSerializer legacy() {
        return PRE_1_16;
    }

    public static BungeeComponentSerializer of(GsonComponentSerializer serializer, LegacyComponentSerializer legacySerializer) {
        if (serializer == null || legacySerializer == null) {
            return null;
        }
        return new BungeeComponentSerializer(serializer, legacySerializer);
    }

    public static boolean inject(Gson existing) {
        boolean result = GsonInjections.injectGson(Objects.requireNonNull(existing, "existing"), builder -> {
            GsonComponentSerializer.gson().populator().apply((GsonBuilder)builder);
            builder.registerTypeAdapterFactory(new SelfSerializable.AdapterFactory());
        });
        SUPPORTED &= result;
        return result;
    }

    private BungeeComponentSerializer(GsonComponentSerializer serializer, LegacyComponentSerializer legacySerializer) {
        this.serializer = serializer;
        this.legacySerializer = legacySerializer;
    }

    private static void bind() {
        try {
            Field gsonField = GsonInjections.field(net.md_5.bungee.chat.ComponentSerializer.class, "gson");
            BungeeComponentSerializer.inject((Gson)gsonField.get(null));
        }
        catch (Throwable error) {
            SUPPORTED = false;
        }
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull @NotNull BaseComponent @NotNull [] input) {
        Objects.requireNonNull(input, "input");
        if (input.length == 1 && input[0] instanceof AdapterComponent) {
            return ((AdapterComponent)input[0]).component;
        }
        return this.serializer.deserialize(net.md_5.bungee.chat.ComponentSerializer.toString((BaseComponent[])input));
    }

    @Override
    @NotNull
    public @NotNull BaseComponent @NotNull [] serialize(@NotNull Component component) {
        Objects.requireNonNull(component, "component");
        if (SUPPORTED) {
            return new BaseComponent[]{new AdapterComponent(component)};
        }
        return net.md_5.bungee.chat.ComponentSerializer.parse((String)((String)this.serializer.serialize(component)));
    }

    static {
        BungeeComponentSerializer.bind();
        MODERN = new BungeeComponentSerializer(GsonComponentSerializer.gson(), LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().build());
        PRE_1_16 = new BungeeComponentSerializer(GsonComponentSerializer.builder().downsampleColors().emitLegacyHoverEvent().build(), LegacyComponentSerializer.legacySection());
    }

    class AdapterComponent
    extends BaseComponent
    implements SelfSerializable {
        private final Component component;
        private volatile String legacy;

        AdapterComponent(Component component) {
            this.component = component;
        }

        public String toLegacyText() {
            if (this.legacy == null) {
                this.legacy = BungeeComponentSerializer.this.legacySerializer.serialize(this.component);
            }
            return this.legacy;
        }

        @NotNull
        public BaseComponent duplicate() {
            return this;
        }

        @Override
        public void write(JsonWriter out) throws IOException {
            BungeeComponentSerializer.this.serializer.serializer().getAdapter(Component.class).write(out, this.component);
        }
    }
}

