/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shared.command;

import gg.mineads.monitor.shadow.incendo.cloud.CommandManager;
import gg.mineads.monitor.shadow.incendo.cloud.annotations.AnnotationParser;
import gg.mineads.monitor.shadow.incendo.cloud.brigadier.BrigadierManagerHolder;
import gg.mineads.monitor.shadow.incendo.cloud.brigadier.BrigadierSetting;
import gg.mineads.monitor.shadow.incendo.cloud.brigadier.CloudBrigadierManager;
import gg.mineads.monitor.shadow.incendo.cloud.minecraft.extras.MinecraftExceptionHandler;
import gg.mineads.monitor.shadow.incendo.cloud.minecraft.extras.caption.ComponentCaptionFormatter;
import gg.mineads.monitor.shadow.incendo.cloud.translations.TranslationBundle;
import gg.mineads.monitor.shadow.incendo.cloud.translations.minecraft.extras.MinecraftExtrasTranslationBundle;
import gg.mineads.monitor.shared.AbstractMineAdsMonitorBootstrap;
import gg.mineads.monitor.shared.ComponentHelper;
import gg.mineads.monitor.shared.MineAdsMonitorPlugin;
import gg.mineads.monitor.shared.command.MineAdsCommand;
import gg.mineads.monitor.shared.command.PlatformCommandManager;
import gg.mineads.monitor.shared.command.sender.WrappedCommandSender;
import java.util.logging.Logger;
import lombok.Generated;

public abstract class MineAdsCommandManager<B extends AbstractMineAdsMonitorBootstrap>
implements PlatformCommandManager {
    @Generated
    private static final Logger log = Logger.getLogger(MineAdsCommandManager.class.getName());
    protected final B platformBootstrap;
    protected final MineAdsMonitorPlugin plugin;
    protected final CommandManager<WrappedCommandSender> commandManager;
    protected final AnnotationParser<WrappedCommandSender> annotationParser;

    public MineAdsCommandManager(B platformBootstrap, MineAdsMonitorPlugin plugin) {
        BrigadierManagerHolder holder;
        this.platformBootstrap = platformBootstrap;
        this.plugin = plugin;
        this.commandManager = this.createCommandManager(platformBootstrap);
        this.annotationParser = new AnnotationParser<WrappedCommandSender>(this.commandManager, WrappedCommandSender.class);
        CommandManager<WrappedCommandSender> commandManager = this.commandManager;
        if (commandManager instanceof BrigadierManagerHolder && (holder = (BrigadierManagerHolder)((Object)commandManager)).hasBrigadierManager()) {
            CloudBrigadierManager brigadierManager = holder.brigadierManager();
            brigadierManager.setNativeNumberSuggestions(true);
            brigadierManager.settings().set(BrigadierSetting.FORCE_EXECUTABLE, true);
        }
        this.commandManager.captionRegistry().registerProvider(TranslationBundle.core(WrappedCommandSender::getLocale));
        this.commandManager.captionRegistry().registerProvider(MinecraftExtrasTranslationBundle.minecraftExtras(WrappedCommandSender::getLocale));
        MinecraftExceptionHandler.create(ComponentHelper::commandSenderToAudience).defaultHandlers().captionFormatter(ComponentCaptionFormatter.miniMessage()).registerTo(this.commandManager);
    }

    protected abstract CommandManager<WrappedCommandSender> createCommandManager(B var1);

    @Override
    public void registerCommands() {
        if (this.plugin.getConfig().isDebug()) {
            log.info("[DEBUG] Registering MineAds commands");
        }
        this.annotationParser.parse(new MineAdsCommand(this.plugin, this.commandManager));
        if (this.plugin.getConfig().isDebug()) {
            log.info("[DEBUG] MineAds commands registered successfully");
        }
    }
}

