/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.configlib;

import gg.mineads.monitor.shadow.configlib.ConfigurationElements;
import gg.mineads.monitor.shadow.configlib.ConfigurationException;
import gg.mineads.monitor.shadow.configlib.ConfigurationProperties;
import gg.mineads.monitor.shadow.configlib.Reflect;
import gg.mineads.monitor.shadow.configlib.TypeSerializer;
import gg.mineads.monitor.shadow.configlib.Validator;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Class;
import gg.mineads.monitor.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

final class RecordSerializer<R>
extends TypeSerializer<R, ConfigurationElements.RecordComponentElement> {
    RecordSerializer(Class<R> recordType, ConfigurationProperties properties) {
        super(Validator.requireRecord(recordType), properties);
    }

    @Override
    public R deserialize(Map<?, ?> serializedConfiguration) {
        Object[] ctorArgs = this.deserializeConfigurationElements(serializedConfiguration);
        Object result = Reflect.callCanonicalConstructor(this.type, ctorArgs);
        return this.postProcessor.apply(result);
    }

    @Override
    protected void requireSerializableElements() {
        if (this.serializers.isEmpty()) {
            String msg = J_L_String.formatted("Record type '%s' does not define any components.", this.type.getSimpleName());
            throw new ConfigurationException(msg);
        }
    }

    @Override
    protected String baseDeserializeExceptionMessage(ConfigurationElements.RecordComponentElement element, Object value) {
        return J_L_String.formatted("Deserialization of value '%s' with type '%s' for component '%s' of record '%s' failed.", value, value.getClass(), element.element(), element.declaringType());
    }

    @Override
    protected List<ConfigurationElements.RecordComponentElement> elements() {
        return J_U_S_Stream.toList(Arrays.stream(J_L_Class.getRecordComponents(this.type)).map(ConfigurationElements.RecordComponentElement::new));
    }

    @Override
    R newDefaultInstance() {
        return (R)(Reflect.hasDefaultConstructor(this.type) ? Reflect.callNoParamConstructor(this.type) : Reflect.callCanonicalConstructorWithDefaultValues(this.type));
    }

    Class<R> getRecordType() {
        return this.type;
    }

    @Override
    protected Object getDefaultValueOf(ConfigurationElements.RecordComponentElement element) {
        return Reflect.getDefaultValue(element.type());
    }
}

