/*
 * Decompiled with CFR 0.152.
 */
package gg.mineads.monitor.shadow.incendo.cloud.caption;

import gg.mineads.monitor.shadow.annotations.apiguardian.api.API;
import gg.mineads.monitor.shadow.incendo.cloud.caption.Caption;
import gg.mineads.monitor.shadow.incendo.cloud.caption.CaptionProvider;
import gg.mineads.monitor.shadow.incendo.cloud.caption.CaptionRegistry;
import java.util.LinkedList;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.common.returnsreceiver.qual.This;

@API(status=API.Status.INTERNAL)
public final class CaptionRegistryImpl<C>
implements CaptionRegistry<C> {
    private final LinkedList<@NonNull CaptionProvider<C>> providers = new LinkedList();

    CaptionRegistryImpl() {
    }

    @Override
    public @NonNull String caption(@NonNull Caption caption, @NonNull C sender) {
        for (CaptionProvider captionProvider : this.providers) {
            String result = captionProvider.provide(caption, sender);
            if (result == null) continue;
            return result;
        }
        throw new IllegalArgumentException(String.format("There is no caption stored with key '%s'", caption));
    }

    @Override
    public @This @NonNull CaptionRegistry<C> registerProvider(@NonNull CaptionProvider<C> provider) {
        this.providers.addFirst(provider);
        return this;
    }
}

